/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast;

import com.github.javaparser.HasParentNode;
import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.UserDataKey;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.observing.AstObserver;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.observing.PropagatingAstObserver;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.EqualsVisitor;
import com.github.javaparser.ast.visitor.Visitable;
import com.github.javaparser.printer.PrettyPrinter;
import com.github.javaparser.printer.PrettyPrinterConfiguration;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public abstract class Node
implements Cloneable,
HasParentNode<Node>,
Visitable {
    public static Comparator<Node> NODE_BY_BEGIN_POSITION = (a, b) -> a.getBegin().compareTo(b.getBegin());
    private static final PrettyPrinter toStringPrinter = new PrettyPrinter(new PrettyPrinterConfiguration());
    protected static final PrettyPrinterConfiguration prettyPrinterNoCommentsConfiguration = new PrettyPrinterConfiguration().setPrintComments(false);
    private Range range;
    private Node parentNode;
    private List<Node> childrenNodes = new LinkedList<Node>();
    private List<Comment> orphanComments = new LinkedList<Comment>();
    private IdentityHashMap<UserDataKey<?>, Object> userData = null;
    private Comment comment;
    private List<AstObserver> observers = new ArrayList<AstObserver>();
    public static final int ABSOLUTE_BEGIN_LINE = -1;
    public static final int ABSOLUTE_END_LINE = -2;

    public Node(Range range) {
        this.range = range;
    }

    public final Comment getComment() {
        return this.comment;
    }

    public Position getBegin() {
        return this.range.begin;
    }

    public Position getEnd() {
        return this.range.end;
    }

    public Node setBegin(Position begin) {
        this.range = this.range.withBegin(begin);
        return this;
    }

    public Node setEnd(Position end) {
        this.range = this.range.withEnd(end);
        return this;
    }

    public Range getRange() {
        return this.range;
    }

    public Node setRange(Range range) {
        this.notifyPropertyChange(ObservableProperty.RANGE, this.range, range);
        this.range = range;
        return this;
    }

    public final Node setComment(Comment comment) {
        if (comment != null && this instanceof Comment) {
            throw new RuntimeException("A comment can not be commented");
        }
        this.notifyPropertyChange(ObservableProperty.COMMENT, this.comment, comment);
        if (this.comment != null) {
            this.comment.setCommentedNode(null);
        }
        this.comment = comment;
        if (comment != null) {
            this.comment.setCommentedNode(this);
        }
        return this;
    }

    public final Node setLineComment(String comment) {
        return this.setComment(new LineComment(comment));
    }

    public final Node setBlockComment(String comment) {
        return this.setComment(new BlockComment(comment));
    }

    public final String toString() {
        return toStringPrinter.print(this);
    }

    public final String toString(PrettyPrinterConfiguration prettyPrinterConfiguration) {
        return new PrettyPrinter(prettyPrinterConfiguration).print(this);
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Node)) {
            return false;
        }
        return EqualsVisitor.equals(this, (Node)obj);
    }

    public Node clone() {
        return (Node)this.accept(new CloneVisitor(), null);
    }

    @Override
    public Optional<Node> getParentNode() {
        return Optional.ofNullable(this.parentNode);
    }

    public List<Node> getChildNodes() {
        return Collections.unmodifiableList(this.childrenNodes);
    }

    public <N extends Node> boolean containsWithin(N other) {
        return this.range.contains(other.getRange());
    }

    public void addOrphanComment(Comment comment) {
        this.orphanComments.add(comment);
        comment.setParentNode(this);
    }

    public List<Comment> getOrphanComments() {
        return this.orphanComments;
    }

    public List<Comment> getAllContainedComments() {
        LinkedList<Comment> comments = new LinkedList<Comment>();
        comments.addAll(this.getOrphanComments());
        for (Node child : this.getChildNodes()) {
            if (child.getComment() != null) {
                comments.add(child.getComment());
            }
            comments.addAll(child.getAllContainedComments());
        }
        return comments;
    }

    @Override
    public Node setParentNode(Node parentNode) {
        this.observers.forEach(o -> o.parentChange(this, this.parentNode, parentNode));
        if (this.parentNode != null) {
            this.parentNode.childrenNodes.remove(this);
        }
        this.parentNode = parentNode;
        if (this.parentNode != null) {
            this.parentNode.childrenNodes.add(this);
        }
        return this;
    }

    public boolean isPositionedAfter(Position position) {
        return this.range.isAfter(position);
    }

    public boolean isPositionedBefore(Position position) {
        return this.range.isBefore(position);
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void tryAddImportToParentCompilationUnit(Class<?> clazz) {
        CompilationUnit parentNode = this.getAncestorOfType(CompilationUnit.class);
        if (parentNode != null) {
            parentNode.addImport(clazz);
        }
    }

    public <N extends Node> List<N> getNodesByType(Class<N> clazz) {
        ArrayList<N> nodes = new ArrayList<N>();
        for (Node child : this.getChildNodes()) {
            if (clazz.isInstance(child)) {
                nodes.add(clazz.cast(child));
            }
            nodes.addAll(child.getNodesByType(clazz));
        }
        return nodes;
    }

    public <M> M getUserData(UserDataKey<M> key) {
        if (this.userData == null) {
            return null;
        }
        return (M)this.userData.get(key);
    }

    public <M> void setUserData(UserDataKey<M> key, M object) {
        if (this.userData == null) {
            this.userData = new IdentityHashMap();
        }
        this.userData.put(key, object);
    }

    public boolean remove() {
        Node parentNode = this.parentNode;
        if (parentNode == null) {
            return false;
        }
        boolean success = false;
        for (Class<?> parentClass = parentNode.getClass(); parentClass != Object.class; parentClass = parentClass.getSuperclass()) {
            for (Field f : parentClass.getDeclaredFields()) {
                f.setAccessible(true);
                try {
                    Collection l;
                    Object object = f.get(parentNode);
                    if (object == null) continue;
                    if (Collection.class.isAssignableFrom(object.getClass())) {
                        l = (Collection)object;
                        boolean remove = l.remove(this);
                        success |= remove;
                        continue;
                    }
                    if (NodeList.class.isAssignableFrom(object.getClass())) {
                        l = (NodeList)object;
                        success |= ((NodeList)l).remove(this);
                        continue;
                    }
                    if (Optional.class.equals(f.getType())) {
                        Optional opt = (Optional)object;
                        if (!opt.isPresent() || opt.get() != this) continue;
                        f.set(parentNode, Optional.empty());
                        continue;
                    }
                    if (object != this) continue;
                    f.set(parentNode, null);
                    success |= true;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException("Error while removing " + this.getClass().getSimpleName(), e);
                }
            }
        }
        this.setParentNode(null);
        return success;
    }

    @Override
    public Node getParentNodeForChildren() {
        return this;
    }

    protected void setAsParentNodeOf(NodeList<? extends Node> list) {
        if (list != null) {
            list.setParentNode(this.getParentNodeForChildren());
        }
    }

    protected <P> void notifyPropertyChange(ObservableProperty property, P oldValue, P newValue) {
        this.observers.forEach(o -> o.propertyChange(this, property, oldValue, newValue));
    }

    @Override
    public void unregister(AstObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void register(AstObserver observer) {
        this.observers.add(observer);
    }

    public void register(AstObserver observer, ObserverRegistrationMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode should be not null");
        }
        switch (mode) {
            case JUST_THIS_NODE: {
                this.register(observer);
                break;
            }
            case THIS_NODE_AND_EXISTING_DESCENDANTS: {
                this.registerForSubtree(observer);
                break;
            }
            case SELF_PROPAGATING: {
                this.registerForSubtree(PropagatingAstObserver.transformInPropagatingObserver(observer));
                break;
            }
            default: {
                throw new UnsupportedOperationException("This mode is not supported: " + (Object)((Object)mode));
            }
        }
    }

    public void registerForSubtree(AstObserver observer) {
        this.register(observer);
        this.getChildNodes().forEach(c -> c.registerForSubtree(observer));
        this.getNodeLists().forEach(nl -> nl.register(observer));
    }

    @Override
    public boolean isRegistered(AstObserver observer) {
        return this.observers.contains(observer);
    }

    public List<NodeList<?>> getNodeLists() {
        return Collections.emptyList();
    }

    public static enum ObserverRegistrationMode {
        JUST_THIS_NODE,
        THIS_NODE_AND_EXISTING_DESCENDANTS,
        SELF_PROPAGATING;

    }
}

