/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;

public final class FieldAccessExpr
extends Expression
implements NodeWithTypeArguments<FieldAccessExpr> {
    private Expression scope;
    private NodeList<Type<?>> typeArguments;
    private NameExpr field;

    public FieldAccessExpr() {
        this(Range.UNKNOWN, new ThisExpr(), new NodeList(), new NameExpr());
    }

    public FieldAccessExpr(Expression scope, String field) {
        this(Range.UNKNOWN, scope, new NodeList(), NameExpr.name(field));
    }

    public FieldAccessExpr(Range range, Expression scope, NodeList<Type<?>> typeArguments, NameExpr field) {
        super(range);
        this.setScope(scope);
        this.setTypeArguments((NodeList)typeArguments);
        this.setFieldExpr(field);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public String getField() {
        return this.field.getName();
    }

    public NameExpr getFieldExpr() {
        return this.field;
    }

    public Expression getScope() {
        return this.scope;
    }

    public FieldAccessExpr setField(String field) {
        this.setFieldExpr(new NameExpr(field));
        return this;
    }

    public FieldAccessExpr setFieldExpr(NameExpr field) {
        this.field = field;
        this.setAsParentNodeOf(this.field);
        return this;
    }

    public FieldAccessExpr setScope(Expression scope) {
        this.scope = scope;
        this.setAsParentNodeOf(this.scope);
        return this;
    }

    @Override
    public NodeList<Type<?>> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public FieldAccessExpr setTypeArguments(NodeList<Type<?>> types) {
        this.typeArguments = types;
        this.setAsParentNodeOf(this.typeArguments);
        return this;
    }
}

