/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.ArrayBracketPair;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithBlockStmt;
import com.github.javaparser.ast.nodeTypes.NodeWithDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithElementType;
import com.github.javaparser.ast.nodeTypes.NodeWithJavaDoc;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.nodeTypes.NodeWithParameters;
import com.github.javaparser.ast.nodeTypes.NodeWithThrowable;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;

public final class MethodDeclaration
extends BodyDeclaration<MethodDeclaration>
implements NodeWithJavaDoc<MethodDeclaration>,
NodeWithDeclaration,
NodeWithName<MethodDeclaration>,
NodeWithType<MethodDeclaration, Type<?>>,
NodeWithElementType<MethodDeclaration>,
NodeWithModifiers<MethodDeclaration>,
NodeWithParameters<MethodDeclaration>,
NodeWithThrowable<MethodDeclaration>,
NodeWithBlockStmt<MethodDeclaration>,
NodeWithTypeParameters<MethodDeclaration> {
    private EnumSet<Modifier> modifiers;
    private NodeList<TypeParameter> typeParameters;
    private Type elementType;
    private NameExpr name;
    private NodeList<Parameter> parameters;
    private NodeList<ReferenceType<?>> throws_;
    private BlockStmt body;
    private boolean isDefault;
    private NodeList<ArrayBracketPair> arrayBracketPairsAfterType;
    private NodeList<ArrayBracketPair> arrayBracketPairsAfterParameterList;

    public MethodDeclaration() {
        this(Range.UNKNOWN, EnumSet.noneOf(Modifier.class), new NodeList<AnnotationExpr>(), new NodeList<TypeParameter>(), new ClassOrInterfaceType(), new NodeList<ArrayBracketPair>(), new NameExpr(), false, new NodeList<Parameter>(), new NodeList<ArrayBracketPair>(), new NodeList(), new BlockStmt());
    }

    public MethodDeclaration(EnumSet<Modifier> modifiers, Type elementType, String name) {
        this(Range.UNKNOWN, modifiers, new NodeList<AnnotationExpr>(), new NodeList<TypeParameter>(), elementType, new NodeList<ArrayBracketPair>(), NameExpr.name(name), false, new NodeList<Parameter>(), new NodeList<ArrayBracketPair>(), new NodeList(), new BlockStmt());
    }

    public MethodDeclaration(EnumSet<Modifier> modifiers, Type elementType, String name, NodeList<Parameter> parameters) {
        this(Range.UNKNOWN, modifiers, new NodeList<AnnotationExpr>(), new NodeList<TypeParameter>(), elementType, new NodeList<ArrayBracketPair>(), NameExpr.name(name), false, parameters, new NodeList<ArrayBracketPair>(), new NodeList(), new BlockStmt());
    }

    public MethodDeclaration(EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, Type elementType, NodeList<ArrayBracketPair> arrayBracketPairsAfterElementType, String name, boolean isDefault, NodeList<Parameter> parameters, NodeList<ArrayBracketPair> arrayBracketPairsAfterParameterList, NodeList<ReferenceType<?>> throws_, BlockStmt body) {
        this(Range.UNKNOWN, modifiers, annotations, typeParameters, elementType, arrayBracketPairsAfterElementType, NameExpr.name(name), isDefault, parameters, arrayBracketPairsAfterParameterList, throws_, body);
    }

    public MethodDeclaration(Range range, EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, Type elementType, NodeList<ArrayBracketPair> arrayBracketPairsAfterElementType, NameExpr nameExpr, boolean isDefault, NodeList<Parameter> parameters, NodeList<ArrayBracketPair> arrayBracketPairsAfterParameterList, NodeList<ReferenceType<?>> throws_, BlockStmt body) {
        super(range, annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setTypeParameters((NodeList)typeParameters);
        this.setElementType(elementType);
        this.setNameExpr(nameExpr);
        this.setParameters((NodeList)parameters);
        this.setArrayBracketPairsAfterElementType((NodeList)arrayBracketPairsAfterElementType);
        this.setArrayBracketPairsAfterParameterList(arrayBracketPairsAfterParameterList);
        this.setThrows((NodeList)throws_);
        this.setBody(body);
        this.setDefault(isDefault);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public BlockStmt getBody() {
        return this.body;
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getName() {
        return this.name.getName();
    }

    public NameExpr getNameExpr() {
        return this.name;
    }

    @Override
    public NodeList<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public NodeList<ReferenceType<?>> getThrows() {
        return this.throws_;
    }

    @Override
    public Type getType() {
        return ArrayType.wrapInArrayTypes(this.getElementType(), this.getArrayBracketPairsAfterElementType(), this.getArrayBracketPairsAfterParameterList());
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public NodeList<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public MethodDeclaration setBody(BlockStmt body) {
        this.body = body;
        this.setAsParentNodeOf(this.body);
        return this;
    }

    @Override
    public MethodDeclaration setModifiers(EnumSet<Modifier> modifiers) {
        this.modifiers = Utils.assertNotNull(modifiers);
        return this;
    }

    @Override
    public MethodDeclaration setName(String name) {
        this.setNameExpr(new NameExpr(Utils.assertNotNull(name)));
        return this;
    }

    public MethodDeclaration setNameExpr(NameExpr name) {
        this.name = Utils.assertNotNull(name);
        this.setAsParentNodeOf(this.name);
        return this;
    }

    @Override
    public MethodDeclaration setParameters(NodeList<Parameter> parameters) {
        this.parameters = Utils.assertNotNull(parameters);
        this.setAsParentNodeOf(this.parameters);
        return this;
    }

    @Override
    public MethodDeclaration setThrows(NodeList<ReferenceType<?>> throws_) {
        this.throws_ = Utils.assertNotNull(throws_);
        this.setAsParentNodeOf(this.throws_);
        return this;
    }

    @Override
    public MethodDeclaration setType(Type type) {
        Pair<Type, NodeList<ArrayBracketPair>> typeListPair = ArrayType.unwrapArrayTypes(Utils.assertNotNull(type));
        this.setElementType((Type)typeListPair.a);
        this.setArrayBracketPairsAfterElementType((NodeList)typeListPair.b);
        this.setArrayBracketPairsAfterParameterList(new NodeList<ArrayBracketPair>());
        return this;
    }

    @Override
    public MethodDeclaration setElementType(Type elementType) {
        this.elementType = Utils.assertNotNull(elementType);
        this.setAsParentNodeOf(this.elementType);
        return this;
    }

    @Override
    public MethodDeclaration setTypeParameters(NodeList<TypeParameter> typeParameters) {
        this.typeParameters = Utils.assertNotNull(typeParameters);
        this.setAsParentNodeOf(typeParameters);
        return this;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public MethodDeclaration setDefault(boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    @Override
    public String getDeclarationAsString() {
        return this.getDeclarationAsString(true, true, true);
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows) {
        return this.getDeclarationAsString(includingModifiers, includingThrows, true);
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows, boolean includingParameterName) {
        StringBuilder sb = new StringBuilder();
        if (includingModifiers) {
            AccessSpecifier accessSpecifier = Modifier.getAccessSpecifier(this.getModifiers());
            sb.append(accessSpecifier.getCodeRepresenation());
            sb.append(accessSpecifier == AccessSpecifier.DEFAULT ? "" : " ");
            if (this.getModifiers().contains((Object)Modifier.STATIC)) {
                sb.append("static ");
            }
            if (this.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                sb.append("abstract ");
            }
            if (this.getModifiers().contains((Object)Modifier.FINAL)) {
                sb.append("final ");
            }
            if (this.getModifiers().contains((Object)Modifier.NATIVE)) {
                sb.append("native ");
            }
            if (this.getModifiers().contains((Object)Modifier.SYNCHRONIZED)) {
                sb.append("synchronized ");
            }
        }
        sb.append(this.getElementType().toString(prettyPrinterNoCommentsConfiguration));
        sb.append(" ");
        sb.append(this.getName());
        sb.append("(");
        boolean firstParam = true;
        for (Parameter param : this.getParameters()) {
            if (firstParam) {
                firstParam = false;
            } else {
                sb.append(", ");
            }
            if (includingParameterName) {
                sb.append(param.toString(prettyPrinterNoCommentsConfiguration));
                continue;
            }
            sb.append(param.getElementType().toString(prettyPrinterNoCommentsConfiguration));
            if (!param.isVarArgs()) continue;
            sb.append("...");
        }
        sb.append(")");
        if (includingThrows) {
            boolean firstThrow = true;
            for (ReferenceType<?> thr : this.getThrows()) {
                if (firstThrow) {
                    firstThrow = false;
                    sb.append(" throws ");
                } else {
                    sb.append(", ");
                }
                sb.append(thr.toString(prettyPrinterNoCommentsConfiguration));
            }
        }
        return sb.toString();
    }

    @Override
    public JavadocComment getJavaDoc() {
        if (this.getComment() instanceof JavadocComment) {
            return (JavadocComment)this.getComment();
        }
        return null;
    }

    @Override
    public NodeList<ArrayBracketPair> getArrayBracketPairsAfterElementType() {
        return this.arrayBracketPairsAfterType;
    }

    @Override
    public MethodDeclaration setArrayBracketPairsAfterElementType(NodeList<ArrayBracketPair> arrayBracketPairsAfterType) {
        this.arrayBracketPairsAfterType = Utils.assertNotNull(arrayBracketPairsAfterType);
        this.setAsParentNodeOf(arrayBracketPairsAfterType);
        return this;
    }

    public NodeList<ArrayBracketPair> getArrayBracketPairsAfterParameterList() {
        return this.arrayBracketPairsAfterParameterList;
    }

    public MethodDeclaration setArrayBracketPairsAfterParameterList(NodeList<ArrayBracketPair> arrayBracketPairsAfterParameterList) {
        this.arrayBracketPairsAfterParameterList = Utils.assertNotNull(arrayBracketPairsAfterParameterList);
        this.setAsParentNodeOf(arrayBracketPairsAfterParameterList);
        return this;
    }
}

