/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.ArrayBracketPair;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithElementType;
import com.github.javaparser.ast.nodeTypes.NodeWithJavaDoc;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithVariables;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;

public final class FieldDeclaration
extends BodyDeclaration<FieldDeclaration>
implements NodeWithJavaDoc<FieldDeclaration>,
NodeWithElementType<FieldDeclaration>,
NodeWithModifiers<FieldDeclaration>,
NodeWithVariables<FieldDeclaration> {
    private EnumSet<Modifier> modifiers;
    private Type<?> elementType;
    private NodeList<VariableDeclarator> variables;
    private NodeList<ArrayBracketPair> arrayBracketPairsAfterElementType;

    public FieldDeclaration() {
        this(Range.UNKNOWN, EnumSet.noneOf(Modifier.class), new NodeList<AnnotationExpr>(), new ClassOrInterfaceType(), new NodeList<VariableDeclarator>(), new NodeList<ArrayBracketPair>());
    }

    public FieldDeclaration(EnumSet<Modifier> modifiers, Type<?> elementType, VariableDeclarator variable) {
        this(Range.UNKNOWN, modifiers, new NodeList<AnnotationExpr>(), elementType, NodeList.nodeList((Node[])new VariableDeclarator[]{variable}), new NodeList<ArrayBracketPair>());
    }

    public FieldDeclaration(EnumSet<Modifier> modifiers, Type<?> elementType, NodeList<VariableDeclarator> variables) {
        this(Range.UNKNOWN, modifiers, new NodeList<AnnotationExpr>(), elementType, variables, new NodeList<ArrayBracketPair>());
    }

    public FieldDeclaration(EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, Type<?> elementType, NodeList<ArrayBracketPair> arrayBracketPairsAfterElementType, NodeList<VariableDeclarator> variables) {
        this(Range.UNKNOWN, modifiers, annotations, elementType, variables, arrayBracketPairsAfterElementType);
    }

    public FieldDeclaration(Range range, EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, Type<?> elementType, NodeList<VariableDeclarator> variables, NodeList<ArrayBracketPair> arrayBracketPairsAfterElementType) {
        super(range, annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setElementType((Type)elementType);
        this.setVariables((NodeList)variables);
        this.setArrayBracketPairsAfterElementType((NodeList)arrayBracketPairsAfterElementType);
    }

    public FieldDeclaration(EnumSet<Modifier> modifiers, Type<?> type, String name) {
        this(Utils.assertNotNull(modifiers), Utils.assertNotNull(type), new VariableDeclarator(new VariableDeclaratorId(Utils.assertNotNull(name))));
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public NodeList<VariableDeclarator> getVariables() {
        return this.variables;
    }

    @Override
    public FieldDeclaration setModifiers(EnumSet<Modifier> modifiers) {
        this.modifiers = Utils.assertNotNull(modifiers);
        return this;
    }

    @Override
    public FieldDeclaration setVariables(NodeList<VariableDeclarator> variables) {
        this.variables = Utils.assertNotNull(variables);
        this.setAsParentNodeOf(this.variables);
        return this;
    }

    @Override
    public JavadocComment getJavaDoc() {
        if (this.getComment() instanceof JavadocComment) {
            return (JavadocComment)this.getComment();
        }
        return null;
    }

    public MethodDeclaration createGetter() {
        if (this.getVariables().size() != 1) {
            throw new IllegalStateException("You can use this only when the field declares only 1 variable name");
        }
        ClassOrInterfaceDeclaration parentClass = this.getAncestorOfType(ClassOrInterfaceDeclaration.class);
        EnumDeclaration parentEnum = this.getAncestorOfType(EnumDeclaration.class);
        if (parentClass == null && parentEnum == null || parentClass != null && parentClass.isInterface()) {
            throw new IllegalStateException("You can use this only when the field is attached to a class or an enum");
        }
        VariableDeclarator variable = this.getVariables().get(0);
        String fieldName = variable.getId().getName();
        String fieldNameUpper = fieldName.toUpperCase().substring(0, 1) + fieldName.substring(1, fieldName.length());
        MethodDeclaration getter = parentClass != null ? parentClass.addMethod("get" + fieldNameUpper, Modifier.PUBLIC) : parentEnum.addMethod("get" + fieldNameUpper, Modifier.PUBLIC);
        getter.setType(variable.getType());
        BlockStmt blockStmt = new BlockStmt();
        getter.setBody(blockStmt);
        blockStmt.addStatement(new ReturnStmt(NameExpr.name(fieldName)));
        return getter;
    }

    public MethodDeclaration createSetter() {
        if (this.getVariables().size() != 1) {
            throw new IllegalStateException("You can use this only when the field declares only 1 variable name");
        }
        ClassOrInterfaceDeclaration parentClass = this.getAncestorOfType(ClassOrInterfaceDeclaration.class);
        EnumDeclaration parentEnum = this.getAncestorOfType(EnumDeclaration.class);
        if (parentClass == null && parentEnum == null || parentClass != null && parentClass.isInterface()) {
            throw new IllegalStateException("You can use this only when the field is attached to a class or an enum");
        }
        VariableDeclarator variable = this.getVariables().get(0);
        String fieldName = variable.getId().getName();
        String fieldNameUpper = fieldName.toUpperCase().substring(0, 1) + fieldName.substring(1, fieldName.length());
        MethodDeclaration setter = parentClass != null ? parentClass.addMethod("set" + fieldNameUpper, Modifier.PUBLIC) : parentEnum.addMethod("set" + fieldNameUpper, Modifier.PUBLIC);
        setter.setType(VoidType.VOID_TYPE);
        setter.getParameters().add(new Parameter(variable.getType(), new VariableDeclaratorId(fieldName)));
        BlockStmt blockStmt2 = new BlockStmt();
        setter.setBody(blockStmt2);
        blockStmt2.addStatement(new AssignExpr(new NameExpr("this." + fieldName), new NameExpr(fieldName), AssignExpr.Operator.assign));
        return setter;
    }

    @Override
    public Type<?> getElementType() {
        return this.elementType;
    }

    @Override
    public FieldDeclaration setElementType(Type<?> elementType) {
        this.elementType = Utils.assertNotNull(elementType);
        this.setAsParentNodeOf(this.elementType);
        return this;
    }

    @Override
    public NodeList<ArrayBracketPair> getArrayBracketPairsAfterElementType() {
        return this.arrayBracketPairsAfterElementType;
    }

    @Override
    public FieldDeclaration setArrayBracketPairsAfterElementType(NodeList<ArrayBracketPair> arrayBracketPairsAfterType) {
        this.arrayBracketPairsAfterElementType = Utils.assertNotNull(arrayBracketPairsAfterType);
        this.setAsParentNodeOf(arrayBracketPairsAfterType);
        return this;
    }
}

