/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithBlockStmt;
import com.github.javaparser.ast.nodeTypes.NodeWithDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithJavaDoc;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.nodeTypes.NodeWithParameters;
import com.github.javaparser.ast.nodeTypes.NodeWithThrowable;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;

public final class ConstructorDeclaration
extends BodyDeclaration<ConstructorDeclaration>
implements NodeWithJavaDoc<ConstructorDeclaration>,
NodeWithDeclaration,
NodeWithName<ConstructorDeclaration>,
NodeWithModifiers<ConstructorDeclaration>,
NodeWithParameters<ConstructorDeclaration>,
NodeWithThrowable<ConstructorDeclaration>,
NodeWithBlockStmt<ConstructorDeclaration>,
NodeWithTypeParameters<ConstructorDeclaration> {
    private EnumSet<Modifier> modifiers;
    private NodeList<TypeParameter> typeParameters;
    private NameExpr name;
    private NodeList<Parameter> parameters;
    private NodeList<ReferenceType<?>> throws_;
    private BlockStmt body;

    public ConstructorDeclaration() {
        this(Range.UNKNOWN, EnumSet.noneOf(Modifier.class), new NodeList<AnnotationExpr>(), new NodeList<TypeParameter>(), new NameExpr(), new NodeList<Parameter>(), new NodeList(), new BlockStmt());
    }

    public ConstructorDeclaration(EnumSet<Modifier> modifiers, String name) {
        this(Range.UNKNOWN, modifiers, new NodeList<AnnotationExpr>(), new NodeList<TypeParameter>(), NameExpr.name(name), new NodeList<Parameter>(), new NodeList(), new BlockStmt());
    }

    public ConstructorDeclaration(EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, NameExpr name, NodeList<Parameter> parameters, NodeList<ReferenceType<?>> throws_, BlockStmt block) {
        this(Range.UNKNOWN, modifiers, annotations, typeParameters, name, parameters, throws_, block);
    }

    public ConstructorDeclaration(Range range, EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<TypeParameter> typeParameters, NameExpr name, NodeList<Parameter> parameters, NodeList<ReferenceType<?>> throws_, BlockStmt block) {
        super(range, annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setTypeParameters((NodeList)typeParameters);
        this.setNameExpr(name);
        this.setParameters((NodeList)parameters);
        this.setThrows((NodeList)throws_);
        this.setBody(block);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getName() {
        return this.name.getName();
    }

    public NameExpr getNameExpr() {
        return this.name;
    }

    @Override
    public NodeList<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public NodeList<ReferenceType<?>> getThrows() {
        return this.throws_;
    }

    @Override
    public NodeList<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public ConstructorDeclaration setModifiers(EnumSet<Modifier> modifiers) {
        this.modifiers = Utils.assertNotNull(modifiers);
        return this;
    }

    @Override
    public ConstructorDeclaration setName(String name) {
        this.setNameExpr(new NameExpr(Utils.assertNotNull(name)));
        return this;
    }

    public ConstructorDeclaration setNameExpr(NameExpr name) {
        this.name = Utils.assertNotNull(name);
        this.setAsParentNodeOf(this.name);
        return this;
    }

    @Override
    public ConstructorDeclaration setParameters(NodeList<Parameter> parameters) {
        this.parameters = Utils.assertNotNull(parameters);
        this.setAsParentNodeOf(this.parameters);
        return this;
    }

    @Override
    public ConstructorDeclaration setThrows(NodeList<ReferenceType<?>> throws_) {
        this.throws_ = Utils.assertNotNull(throws_);
        this.setAsParentNodeOf(this.throws_);
        return this;
    }

    @Override
    public ConstructorDeclaration setTypeParameters(NodeList<TypeParameter> typeParameters) {
        this.typeParameters = Utils.assertNotNull(typeParameters);
        this.setAsParentNodeOf(this.typeParameters);
        return this;
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows, boolean includingParameterName) {
        StringBuilder sb = new StringBuilder();
        if (includingModifiers) {
            AccessSpecifier accessSpecifier = Modifier.getAccessSpecifier(this.getModifiers());
            sb.append(accessSpecifier.getCodeRepresenation());
            sb.append(accessSpecifier == AccessSpecifier.DEFAULT ? "" : " ");
        }
        sb.append(this.getName());
        sb.append("(");
        boolean firstParam = true;
        for (Parameter param : this.getParameters()) {
            if (firstParam) {
                firstParam = false;
            } else {
                sb.append(", ");
            }
            if (includingParameterName) {
                sb.append(param.toString(prettyPrinterNoCommentsConfiguration));
                continue;
            }
            sb.append(param.getElementType().toString(prettyPrinterNoCommentsConfiguration));
        }
        sb.append(")");
        if (includingThrows) {
            boolean firstThrow = true;
            for (ReferenceType<?> thr : this.getThrows()) {
                if (firstThrow) {
                    firstThrow = false;
                    sb.append(" throws ");
                } else {
                    sb.append(", ");
                }
                sb.append(thr.toString(prettyPrinterNoCommentsConfiguration));
            }
        }
        return sb.toString();
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows) {
        return this.getDeclarationAsString(includingModifiers, includingThrows, true);
    }

    @Override
    public String getDeclarationAsString() {
        return this.getDeclarationAsString(true, true, true);
    }

    @Override
    public JavadocComment getJavaDoc() {
        if (this.getComment() instanceof JavadocComment) {
            return (JavadocComment)this.getComment();
        }
        return null;
    }

    @Override
    public BlockStmt getBody() {
        return this.body;
    }

    @Override
    public ConstructorDeclaration setBody(BlockStmt body) {
        this.body = Utils.assertNotNull(body);
        this.setAsParentNodeOf(body);
        return this;
    }
}

