/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.utils;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class Utils {
    public static final String EOL = System.getProperty("line.separator");

    public static <T> T assertNotNull(T o) {
        if (o == null) {
            throw new AssertionError((Object)"A reference was unexpectedly null.");
        }
        return o;
    }

    public static String escapeEndOfLines(String string) {
        StringBuilder escapedString = new StringBuilder();
        block4: for (char c : string.toCharArray()) {
            switch (c) {
                case '\n': {
                    escapedString.append("\\n");
                    continue block4;
                }
                case '\r': {
                    escapedString.append("\\r");
                    continue block4;
                }
                default: {
                    escapedString.append(c);
                }
            }
        }
        return escapedString.toString();
    }

    public static String readerToString(Reader reader) throws IOException {
        int numChars;
        StringBuilder result = new StringBuilder();
        char[] buffer = new char[8192];
        while ((numChars = reader.read(buffer, 0, buffer.length)) > 0) {
            result.append(buffer, 0, numChars);
        }
        return result.toString();
    }

    public static <T> List<T> arrayToList(T[] array) {
        LinkedList list = new LinkedList();
        Collections.addAll(list, array);
        return list;
    }

    public static <T> Optional<T> some(T t) {
        return Optional.of(t);
    }

    public static <T> Optional<T> option(T t) {
        return Optional.ofNullable(t);
    }

    public static <T> Optional<T> none() {
        return Optional.empty();
    }
}

