/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.visitor;

import com.github.javaparser.ast.ArrayBracketPair;
import com.github.javaparser.ast.ArrayCreationLevel;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EmptyMemberDeclaration;
import com.github.javaparser.ast.body.EmptyTypeDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.IntegerLiteralMinValueExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralMinValueExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.QualifiedNameExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.SuperExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.imports.EmptyImportDeclaration;
import com.github.javaparser.ast.imports.SingleStaticImportDeclaration;
import com.github.javaparser.ast.imports.SingleTypeImportDeclaration;
import com.github.javaparser.ast.imports.StaticImportOnDemandDeclaration;
import com.github.javaparser.ast.imports.TypeImportOnDemandDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.stmt.AssertStmt;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.BreakStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ContinueStmt;
import com.github.javaparser.ast.stmt.DoStmt;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.ForeachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.SwitchEntryStmt;
import com.github.javaparser.ast.stmt.SwitchStmt;
import com.github.javaparser.ast.stmt.SynchronizedStmt;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.stmt.TypeDeclarationStmt;
import com.github.javaparser.ast.stmt.WhileStmt;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.IntersectionType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.type.UnionType;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.type.WildcardType;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.PositionUtils;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;

public class DumpVisitor
implements VoidVisitor<Object> {
    private boolean printComments;
    private final SourcePrinter printer = this.createSourcePrinter();

    public DumpVisitor() {
        this(true);
    }

    public DumpVisitor(boolean printComments) {
        this.printComments = printComments;
    }

    protected SourcePrinter createSourcePrinter() {
        return new SourcePrinter("    ");
    }

    public String getSource() {
        return this.printer.getSource();
    }

    private void printModifiers(EnumSet<Modifier> modifiers) {
        if (modifiers.size() > 0) {
            this.printer.print(modifiers.stream().map(Modifier::getLib).collect(Collectors.joining(" ")) + " ");
        }
    }

    private void printMembers(NodeList<BodyDeclaration<?>> members, Object arg) {
        for (BodyDeclaration<?> member : members) {
            this.printer.printLn();
            member.accept(this, arg);
            this.printer.printLn();
        }
    }

    private void printMemberAnnotations(NodeList<AnnotationExpr> annotations, Object arg) {
        if (annotations.isEmpty()) {
            return;
        }
        for (AnnotationExpr a : annotations) {
            a.accept(this, arg);
            this.printer.printLn();
        }
    }

    private void printAnnotations(NodeList<AnnotationExpr> annotations, boolean prefixWithASpace, Object arg) {
        if (annotations.isEmpty()) {
            return;
        }
        if (prefixWithASpace) {
            this.printer.print(" ");
        }
        for (AnnotationExpr annotation : annotations) {
            annotation.accept(this, arg);
            this.printer.print(" ");
        }
    }

    private void printTypeArgs(NodeWithTypeArguments<?> nodeWithTypeArguments, Object arg) {
        Optional<NodeList<Type<?>>> optionalTypeArguments = nodeWithTypeArguments.getTypeArguments();
        optionalTypeArguments.ifPresent(typeArguments -> {
            this.printer.print("<");
            Iterator i = typeArguments.iterator();
            while (i.hasNext()) {
                Type t = (Type)i.next();
                t.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        });
    }

    private void printTypeParameters(NodeList<TypeParameter> args, Object arg) {
        args.ifNotEmpty(tp -> {
            this.printer.print("<");
            Iterator i = tp.iterator();
            while (i.hasNext()) {
                TypeParameter t = (TypeParameter)i.next();
                t.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        });
    }

    private void printArguments(NodeList<Expression> args, Object arg) {
        this.printer.print("(");
        Iterator<Expression> i = args.iterator();
        while (i.hasNext()) {
            Expression e = i.next();
            e.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printer.print(")");
    }

    private void printJavaComment(Optional<? extends Comment> javacomment, Object arg) {
        javacomment.ifPresent(c -> c.accept(this, arg));
    }

    @Override
    public void visit(CompilationUnit n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getPackage().ifPresent(p -> p.accept(this, arg));
        n.getImports().accept(this, arg);
        if (!n.getImports().isEmpty()) {
            this.printer.printLn();
        }
        Iterator<TypeDeclaration<?>> i = n.getTypes().iterator();
        while (i.hasNext()) {
            i.next().accept(this, arg);
            this.printer.printLn();
            if (!i.hasNext()) continue;
            this.printer.printLn();
        }
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(PackageDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printAnnotations(n.getAnnotations(), false, arg);
        this.printer.print("package ");
        n.getName().accept(this, arg);
        this.printer.printLn(";");
        this.printer.printLn();
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(NameExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getName());
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(QualifiedNameExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getQualifier().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getName());
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration n, Object arg) {
        ClassOrInterfaceType c;
        Iterator<ClassOrInterfaceType> i;
        this.printJavaComment(n.getComment(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        if (n.isInterface()) {
            this.printer.print("interface ");
        } else {
            this.printer.print("class ");
        }
        this.printer.print(n.getName());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (!n.getExtends().isEmpty()) {
            this.printer.print(" extends ");
            i = n.getExtends().iterator();
            while (i.hasNext()) {
                c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (!n.getImplements().isEmpty()) {
            this.printer.print(" implements ");
            i = n.getImplements().iterator();
            while (i.hasNext()) {
                c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn(" {");
        this.printer.indent();
        this.printMembers(n.getMembers(), arg);
        this.printOrphanCommentsEnding(n);
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(EmptyTypeDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(";");
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(JavadocComment n, Object arg) {
        this.printer.print("/**");
        this.printer.print(n.getContent());
        this.printer.printLn("*/");
    }

    @Override
    public void visit(ClassOrInterfaceType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getScope().ifPresent(s -> {
            s.accept(this, arg);
            this.printer.print(".");
        });
        for (AnnotationExpr ae : n.getAnnotations()) {
            ae.accept(this, arg);
            this.printer.print(" ");
        }
        this.printer.print(n.getName());
        if (n.isUsingDiamondOperator()) {
            this.printer.print("<>");
        } else {
            this.printTypeArgs(n, arg);
        }
    }

    @Override
    public void visit(TypeParameter n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        for (AnnotationExpr ann : n.getAnnotations()) {
            ann.accept(this, arg);
            this.printer.print(" ");
        }
        this.printer.print(n.getName());
        n.getTypeBound().ifNotEmpty(tb -> {
            this.printer.print(" extends ");
            Iterator i = tb.iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType c = (ClassOrInterfaceType)i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(" & ");
            }
        });
    }

    @Override
    public void visit(PrimitiveType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printAnnotations(n.getAnnotations(), true, arg);
        switch (n.getType()) {
            case Boolean: {
                this.printer.print("boolean");
                break;
            }
            case Byte: {
                this.printer.print("byte");
                break;
            }
            case Char: {
                this.printer.print("char");
                break;
            }
            case Double: {
                this.printer.print("double");
                break;
            }
            case Float: {
                this.printer.print("float");
                break;
            }
            case Int: {
                this.printer.print("int");
                break;
            }
            case Long: {
                this.printer.print("long");
                break;
            }
            case Short: {
                this.printer.print("short");
            }
        }
    }

    @Override
    public void visit(ArrayType n, Object arg) {
        LinkedList<ArrayType> arrayTypeBuffer = new LinkedList<ArrayType>();
        Type type = n;
        while (type instanceof ArrayType) {
            ArrayType arrayType = type;
            arrayTypeBuffer.add(arrayType);
            type = arrayType.getComponentType();
        }
        ((Node)type).accept(this, arg);
        for (ArrayType arrayType : arrayTypeBuffer) {
            this.printAnnotations(arrayType.getAnnotations(), true, arg);
            this.printer.print("[]");
        }
    }

    @Override
    public void visit(ArrayCreationLevel n, Object arg) {
        this.printAnnotations(n.getAnnotations(), true, arg);
        this.printer.print("[");
        n.getDimension().ifPresent(d -> d.accept(this, arg));
        this.printer.print("]");
    }

    @Override
    public void visit(IntersectionType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printAnnotations(n.getAnnotations(), false, arg);
        boolean isFirst = true;
        for (ReferenceType<?> element : n.getElements()) {
            element.accept(this, arg);
            if (isFirst) {
                isFirst = false;
                continue;
            }
            this.printer.print(" & ");
        }
    }

    @Override
    public void visit(UnionType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printAnnotations(n.getAnnotations(), true, arg);
        boolean isFirst = true;
        for (ReferenceType<?> element : n.getElements()) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.printer.print(" | ");
            }
            element.accept(this, arg);
        }
    }

    @Override
    public void visit(WildcardType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printAnnotations(n.getAnnotations(), false, arg);
        this.printer.print("?");
        n.getExtends().ifPresent(e -> {
            this.printer.print(" extends ");
            e.accept(this, arg);
        });
        n.getSuper().ifPresent(s -> {
            this.printer.print(" super ");
            s.accept(this, arg);
        });
    }

    @Override
    public void visit(UnknownType n, Object arg) {
    }

    @Override
    public void visit(FieldDeclaration n, Object arg) {
        this.printOrphanCommentsBeforeThisChildNode(n);
        this.printJavaComment(n.getComment(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getElementType().accept(this, arg);
        for (ArrayBracketPair pair : n.getArrayBracketPairsAfterElementType()) {
            pair.accept(this, arg);
        }
        this.printer.print(" ");
        Iterator<VariableDeclarator> i = n.getVariables().iterator();
        while (i.hasNext()) {
            VariableDeclarator var = i.next();
            var.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printer.print(";");
    }

    @Override
    public void visit(VariableDeclarator n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getId().accept(this, arg);
        n.getInit().ifPresent(i -> {
            this.printer.print(" = ");
            i.accept(this, arg);
        });
    }

    @Override
    public void visit(VariableDeclaratorId n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getName());
        for (ArrayBracketPair pair : n.getArrayBracketPairsAfterId()) {
            pair.accept(this, arg);
        }
    }

    @Override
    public void visit(ArrayInitializerExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("{");
        n.getValues().ifNotEmpty(v -> {
            this.printer.print(" ");
            Iterator i = v.iterator();
            while (i.hasNext()) {
                Expression expr = (Expression)i.next();
                expr.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(" ");
        });
        this.printer.print("}");
    }

    @Override
    public void visit(VoidType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printAnnotations(n.getAnnotations(), false, arg);
        this.printer.print("void");
    }

    @Override
    public void visit(ArrayAccessExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getName().accept(this, arg);
        this.printer.print("[");
        n.getIndex().accept(this, arg);
        this.printer.print("]");
    }

    @Override
    public void visit(ArrayCreationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("new ");
        n.getElementType().accept(this, arg);
        for (ArrayCreationLevel level : n.getLevels()) {
            level.accept(this, arg);
        }
        n.getInitializer().ifPresent(i -> {
            this.printer.print(" ");
            i.accept(this, arg);
        });
    }

    @Override
    public void visit(AssignExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getTarget().accept(this, arg);
        this.printer.print(" ");
        switch (n.getOperator()) {
            case assign: {
                this.printer.print("=");
                break;
            }
            case and: {
                this.printer.print("&=");
                break;
            }
            case or: {
                this.printer.print("|=");
                break;
            }
            case xor: {
                this.printer.print("^=");
                break;
            }
            case plus: {
                this.printer.print("+=");
                break;
            }
            case minus: {
                this.printer.print("-=");
                break;
            }
            case rem: {
                this.printer.print("%=");
                break;
            }
            case slash: {
                this.printer.print("/=");
                break;
            }
            case star: {
                this.printer.print("*=");
                break;
            }
            case lShift: {
                this.printer.print("<<=");
                break;
            }
            case rSignedShift: {
                this.printer.print(">>=");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(">>>=");
            }
        }
        this.printer.print(" ");
        n.getValue().accept(this, arg);
    }

    @Override
    public void visit(BinaryExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getLeft().accept(this, arg);
        this.printer.print(" ");
        switch (n.getOperator()) {
            case or: {
                this.printer.print("||");
                break;
            }
            case and: {
                this.printer.print("&&");
                break;
            }
            case binOr: {
                this.printer.print("|");
                break;
            }
            case binAnd: {
                this.printer.print("&");
                break;
            }
            case xor: {
                this.printer.print("^");
                break;
            }
            case equals: {
                this.printer.print("==");
                break;
            }
            case notEquals: {
                this.printer.print("!=");
                break;
            }
            case less: {
                this.printer.print("<");
                break;
            }
            case greater: {
                this.printer.print(">");
                break;
            }
            case lessEquals: {
                this.printer.print("<=");
                break;
            }
            case greaterEquals: {
                this.printer.print(">=");
                break;
            }
            case lShift: {
                this.printer.print("<<");
                break;
            }
            case rSignedShift: {
                this.printer.print(">>");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(">>>");
                break;
            }
            case plus: {
                this.printer.print("+");
                break;
            }
            case minus: {
                this.printer.print("-");
                break;
            }
            case times: {
                this.printer.print("*");
                break;
            }
            case divide: {
                this.printer.print("/");
                break;
            }
            case remainder: {
                this.printer.print("%");
            }
        }
        this.printer.print(" ");
        n.getRight().accept(this, arg);
    }

    @Override
    public void visit(CastExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("(");
        n.getType().accept(this, arg);
        this.printer.print(") ");
        n.getExpr().accept(this, arg);
    }

    @Override
    public void visit(ClassExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getType().accept(this, arg);
        this.printer.print(".class");
    }

    @Override
    public void visit(ConditionalExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getCondition().accept(this, arg);
        this.printer.print(" ? ");
        n.getThenExpr().accept(this, arg);
        this.printer.print(" : ");
        n.getElseExpr().accept(this, arg);
    }

    @Override
    public void visit(EnclosedExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("(");
        n.getInner().ifPresent(i -> i.accept(this, arg));
        this.printer.print(")");
    }

    @Override
    public void visit(FieldAccessExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getScope().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getField());
    }

    @Override
    public void visit(InstanceOfExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getExpr().accept(this, arg);
        this.printer.print(" instanceof ");
        n.getType().accept(this, arg);
    }

    @Override
    public void visit(CharLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("'");
        this.printer.print(n.getValue());
        this.printer.print("'");
    }

    @Override
    public void visit(DoubleLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(IntegerLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(LongLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(IntegerLiteralMinValueExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(LongLiteralMinValueExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(StringLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("\"");
        this.printer.print(n.getValue());
        this.printer.print("\"");
    }

    @Override
    public void visit(BooleanLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(String.valueOf(n.getValue()));
    }

    @Override
    public void visit(NullLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("null");
    }

    @Override
    public void visit(ThisExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getClassExpr().ifPresent(ce -> {
            ce.accept(this, arg);
            this.printer.print(".");
        });
        this.printer.print("this");
    }

    @Override
    public void visit(SuperExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getClassExpr().ifPresent(ce -> {
            ce.accept(this, arg);
            this.printer.print(".");
        });
        this.printer.print("super");
    }

    @Override
    public void visit(MethodCallExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getScope().ifPresent(s -> {
            s.accept(this, arg);
            this.printer.print(".");
        });
        this.printTypeArgs(n, arg);
        this.printer.print(n.getName());
        this.printArguments(n.getArgs(), arg);
    }

    @Override
    public void visit(ObjectCreationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getScope().ifPresent(s -> {
            s.accept(this, arg);
            this.printer.print(".");
        });
        this.printer.print("new ");
        this.printTypeArgs(n, arg);
        n.getTypeArguments().ifPresent(t -> this.printer.print(" "));
        n.getType().accept(this, arg);
        this.printArguments(n.getArgs(), arg);
        n.getAnonymousClassBody().ifPresent(acb -> {
            this.printer.printLn(" {");
            this.printer.indent();
            this.printMembers((NodeList<BodyDeclaration<?>>)acb, arg);
            this.printer.unindent();
            this.printer.print("}");
        });
    }

    @Override
    public void visit(UnaryExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        switch (n.getOperator()) {
            case positive: {
                this.printer.print("+");
                break;
            }
            case negative: {
                this.printer.print("-");
                break;
            }
            case inverse: {
                this.printer.print("~");
                break;
            }
            case not: {
                this.printer.print("!");
                break;
            }
            case preIncrement: {
                this.printer.print("++");
                break;
            }
            case preDecrement: {
                this.printer.print("--");
                break;
            }
        }
        n.getExpr().accept(this, arg);
        switch (n.getOperator()) {
            case postIncrement: {
                this.printer.print("++");
                break;
            }
            case postDecrement: {
                this.printer.print("--");
                break;
            }
        }
    }

    @Override
    public void visit(ConstructorDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (n.isGeneric()) {
            this.printer.print(" ");
        }
        this.printer.print(n.getName());
        this.printer.print("(");
        if (!n.getParameters().isEmpty()) {
            Iterator<Parameter> i = n.getParameters().iterator();
            while (i.hasNext()) {
                Parameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        n.getThrows().ifNotEmpty(t -> {
            this.printer.print(" throws ");
            Iterator i = t.iterator();
            while (i.hasNext()) {
                ReferenceType name = (ReferenceType)i.next();
                name.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        });
        this.printer.print(" ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(MethodDeclaration n, Object arg) {
        this.printOrphanCommentsBeforeThisChildNode(n);
        this.printJavaComment(n.getComment(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        if (n.isDefault()) {
            this.printer.print("default ");
        }
        this.printTypeParameters(n.getTypeParameters(), arg);
        n.getTypeParameters().ifNotEmpty(tp -> this.printer.print(" "));
        n.getElementType().accept(this, arg);
        for (ArrayBracketPair pair : n.getArrayBracketPairsAfterElementType()) {
            pair.accept(this, arg);
        }
        this.printer.print(" ");
        this.printer.print(n.getName());
        this.printer.print("(");
        Iterator<Parameter> i = n.getParameters().iterator();
        while (i.hasNext()) {
            Parameter p = i.next();
            p.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printer.print(")");
        for (ArrayBracketPair pair : n.getArrayBracketPairsAfterParameterList()) {
            pair.accept(this, arg);
        }
        n.getThrows().ifNotEmpty(t -> {
            this.printer.print(" throws ");
            Iterator i = t.iterator();
            while (i.hasNext()) {
                ReferenceType name = (ReferenceType)i.next();
                name.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        });
        if (n.getBody().isPresent()) {
            this.printer.print(" ");
            n.getBody().get().accept(this, arg);
        } else {
            this.printer.print(";");
        }
    }

    @Override
    public void visit(Parameter n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printAnnotations(n.getAnnotations(), false, arg);
        this.printModifiers(n.getModifiers());
        n.getElementType().accept(this, arg);
        for (ArrayBracketPair pair : n.getArrayBracketPairsAfterElementType()) {
            pair.accept(this, arg);
        }
        if (n.isVarArgs()) {
            this.printer.print("...");
        }
        this.printer.print(" ");
        n.getId().accept(this, arg);
    }

    @Override
    public void visit(ExplicitConstructorInvocationStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.isThis()) {
            this.printTypeArgs(n, arg);
            this.printer.print("this");
        } else {
            n.getExpr().ifPresent(e -> {
                e.accept(this, arg);
                this.printer.print(".");
            });
            this.printTypeArgs(n, arg);
            this.printer.print("super");
        }
        this.printArguments(n.getArgs(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(VariableDeclarationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printAnnotations(n.getAnnotations(), false, arg);
        this.printModifiers(n.getModifiers());
        n.getElementType().accept(this, arg);
        for (ArrayBracketPair pair : n.getArrayBracketPairsAfterElementType()) {
            pair.accept(this, arg);
        }
        this.printer.print(" ");
        Iterator<VariableDeclarator> i = n.getVariables().iterator();
        while (i.hasNext()) {
            VariableDeclarator v = i.next();
            v.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
    }

    @Override
    public void visit(TypeDeclarationStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getTypeDeclaration().accept(this, arg);
    }

    @Override
    public void visit(AssertStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("assert ");
        n.getCheck().accept(this, arg);
        n.getMessage().ifPresent(m -> {
            this.printer.print(" : ");
            m.accept(this, arg);
        });
        this.printer.print(";");
    }

    @Override
    public void visit(BlockStmt n, Object arg) {
        this.printOrphanCommentsBeforeThisChildNode(n);
        this.printJavaComment(n.getComment(), arg);
        this.printer.printLn("{");
        this.printer.indent();
        for (Statement s : n.getStmts()) {
            s.accept(this, arg);
            this.printer.printLn();
        }
        this.printer.unindent();
        this.printOrphanCommentsEnding(n);
        this.printer.print("}");
    }

    @Override
    public void visit(LabeledStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getLabel());
        this.printer.print(": ");
        n.getStmt().accept(this, arg);
    }

    @Override
    public void visit(EmptyStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(ExpressionStmt n, Object arg) {
        this.printOrphanCommentsBeforeThisChildNode(n);
        this.printJavaComment(n.getComment(), arg);
        n.getExpression().accept(this, arg);
        this.printer.print(";");
    }

    @Override
    public void visit(SwitchStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("switch(");
        n.getSelector().accept(this, arg);
        this.printer.printLn(") {");
        this.printer.indent();
        for (SwitchEntryStmt e : n.getEntries()) {
            e.accept(this, arg);
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(SwitchEntryStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getLabel().isPresent()) {
            this.printer.print("case ");
            n.getLabel().get().accept(this, arg);
            this.printer.print(":");
        } else {
            this.printer.print("default:");
        }
        this.printer.printLn();
        this.printer.indent();
        for (Statement s : n.getStmts()) {
            s.accept(this, arg);
            this.printer.printLn();
        }
        this.printer.unindent();
    }

    @Override
    public void visit(BreakStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("break");
        n.getId().ifPresent(id -> {
            this.printer.print(" ");
            this.printer.print((String)id);
        });
        this.printer.print(";");
    }

    @Override
    public void visit(ReturnStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("return");
        n.getExpr().ifPresent(e -> {
            this.printer.print(" ");
            e.accept(this, arg);
        });
        this.printer.print(";");
    }

    @Override
    public void visit(EnumDeclaration n, Object arg) {
        Iterator<Node> i;
        this.printJavaComment(n.getComment(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printer.print("enum ");
        this.printer.print(n.getName());
        if (!n.getImplements().isEmpty()) {
            this.printer.print(" implements ");
            i = n.getImplements().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn(" {");
        this.printer.indent();
        this.printer.printLn();
        i = n.getEntries().iterator();
        while (i.hasNext()) {
            EnumConstantDeclaration e = (EnumConstantDeclaration)i.next();
            e.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
        if (!n.getMembers().isEmpty()) {
            this.printer.printLn(";");
            this.printMembers(n.getMembers(), arg);
        } else if (!n.getEntries().isEmpty()) {
            this.printer.printLn();
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(EnumConstantDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printer.print(n.getName());
        if (!n.getArgs().isEmpty()) {
            this.printArguments(n.getArgs(), arg);
        }
        if (!n.getClassBody().isEmpty()) {
            this.printer.printLn(" {");
            this.printer.indent();
            this.printMembers(n.getClassBody(), arg);
            this.printer.unindent();
            this.printer.printLn("}");
        }
    }

    @Override
    public void visit(EmptyMemberDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(InitializerDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.isStatic()) {
            this.printer.print("static ");
        }
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(IfStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("if (");
        n.getCondition().accept(this, arg);
        boolean thenBlock = n.getThenStmt() instanceof BlockStmt;
        if (thenBlock) {
            this.printer.print(") ");
        } else {
            this.printer.printLn(")");
            this.printer.indent();
        }
        n.getThenStmt().accept(this, arg);
        if (!thenBlock) {
            this.printer.unindent();
        }
        n.getElseStmt().ifPresent(es -> {
            if (thenBlock) {
                this.printer.print(" ");
            } else {
                this.printer.printLn();
            }
            boolean elseIf = es instanceof IfStmt;
            boolean elseBlock = es instanceof BlockStmt;
            if (elseIf || elseBlock) {
                this.printer.print("else ");
            } else {
                this.printer.printLn("else");
                this.printer.indent();
            }
            es.accept(this, arg);
            if (!elseIf && !elseBlock) {
                this.printer.unindent();
            }
        });
    }

    @Override
    public void visit(WhileStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("while (");
        n.getCondition().accept(this, arg);
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ContinueStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("continue");
        n.getId().ifPresent(id -> {
            this.printer.print(" ");
            this.printer.print((String)id);
        });
        this.printer.print(";");
    }

    @Override
    public void visit(DoStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("do ");
        n.getBody().accept(this, arg);
        this.printer.print(" while (");
        n.getCondition().accept(this, arg);
        this.printer.print(");");
    }

    @Override
    public void visit(ForeachStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("for (");
        n.getVariable().accept(this, arg);
        this.printer.print(" : ");
        n.getIterable().accept(this, arg);
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ForStmt n, Object arg) {
        Expression e;
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("for (");
        Iterator<Expression> i = n.getInit().iterator();
        while (i.hasNext()) {
            e = i.next();
            e.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printer.print("; ");
        n.getCompare().ifPresent(c -> c.accept(this, arg));
        this.printer.print("; ");
        i = n.getUpdate().iterator();
        while (i.hasNext()) {
            e = i.next();
            e.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ThrowStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("throw ");
        n.getExpr().accept(this, arg);
        this.printer.print(";");
    }

    @Override
    public void visit(SynchronizedStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("synchronized (");
        n.getExpr().accept(this, arg);
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(TryStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("try ");
        if (!n.getResources().isEmpty()) {
            this.printer.print("(");
            Iterator<VariableDeclarationExpr> resources = n.getResources().iterator();
            boolean first = true;
            while (resources.hasNext()) {
                this.visit(resources.next(), arg);
                if (resources.hasNext()) {
                    this.printer.print(";");
                    this.printer.printLn();
                    if (first) {
                        this.printer.indent();
                    }
                }
                first = false;
            }
            if (n.getResources().size() > 1) {
                this.printer.unindent();
            }
            this.printer.print(") ");
        }
        n.getTryBlock().accept(this, arg);
        for (CatchClause c : n.getCatchs()) {
            c.accept(this, arg);
        }
        n.getFinallyBlock().ifPresent(fb -> {
            this.printer.print(" finally ");
            fb.accept(this, arg);
        });
    }

    @Override
    public void visit(CatchClause n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(" catch (");
        n.getParam().accept(this, arg);
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(AnnotationDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printer.print("@interface ");
        this.printer.print(n.getName());
        this.printer.printLn(" {");
        this.printer.indent();
        this.printMembers(n.getMembers(), arg);
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(AnnotationMemberDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        this.printer.print(n.getName());
        this.printer.print("()");
        n.getDefaultValue().ifPresent(dv -> {
            this.printer.print(" default ");
            dv.accept(this, arg);
        });
        this.printer.print(";");
    }

    @Override
    public void visit(MarkerAnnotationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
    }

    @Override
    public void visit(SingleMemberAnnotationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printer.print("(");
        n.getMemberValue().accept(this, arg);
        this.printer.print(")");
    }

    @Override
    public void visit(NormalAnnotationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printer.print("(");
        Iterator<MemberValuePair> i = n.getPairs().iterator();
        while (i.hasNext()) {
            MemberValuePair m = i.next();
            m.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printer.print(")");
    }

    @Override
    public void visit(MemberValuePair n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getName());
        this.printer.print(" = ");
        n.getValue().accept(this, arg);
    }

    @Override
    public void visit(LineComment n, Object arg) {
        if (!this.printComments) {
            return;
        }
        this.printer.print("//");
        String tmp = n.getContent();
        tmp = tmp.replace('\r', ' ');
        tmp = tmp.replace('\n', ' ');
        this.printer.printLn(tmp);
    }

    @Override
    public void visit(BlockComment n, Object arg) {
        if (!this.printComments) {
            return;
        }
        this.printer.print("/*");
        this.printer.print(n.getContent());
        this.printer.printLn("*/");
    }

    @Override
    public void visit(LambdaExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        NodeList<Parameter> parameters = n.getParameters();
        boolean printPar = n.isParametersEnclosed();
        if (printPar) {
            this.printer.print("(");
        }
        Iterator<Parameter> i = parameters.iterator();
        while (i.hasNext()) {
            Parameter p = i.next();
            p.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
        if (printPar) {
            this.printer.print(")");
        }
        this.printer.print(" -> ");
        Statement body = n.getBody();
        if (body instanceof ExpressionStmt) {
            ((ExpressionStmt)body).getExpression().accept(this, arg);
        } else {
            body.accept(this, arg);
        }
    }

    @Override
    public void visit(MethodReferenceExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getScope().accept(this, arg);
        this.printer.print("::");
        this.printTypeArgs(n, arg);
        this.printer.print(n.getIdentifier());
    }

    @Override
    public void visit(TypeExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getType().accept(this, arg);
    }

    @Override
    public void visit(ArrayBracketPair arrayBracketPair, Object arg) {
        this.printAnnotations(arrayBracketPair.getAnnotations(), true, arg);
        this.printer.print("[]");
    }

    @Override
    public void visit(NodeList n, Object arg) {
        for (Object node : n) {
            ((Node)node).accept(this, arg);
        }
    }

    @Override
    public void visit(EmptyImportDeclaration n, Object arg) {
        this.printer.printLn(";");
    }

    @Override
    public void visit(SingleStaticImportDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("import static ");
        n.getType().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getStaticMember());
        this.printer.printLn(";");
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(SingleTypeImportDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("import ");
        n.getType().accept(this, arg);
        this.printer.printLn(";");
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(StaticImportOnDemandDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("import static ");
        n.getType().accept(this, arg);
        this.printer.printLn(".*;");
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(TypeImportOnDemandDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("import ");
        n.getName().accept(this, arg);
        this.printer.printLn(".*;");
        this.printOrphanCommentsEnding(n);
    }

    private void printOrphanCommentsBeforeThisChildNode(Node node) {
        int i;
        Node parent;
        if (node instanceof Comment) {
            return;
        }
        for (parent = node.getParentNode(); parent != null && parent instanceof NodeList; parent = parent.getParentNode()) {
        }
        if (parent == null) {
            return;
        }
        LinkedList<Node> everything = new LinkedList<Node>();
        everything.addAll(parent.getBackwardsCompatibleChildrenNodes());
        PositionUtils.sortByBeginPosition(everything);
        int positionOfTheChild = -1;
        for (int i2 = 0; i2 < everything.size(); ++i2) {
            if (everything.get(i2) != node) continue;
            positionOfTheChild = i2;
        }
        if (positionOfTheChild == -1) {
            throw new AssertionError((Object)"I am not a child of my parent.");
        }
        int positionOfPreviousChild = -1;
        for (i = positionOfTheChild - 1; i >= 0 && positionOfPreviousChild == -1; --i) {
            if (everything.get(i) instanceof Comment) continue;
            positionOfPreviousChild = i;
        }
        for (i = positionOfPreviousChild + 1; i < positionOfTheChild; ++i) {
            Node nodeToPrint = (Node)everything.get(i);
            if (!(nodeToPrint instanceof Comment)) {
                throw new RuntimeException("Expected comment, instead " + nodeToPrint.getClass() + ". Position of previous child: " + positionOfPreviousChild + ", position of child " + positionOfTheChild);
            }
            nodeToPrint.accept(this, null);
        }
    }

    private void printOrphanCommentsEnding(Node node) {
        LinkedList<Node> everything = new LinkedList<Node>();
        everything.addAll(node.getChildrenNodes());
        PositionUtils.sortByBeginPosition(everything);
        if (everything.isEmpty()) {
            return;
        }
        int commentsAtEnd = 0;
        boolean findingComments = true;
        while (findingComments && commentsAtEnd < everything.size()) {
            Node last = (Node)everything.get(everything.size() - 1 - commentsAtEnd);
            findingComments = last instanceof Comment;
            if (!findingComments) continue;
            ++commentsAtEnd;
        }
        for (int i = 0; i < commentsAtEnd; ++i) {
            ((Node)everything.get(everything.size() - commentsAtEnd + i)).accept(this, null);
        }
    }

    public static class SourcePrinter {
        private final String indentation;
        private int level = 0;
        private boolean indented = false;
        private final StringBuilder buf = new StringBuilder();

        public SourcePrinter(String indentation) {
            this.indentation = indentation;
        }

        public void indent() {
            ++this.level;
        }

        public void unindent() {
            --this.level;
        }

        private void makeIndent() {
            for (int i = 0; i < this.level; ++i) {
                this.buf.append(this.indentation);
            }
        }

        public void print(String arg) {
            if (!this.indented) {
                this.makeIndent();
                this.indented = true;
            }
            this.buf.append(arg);
        }

        public void printLn(String arg) {
            this.print(arg);
            this.printLn();
        }

        public void printLn() {
            this.buf.append(Utils.EOL);
            this.indented = false;
        }

        public String getSource() {
            return this.buf.toString();
        }

        public String toString() {
            return this.getSource();
        }
    }
}

