/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.visitor;

import com.github.javaparser.ast.ArrayBracketPair;
import com.github.javaparser.ast.ArrayCreationLevel;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EmptyMemberDeclaration;
import com.github.javaparser.ast.body.EmptyTypeDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.IntegerLiteralMinValueExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralMinValueExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.QualifiedNameExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.SuperExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.imports.EmptyImportDeclaration;
import com.github.javaparser.ast.imports.SingleStaticImportDeclaration;
import com.github.javaparser.ast.imports.SingleTypeImportDeclaration;
import com.github.javaparser.ast.imports.StaticImportOnDemandDeclaration;
import com.github.javaparser.ast.imports.TypeImportOnDemandDeclaration;
import com.github.javaparser.ast.stmt.AssertStmt;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.BreakStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ContinueStmt;
import com.github.javaparser.ast.stmt.DoStmt;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.ForeachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.SwitchEntryStmt;
import com.github.javaparser.ast.stmt.SwitchStmt;
import com.github.javaparser.ast.stmt.SynchronizedStmt;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.stmt.TypeDeclarationStmt;
import com.github.javaparser.ast.stmt.WhileStmt;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.IntersectionType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.type.UnionType;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.type.WildcardType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import java.util.List;
import java.util.Optional;

public class EqualsVisitor
implements GenericVisitor<Boolean, Node> {
    private static final EqualsVisitor SINGLETON = new EqualsVisitor();

    public static boolean equals(Node n1, Node n2) {
        return SINGLETON.nodeEquals(n1, n2);
    }

    private EqualsVisitor() {
    }

    private boolean commonNodeEquality(Node n1, Node n2) {
        if (!this.nodeEquals(n1.getComment(), n2.getComment())) {
            return false;
        }
        return this.nodesEquals(n1.getOrphanComments(), n2.getOrphanComments());
    }

    private boolean nodesEquals(List<? extends Node> nodes1, List<? extends Node> nodes2) {
        if (nodes1 == null) {
            return nodes2 == null;
        }
        if (nodes2 == null) {
            return false;
        }
        if (nodes1.size() != nodes2.size()) {
            return false;
        }
        for (int i = 0; i < nodes1.size(); ++i) {
            if (this.nodeEquals(nodes1.get(i), nodes2.get(i))) continue;
            return false;
        }
        return true;
    }

    public <N extends Node, L extends NodeList<N>> boolean nodesEquals(Optional<L> n1, Optional<L> n2) {
        if (!n1.isPresent() && !n2.isPresent()) {
            return true;
        }
        if (!n1.isPresent() || !n2.isPresent()) {
            return false;
        }
        NodeList t1 = (NodeList)n1.get();
        NodeList t2 = (NodeList)n2.get();
        return this.nodesEquals(t1, t2);
    }

    public <N extends Node> boolean nodesEquals(NodeList<N> n1, NodeList<N> n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        if (n1.size() != n2.size()) {
            return false;
        }
        for (int i = 0; i < n1.size(); ++i) {
            if (this.nodeEquals((Node)n1.get(i), (Node)n2.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean nodeEquals(Node n1, Node n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        if (n1.getClass() != n2.getClass()) {
            return false;
        }
        if (!this.commonNodeEquality(n1, n2)) {
            return false;
        }
        return n1.accept(this, n2);
    }

    private boolean nodeEquals(Optional<? extends Node> n1, Optional<? extends Node> n2) {
        if (!n1.isPresent() && !n2.isPresent()) {
            return true;
        }
        if (!n1.isPresent() || !n2.isPresent()) {
            return false;
        }
        Node t1 = n1.get();
        Node t2 = n2.get();
        if (t1.getClass() != t2.getClass()) {
            return false;
        }
        if (!this.commonNodeEquality(t1, t2)) {
            return false;
        }
        return t1.accept(this, t2);
    }

    private boolean objEquals(Object n1, Object n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        return n1.equals(n2);
    }

    @Override
    public Boolean visit(CompilationUnit n1, Node arg) {
        CompilationUnit n2 = (CompilationUnit)arg;
        if (!this.nodeEquals(n1.getPackage(), n2.getPackage())) {
            return false;
        }
        if (!this.nodesEquals(n1.getImports(), n2.getImports())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypes(), n2.getTypes())) {
            return false;
        }
        if (!this.nodesEquals(n1.getComments(), n2.getComments())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(PackageDeclaration n1, Node arg) {
        PackageDeclaration n2 = (PackageDeclaration)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(TypeParameter n1, Node arg) {
        TypeParameter n2 = (TypeParameter)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeBound(), n2.getTypeBound())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(LineComment n1, Node arg) {
        LineComment n2 = (LineComment)arg;
        if (!this.objEquals(n1.getContent(), n2.getContent())) {
            return false;
        }
        if (!this.objEquals(n1.getBegin().line, n2.getBegin().line)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(BlockComment n1, Node arg) {
        BlockComment n2 = (BlockComment)arg;
        if (!this.objEquals(n1.getContent(), n2.getContent())) {
            return false;
        }
        if (!this.objEquals(n1.getBegin().line, n2.getBegin().line)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ClassOrInterfaceDeclaration n1, Node arg) {
        ClassOrInterfaceDeclaration n2 = (ClassOrInterfaceDeclaration)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (n1.isInterface() != n2.isInterface()) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeParameters(), n2.getTypeParameters())) {
            return false;
        }
        if (!this.nodesEquals(n1.getExtends(), n2.getExtends())) {
            return false;
        }
        if (!this.nodesEquals(n1.getImplements(), n2.getImplements())) {
            return false;
        }
        if (!this.nodesEquals(n1.getMembers(), n2.getMembers())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(EnumDeclaration n1, Node arg) {
        EnumDeclaration n2 = (EnumDeclaration)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodesEquals(n1.getImplements(), n2.getImplements())) {
            return false;
        }
        if (!this.nodesEquals(n1.getEntries(), n2.getEntries())) {
            return false;
        }
        if (!this.nodesEquals(n1.getMembers(), n2.getMembers())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(EmptyTypeDeclaration n1, Node arg) {
        return true;
    }

    @Override
    public Boolean visit(EnumConstantDeclaration n1, Node arg) {
        EnumConstantDeclaration n2 = (EnumConstantDeclaration)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodesEquals(n1.getArgs(), n2.getArgs())) {
            return false;
        }
        if (!this.nodesEquals(n1.getClassBody(), n2.getClassBody())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(AnnotationDeclaration n1, Node arg) {
        AnnotationDeclaration n2 = (AnnotationDeclaration)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodesEquals(n1.getMembers(), n2.getMembers())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(AnnotationMemberDeclaration n1, Node arg) {
        AnnotationMemberDeclaration n2 = (AnnotationMemberDeclaration)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodeEquals(n1.getDefaultValue(), n2.getDefaultValue())) {
            return false;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(FieldDeclaration n1, Node arg) {
        FieldDeclaration n2 = (FieldDeclaration)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodeEquals(n1.getElementType(), n2.getElementType())) {
            return false;
        }
        if (!this.nodesEquals(n1.getVariables(), n2.getVariables())) {
            return false;
        }
        if (!this.nodesEquals(n1.getArrayBracketPairsAfterElementType(), n2.getArrayBracketPairsAfterElementType())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(VariableDeclarator n1, Node arg) {
        VariableDeclarator n2 = (VariableDeclarator)arg;
        if (!this.nodeEquals(n1.getId(), n2.getId())) {
            return false;
        }
        if (!this.nodeEquals(n1.getInit(), n2.getInit())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(VariableDeclaratorId n1, Node arg) {
        VariableDeclaratorId n2 = (VariableDeclaratorId)arg;
        if (!this.nodesEquals(n1.getArrayBracketPairsAfterId(), n2.getArrayBracketPairsAfterId())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ConstructorDeclaration n1, Node arg) {
        ConstructorDeclaration n2 = (ConstructorDeclaration)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        if (!this.nodesEquals(n1.getParameters(), n2.getParameters())) {
            return false;
        }
        if (!this.nodesEquals(n1.getThrows(), n2.getThrows())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeParameters(), n2.getTypeParameters())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(MethodDeclaration n1, Node arg) {
        MethodDeclaration n2 = (MethodDeclaration)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.nodesEquals(n1.getArrayBracketPairsAfterElementType(), n2.getArrayBracketPairsAfterElementType())) {
            return false;
        }
        if (!this.nodesEquals(n1.getArrayBracketPairsAfterParameterList(), n2.getArrayBracketPairsAfterParameterList())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodeEquals(n1.getElementType(), n2.getElementType())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        if (!this.nodesEquals(n1.getParameters(), n2.getParameters())) {
            return false;
        }
        if (!this.nodesEquals(n1.getThrows(), n2.getThrows())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeParameters(), n2.getTypeParameters())) {
            return false;
        }
        if (n1.isDefault() != n2.isDefault()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(Parameter n1, Node arg) {
        Parameter n2 = (Parameter)arg;
        if (!this.nodeEquals(n1.getElementType(), n2.getElementType())) {
            return false;
        }
        if (!this.nodesEquals(n1.getArrayBracketPairsAfterElementType(), n2.getArrayBracketPairsAfterElementType())) {
            return false;
        }
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.nodeEquals(n1.getId(), n2.getId())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(EmptyMemberDeclaration n1, Node arg) {
        return true;
    }

    @Override
    public Boolean visit(InitializerDeclaration n1, Node arg) {
        InitializerDeclaration n2 = (InitializerDeclaration)arg;
        if (!this.nodeEquals(n1.getBlock(), n2.getBlock())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(JavadocComment n1, Node arg) {
        JavadocComment n2 = (JavadocComment)arg;
        if (!this.objEquals(n1.getContent(), n2.getContent())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ClassOrInterfaceType n1, Node arg) {
        ClassOrInterfaceType n2 = (ClassOrInterfaceType)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeArguments(), n2.getTypeArguments())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(PrimitiveType n1, Node arg) {
        PrimitiveType n2 = (PrimitiveType)arg;
        if (n1.getType() != n2.getType()) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ArrayType n1, Node arg) {
        ArrayType n2 = (ArrayType)arg;
        if (!this.nodeEquals(n1.getComponentType(), n2.getComponentType())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ArrayCreationLevel n1, Node arg) {
        ArrayCreationLevel n2 = (ArrayCreationLevel)arg;
        if (!this.nodeEquals(n1.getDimension(), n2.getDimension())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(IntersectionType n1, Node arg) {
        IntersectionType n2 = (IntersectionType)arg;
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        NodeList<ReferenceType<?>> n1Elements = n1.getElements();
        NodeList<ReferenceType<?>> n2Elements = n2.getElements();
        if (n1Elements != null && n2Elements != null) {
            if (n1Elements.size() != n2Elements.size()) {
                return false;
            }
            int i = 0;
            for (ReferenceType<?> aux : n1Elements) {
                if (aux.accept(this, n2Elements.get(i)).booleanValue()) {
                    return false;
                }
                ++i;
            }
        } else if (n1Elements != n2Elements) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(UnionType n1, Node arg) {
        UnionType n2 = (UnionType)arg;
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        NodeList<ReferenceType<?>> n1Elements = n1.getElements();
        NodeList<ReferenceType<?>> n2Elements = n2.getElements();
        if (n1Elements != null && n2Elements != null) {
            if (n1Elements.size() != n2Elements.size()) {
                return false;
            }
            int i = 0;
            for (ReferenceType<?> aux : n1Elements) {
                if (aux.accept(this, n2Elements.get(i)).booleanValue()) {
                    return false;
                }
                ++i;
            }
        } else if (n1Elements != n2Elements) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(VoidType n1, Node arg) {
        VoidType n2 = (VoidType)arg;
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(WildcardType n1, Node arg) {
        WildcardType n2 = (WildcardType)arg;
        if (!this.nodeEquals(n1.getExtends(), n2.getExtends())) {
            return false;
        }
        if (!this.nodeEquals(n1.getSuper(), n2.getSuper())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(UnknownType n1, Node arg) {
        return true;
    }

    @Override
    public Boolean visit(ArrayAccessExpr n1, Node arg) {
        ArrayAccessExpr n2 = (ArrayAccessExpr)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodeEquals(n1.getIndex(), n2.getIndex())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ArrayCreationExpr n1, Node arg) {
        ArrayCreationExpr n2 = (ArrayCreationExpr)arg;
        if (!this.nodeEquals(n1.getElementType(), n2.getElementType())) {
            return false;
        }
        if (!this.nodesEquals(n1.getLevels(), n2.getLevels())) {
            return false;
        }
        if (!this.nodeEquals(n1.getInitializer(), n2.getInitializer())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ArrayInitializerExpr n1, Node arg) {
        ArrayInitializerExpr n2 = (ArrayInitializerExpr)arg;
        if (!this.nodesEquals(n1.getValues(), n2.getValues())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(AssignExpr n1, Node arg) {
        AssignExpr n2 = (AssignExpr)arg;
        if (n1.getOperator() != n2.getOperator()) {
            return false;
        }
        if (!this.nodeEquals(n1.getTarget(), n2.getTarget())) {
            return false;
        }
        if (!this.nodeEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(BinaryExpr n1, Node arg) {
        BinaryExpr n2 = (BinaryExpr)arg;
        if (n1.getOperator() != n2.getOperator()) {
            return false;
        }
        if (!this.nodeEquals(n1.getLeft(), n2.getLeft())) {
            return false;
        }
        if (!this.nodeEquals(n1.getRight(), n2.getRight())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(CastExpr n1, Node arg) {
        CastExpr n2 = (CastExpr)arg;
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        if (!this.nodeEquals(n1.getExpr(), n2.getExpr())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ClassExpr n1, Node arg) {
        ClassExpr n2 = (ClassExpr)arg;
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ConditionalExpr n1, Node arg) {
        ConditionalExpr n2 = (ConditionalExpr)arg;
        if (!this.nodeEquals(n1.getCondition(), n2.getCondition())) {
            return false;
        }
        if (!this.nodeEquals(n1.getThenExpr(), n2.getThenExpr())) {
            return false;
        }
        if (!this.nodeEquals(n1.getElseExpr(), n2.getElseExpr())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(EnclosedExpr n1, Node arg) {
        EnclosedExpr n2 = (EnclosedExpr)arg;
        if (!this.nodeEquals(n1.getInner(), n2.getInner())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(FieldAccessExpr n1, Node arg) {
        FieldAccessExpr n2 = (FieldAccessExpr)arg;
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return false;
        }
        if (!this.objEquals(n1.getField(), n2.getField())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeArguments(), n2.getTypeArguments())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(InstanceOfExpr n1, Node arg) {
        InstanceOfExpr n2 = (InstanceOfExpr)arg;
        if (!this.nodeEquals(n1.getExpr(), n2.getExpr())) {
            return false;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(StringLiteralExpr n1, Node arg) {
        StringLiteralExpr n2 = (StringLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(IntegerLiteralExpr n1, Node arg) {
        IntegerLiteralExpr n2 = (IntegerLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(LongLiteralExpr n1, Node arg) {
        LongLiteralExpr n2 = (LongLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(IntegerLiteralMinValueExpr n1, Node arg) {
        IntegerLiteralMinValueExpr n2 = (IntegerLiteralMinValueExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(LongLiteralMinValueExpr n1, Node arg) {
        LongLiteralMinValueExpr n2 = (LongLiteralMinValueExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(CharLiteralExpr n1, Node arg) {
        CharLiteralExpr n2 = (CharLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(DoubleLiteralExpr n1, Node arg) {
        DoubleLiteralExpr n2 = (DoubleLiteralExpr)arg;
        if (!this.objEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(BooleanLiteralExpr n1, Node arg) {
        BooleanLiteralExpr n2 = (BooleanLiteralExpr)arg;
        if (n1.getValue() != n2.getValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(NullLiteralExpr n1, Node arg) {
        return true;
    }

    @Override
    public Boolean visit(MethodCallExpr n1, Node arg) {
        MethodCallExpr n2 = (MethodCallExpr)arg;
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getArgs(), n2.getArgs())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeArguments(), n2.getTypeArguments())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(NameExpr n1, Node arg) {
        NameExpr n2 = (NameExpr)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ObjectCreationExpr n1, Node arg) {
        ObjectCreationExpr n2 = (ObjectCreationExpr)arg;
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return false;
        }
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnonymousClassBody(), n2.getAnonymousClassBody())) {
            return false;
        }
        if (!this.nodesEquals(n1.getArgs(), n2.getArgs())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeArguments(), n2.getTypeArguments())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(QualifiedNameExpr n1, Node arg) {
        QualifiedNameExpr n2 = (QualifiedNameExpr)arg;
        if (!this.nodeEquals(n1.getQualifier(), n2.getQualifier())) {
            return false;
        }
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ThisExpr n1, Node arg) {
        ThisExpr n2 = (ThisExpr)arg;
        if (!this.nodeEquals(n1.getClassExpr(), n2.getClassExpr())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(SuperExpr n1, Node arg) {
        SuperExpr n2 = (SuperExpr)arg;
        if (!this.nodeEquals(n1.getClassExpr(), n2.getClassExpr())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(UnaryExpr n1, Node arg) {
        UnaryExpr n2 = (UnaryExpr)arg;
        if (n1.getOperator() != n2.getOperator()) {
            return false;
        }
        if (!this.nodeEquals(n1.getExpr(), n2.getExpr())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(VariableDeclarationExpr n1, Node arg) {
        VariableDeclarationExpr n2 = (VariableDeclarationExpr)arg;
        if (!n1.getModifiers().equals(n2.getModifiers())) {
            return false;
        }
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        if (!this.nodeEquals(n1.getElementType(), n2.getElementType())) {
            return false;
        }
        if (!this.nodesEquals(n1.getVariables(), n2.getVariables())) {
            return false;
        }
        if (!this.nodesEquals(n1.getArrayBracketPairsAfterElementType(), n2.getArrayBracketPairsAfterElementType())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(MarkerAnnotationExpr n1, Node arg) {
        MarkerAnnotationExpr n2 = (MarkerAnnotationExpr)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(SingleMemberAnnotationExpr n1, Node arg) {
        SingleMemberAnnotationExpr n2 = (SingleMemberAnnotationExpr)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodeEquals(n1.getMemberValue(), n2.getMemberValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(NormalAnnotationExpr n1, Node arg) {
        NormalAnnotationExpr n2 = (NormalAnnotationExpr)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodesEquals(n1.getPairs(), n2.getPairs())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(MemberValuePair n1, Node arg) {
        MemberValuePair n2 = (MemberValuePair)arg;
        if (!this.objEquals(n1.getName(), n2.getName())) {
            return false;
        }
        if (!this.nodeEquals(n1.getValue(), n2.getValue())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ExplicitConstructorInvocationStmt n1, Node arg) {
        ExplicitConstructorInvocationStmt n2 = (ExplicitConstructorInvocationStmt)arg;
        if (!this.nodeEquals(n1.getExpr(), n2.getExpr())) {
            return false;
        }
        if (!this.nodesEquals(n1.getArgs(), n2.getArgs())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeArguments(), n2.getTypeArguments())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(TypeDeclarationStmt n1, Node arg) {
        TypeDeclarationStmt n2 = (TypeDeclarationStmt)arg;
        if (!this.nodeEquals(n1.getTypeDeclaration(), n2.getTypeDeclaration())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(AssertStmt n1, Node arg) {
        AssertStmt n2 = (AssertStmt)arg;
        if (!this.nodeEquals(n1.getCheck(), n2.getCheck())) {
            return false;
        }
        if (!this.nodeEquals(n1.getMessage(), n2.getMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(BlockStmt n1, Node arg) {
        BlockStmt n2 = (BlockStmt)arg;
        if (!this.nodesEquals(n1.getStmts(), n2.getStmts())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(LabeledStmt n1, Node arg) {
        LabeledStmt n2 = (LabeledStmt)arg;
        if (!this.nodeEquals(n1.getStmt(), n2.getStmt())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(EmptyStmt n1, Node arg) {
        return true;
    }

    @Override
    public Boolean visit(ExpressionStmt n1, Node arg) {
        ExpressionStmt n2 = (ExpressionStmt)arg;
        if (!this.nodeEquals(n1.getExpression(), n2.getExpression())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(SwitchStmt n1, Node arg) {
        SwitchStmt n2 = (SwitchStmt)arg;
        if (!this.nodeEquals(n1.getSelector(), n2.getSelector())) {
            return false;
        }
        if (!this.nodesEquals(n1.getEntries(), n2.getEntries())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(SwitchEntryStmt n1, Node arg) {
        SwitchEntryStmt n2 = (SwitchEntryStmt)arg;
        if (!this.nodeEquals(n1.getLabel(), n2.getLabel())) {
            return false;
        }
        if (!this.nodesEquals(n1.getStmts(), n2.getStmts())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(BreakStmt n1, Node arg) {
        BreakStmt n2 = (BreakStmt)arg;
        if (!this.objEquals(n1.getId(), n2.getId())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ReturnStmt n1, Node arg) {
        ReturnStmt n2 = (ReturnStmt)arg;
        if (!this.nodeEquals(n1.getExpr(), n2.getExpr())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(IfStmt n1, Node arg) {
        IfStmt n2 = (IfStmt)arg;
        if (!this.nodeEquals(n1.getCondition(), n2.getCondition())) {
            return false;
        }
        if (!this.nodeEquals(n1.getThenStmt(), n2.getThenStmt())) {
            return false;
        }
        if (!this.nodeEquals(n1.getElseStmt(), n2.getElseStmt())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(WhileStmt n1, Node arg) {
        WhileStmt n2 = (WhileStmt)arg;
        if (!this.nodeEquals(n1.getCondition(), n2.getCondition())) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ContinueStmt n1, Node arg) {
        ContinueStmt n2 = (ContinueStmt)arg;
        if (!this.objEquals(n1.getId(), n2.getId())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(DoStmt n1, Node arg) {
        DoStmt n2 = (DoStmt)arg;
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        if (!this.nodeEquals(n1.getCondition(), n2.getCondition())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ForeachStmt n1, Node arg) {
        ForeachStmt n2 = (ForeachStmt)arg;
        if (!this.nodeEquals(n1.getVariable(), n2.getVariable())) {
            return false;
        }
        if (!this.nodeEquals(n1.getIterable(), n2.getIterable())) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ForStmt n1, Node arg) {
        ForStmt n2 = (ForStmt)arg;
        if (!this.nodesEquals(n1.getInit(), n2.getInit())) {
            return false;
        }
        if (!this.nodeEquals(n1.getCompare(), n2.getCompare())) {
            return false;
        }
        if (!this.nodesEquals(n1.getUpdate(), n2.getUpdate())) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ThrowStmt n1, Node arg) {
        ThrowStmt n2 = (ThrowStmt)arg;
        if (!this.nodeEquals(n1.getExpr(), n2.getExpr())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(SynchronizedStmt n1, Node arg) {
        SynchronizedStmt n2 = (SynchronizedStmt)arg;
        if (!this.nodeEquals(n1.getExpr(), n2.getExpr())) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(TryStmt n1, Node arg) {
        TryStmt n2 = (TryStmt)arg;
        if (!this.nodeEquals(n1.getTryBlock(), n2.getTryBlock())) {
            return false;
        }
        if (!this.nodesEquals(n1.getCatchs(), n2.getCatchs())) {
            return false;
        }
        if (!this.nodesEquals(n1.getResources(), n2.getResources())) {
            return false;
        }
        if (!this.nodeEquals(n1.getFinallyBlock(), n2.getFinallyBlock())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(CatchClause n1, Node arg) {
        CatchClause n2 = (CatchClause)arg;
        if (!this.nodeEquals(n1.getParam(), n2.getParam())) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(LambdaExpr n1, Node arg) {
        LambdaExpr n2 = (LambdaExpr)arg;
        if (!this.nodesEquals(n1.getParameters(), n2.getParameters())) {
            return false;
        }
        if (n1.isParametersEnclosed() != n2.isParametersEnclosed()) {
            return false;
        }
        if (!this.nodeEquals(n1.getBody(), n2.getBody())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(MethodReferenceExpr n1, Node arg) {
        MethodReferenceExpr n2 = (MethodReferenceExpr)arg;
        if (!this.nodeEquals(n1.getScope(), n2.getScope())) {
            return false;
        }
        if (!this.nodesEquals(n1.getTypeArguments(), n2.getTypeArguments())) {
            return false;
        }
        if (!this.objEquals(n1.getIdentifier(), n2.getIdentifier())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(TypeExpr n, Node arg) {
        TypeExpr n2 = (TypeExpr)arg;
        if (!this.nodeEquals(n.getType(), n2.getType())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ArrayBracketPair n1, Node arg) {
        ArrayBracketPair n2 = (ArrayBracketPair)arg;
        if (!this.nodesEquals(n1.getAnnotations(), n2.getAnnotations())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(EmptyImportDeclaration n1, Node arg) {
        return true;
    }

    @Override
    public Boolean visit(SingleStaticImportDeclaration n1, Node arg) {
        SingleStaticImportDeclaration n2 = (SingleStaticImportDeclaration)arg;
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        if (!this.objEquals(n1.getStaticMember(), n2.getStaticMember())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(SingleTypeImportDeclaration n1, Node arg) {
        SingleTypeImportDeclaration n2 = (SingleTypeImportDeclaration)arg;
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(StaticImportOnDemandDeclaration n1, Node arg) {
        StaticImportOnDemandDeclaration n2 = (StaticImportOnDemandDeclaration)arg;
        if (!this.nodeEquals(n1.getType(), n2.getType())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(TypeImportOnDemandDeclaration n1, Node arg) {
        TypeImportOnDemandDeclaration n2 = (TypeImportOnDemandDeclaration)arg;
        if (!this.nodeEquals(n1.getName(), n2.getName())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(NodeList n, Node arg) {
        return this.nodesEquals(n, (NodeList)arg);
    }
}

