/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public final class FieldAccessExpr
extends Expression
implements NodeWithTypeArguments<FieldAccessExpr> {
    private Expression scope;
    private Optional<NodeList<Type<?>>> typeArguments;
    private NameExpr field;

    public FieldAccessExpr() {
        this(Range.UNKNOWN, new ThisExpr(), Utils.none(), new NameExpr());
    }

    public FieldAccessExpr(Expression scope, String field) {
        this(Range.UNKNOWN, scope, Utils.none(), NameExpr.name(field));
    }

    public FieldAccessExpr(Range range, Expression scope, Optional<NodeList<Type<?>>> typeArguments, NameExpr field) {
        super(range);
        this.setScope(scope);
        this.setTypeArguments((Optional)typeArguments);
        this.setFieldExpr(field);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public String getField() {
        return this.field.getName();
    }

    public NameExpr getFieldExpr() {
        return this.field;
    }

    public Expression getScope() {
        return this.scope;
    }

    public FieldAccessExpr setField(String field) {
        this.setFieldExpr(new NameExpr(field));
        return this;
    }

    public FieldAccessExpr setFieldExpr(NameExpr field) {
        this.field = Utils.assertNotNull(field);
        this.setAsParentNodeOf(this.field);
        return this;
    }

    public FieldAccessExpr setScope(Expression scope) {
        this.scope = Utils.assertNotNull(scope);
        this.setAsParentNodeOf(this.scope);
        return this;
    }

    @Override
    public Optional<NodeList<Type<?>>> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public FieldAccessExpr setTypeArguments(Optional<NodeList<Type<?>>> types) {
        this.typeArguments = Utils.assertNotNull(types);
        this.setAsParentNodeOf(this.typeArguments);
        return this;
    }
}

