/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.UserDataKey;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.DumpVisitor;
import com.github.javaparser.ast.visitor.EqualsVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.PositionUtils;
import com.github.javaparser.utils.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public abstract class Node
implements Cloneable {
    public static Comparator<Node> NODE_BY_BEGIN_POSITION = (a, b) -> a.getBegin().compareTo(b.getBegin());
    private Range range;
    private Node parentNode;
    private List<Node> childrenNodes = new LinkedList<Node>();
    private List<Comment> orphanComments = new LinkedList<Comment>();
    private IdentityHashMap<UserDataKey<?>, Object> userData = null;
    private Optional<? extends Comment> comment = Utils.none();
    public static final int ABSOLUTE_BEGIN_LINE = -1;
    public static final int ABSOLUTE_END_LINE = -2;

    public Node(Range range) {
        this.range = range;
    }

    public abstract <R, A> R accept(GenericVisitor<R, A> var1, A var2);

    public abstract <A> void accept(VoidVisitor<A> var1, A var2);

    public Optional<? extends Comment> getComment() {
        return this.comment;
    }

    public Position getBegin() {
        return this.range.begin;
    }

    public Position getEnd() {
        return this.range.end;
    }

    public Node setBegin(Position begin) {
        this.range = this.range.withBegin(begin);
        return this;
    }

    public Node setEnd(Position end) {
        this.range = this.range.withEnd(end);
        return this;
    }

    public Range getRange() {
        return this.range;
    }

    public Node setRange(Range range) {
        this.range = range;
        return this;
    }

    public final Node setComment(Optional<? extends Comment> comment) {
        Utils.assertNotNull(comment);
        comment.ifPresent(c -> {
            if (this instanceof Comment) {
                throw new AssertionError((Object)"A comment can not be commented");
            }
        });
        this.comment.ifPresent(c -> c.setCommentedNode(null));
        this.comment = comment;
        this.comment.ifPresent(c -> c.setCommentedNode(this));
        return this;
    }

    public final Node setLineComment(String comment) {
        return this.setComment(Utils.some(new LineComment(comment)));
    }

    public final Node setBlockComment(String comment) {
        return this.setComment(Utils.some(new BlockComment(comment)));
    }

    public final String toString() {
        DumpVisitor visitor = new DumpVisitor();
        this.accept(visitor, null);
        return visitor.getSource();
    }

    public final String toStringWithoutComments() {
        DumpVisitor visitor = new DumpVisitor(false);
        this.accept(visitor, null);
        return visitor.getSource();
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Node)) {
            return false;
        }
        return EqualsVisitor.equals(this, (Node)obj);
    }

    public Node clone() {
        return this.accept(new CloneVisitor(), null);
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public <T> T getParentNodeOfType(Class<T> classType) {
        Node parent = this.parentNode;
        while (parent != null) {
            if (classType.isAssignableFrom(parent.getClass())) {
                return (T)parent;
            }
            parent = parent.parentNode;
        }
        return null;
    }

    public List<Node> getChildrenNodes() {
        return Collections.unmodifiableList(this.childrenNodes);
    }

    @Deprecated
    public List<Node> getBackwardsCompatibleChildrenNodes() {
        ArrayList<Node> children = new ArrayList<Node>();
        for (Node childNode : this.getChildrenNodes()) {
            if (childNode instanceof NodeList) {
                for (Node subChildNode : (NodeList)childNode) {
                    children.add(subChildNode);
                }
                continue;
            }
            children.add(childNode);
        }
        PositionUtils.sortByBeginPosition(children);
        return children;
    }

    public <N extends Node> boolean containsWithin(N other) {
        return this.range.contains(other.getRange());
    }

    public void addOrphanComment(Comment comment) {
        this.orphanComments.add(comment);
        comment.setParentNode(this);
    }

    public List<Comment> getOrphanComments() {
        return this.orphanComments;
    }

    public List<Comment> getAllContainedComments() {
        LinkedList<Comment> comments = new LinkedList<Comment>();
        comments.addAll(this.getOrphanComments());
        for (Node child : this.getChildrenNodes()) {
            if (child.getComment().isPresent()) {
                comments.add(child.getComment().get());
            }
            comments.addAll(child.getAllContainedComments());
        }
        return comments;
    }

    public void setParentNode(Node parentNode) {
        if (this.parentNode != null) {
            this.parentNode.childrenNodes.remove(this);
        }
        this.parentNode = parentNode;
        if (this.parentNode != null) {
            this.parentNode.childrenNodes.add(this);
        }
    }

    protected void setAsParentNodeOf(List<? extends Node> childNodes) {
        if (childNodes != null) {
            for (Node node : childNodes) {
                node.setParentNode(this);
            }
        }
    }

    protected void setAsParentNodeOf(Node childNode) {
        if (childNode != null) {
            childNode.setParentNode(this);
        }
    }

    protected void setAsParentNodeOf(Optional<? extends Node> childNode) {
        Utils.assertNotNull(childNode);
        childNode.ifPresent(c -> c.setParentNode(this));
    }

    public boolean isPositionedAfter(Position position) {
        return this.range.isAfter(position);
    }

    public boolean isPositionedBefore(Position position) {
        return this.range.isBefore(position);
    }

    public void tryAddImportToParentCompilationUnit(Class<?> clazz) {
        CompilationUnit parentNode = this.getParentNodeOfType(CompilationUnit.class);
        if (parentNode != null) {
            parentNode.addImport(clazz);
        }
    }

    public <N extends Node> List<N> getNodesByType(Class<N> clazz) {
        ArrayList<N> nodes = new ArrayList<N>();
        for (Node child : this.getChildrenNodes()) {
            if (clazz.isInstance(child)) {
                nodes.add(clazz.cast(child));
            }
            nodes.addAll(child.getNodesByType(clazz));
        }
        return nodes;
    }

    public <M> M getUserData(UserDataKey<M> key) {
        if (this.userData == null) {
            return null;
        }
        return (M)this.userData.get(key);
    }

    public <M> void setUserData(UserDataKey<M> key, M object) {
        if (this.userData == null) {
            this.userData = new IdentityHashMap();
        }
        this.userData.put(key, object);
    }

    public boolean remove() {
        Node parentNode = this.parentNode;
        if (parentNode == null) {
            return false;
        }
        boolean success = false;
        for (Class<?> parentClass = parentNode.getClass(); parentClass != Object.class; parentClass = parentClass.getSuperclass()) {
            for (Field f : parentClass.getDeclaredFields()) {
                f.setAccessible(true);
                try {
                    Iterable l;
                    Object object = f.get(parentNode);
                    if (object == null) continue;
                    if (Collection.class.isAssignableFrom(object.getClass())) {
                        l = (Collection)object;
                        boolean remove = l.remove(this);
                        success |= remove;
                        continue;
                    }
                    if (NodeList.class.isAssignableFrom(object.getClass())) {
                        l = (NodeList)object;
                        success |= ((NodeList)l).remove(this);
                        continue;
                    }
                    if (Optional.class.equals(f.getType())) {
                        Optional opt = (Optional)object;
                        if (!opt.isPresent() || opt.get() != this) continue;
                        f.set(parentNode, Optional.empty());
                        continue;
                    }
                    if (object != this) continue;
                    f.set(parentNode, null);
                    success |= true;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException("Error while removing " + this.getClass().getSimpleName(), e);
                }
            }
        }
        this.setParentNode(null);
        return success;
    }
}

