/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.type;

import com.github.javaparser.Range;
import com.github.javaparser.ast.ArrayBracketPair;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArrayType
extends ReferenceType<ArrayType>
implements NodeWithAnnotations<ArrayType> {
    private Type componentType;

    public ArrayType(Type componentType, List<AnnotationExpr> annotations) {
        this.setComponentType(componentType);
        this.setAnnotations((List)annotations);
    }

    public ArrayType(Range range, Type componentType, List<AnnotationExpr> annotations) {
        super(range);
        this.setComponentType(componentType);
        this.setAnnotations((List)annotations);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Type getComponentType() {
        return this.componentType;
    }

    public ArrayType setComponentType(Type type) {
        this.componentType = type;
        this.setAsParentNodeOf(this.componentType);
        return this;
    }

    @SafeVarargs
    public static Type wrapInArrayTypes(Type type, List<ArrayBracketPair> ... arrayBracketPairLists) {
        for (int i = arrayBracketPairLists.length - 1; i >= 0; --i) {
            List<ArrayBracketPair> arrayBracketPairList = arrayBracketPairLists[i];
            if (arrayBracketPairList == null) continue;
            for (int j = arrayBracketPairList.size() - 1; j >= 0; --j) {
                type = new ArrayType(type, arrayBracketPairList.get(j).getAnnotations());
            }
        }
        return type;
    }

    public static Pair<Type, List<ArrayBracketPair>> unwrapArrayTypes(Type type) {
        ArrayList<ArrayBracketPair> arrayBracketPairs = new ArrayList<ArrayBracketPair>();
        while (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            arrayBracketPairs.add(new ArrayBracketPair(Range.UNKNOWN, arrayType.getAnnotations()));
            type = arrayType.getComponentType();
        }
        return new Pair<Type, List<ArrayBracketPair>>(type, arrayBracketPairs);
    }

    public static ArrayType arrayOf(Type type, AnnotationExpr ... annotations) {
        return new ArrayType(type, Arrays.asList(annotations));
    }
}

