/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.UserDataKey;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.DumpVisitor;
import com.github.javaparser.ast.visitor.EqualsVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;

public abstract class Node
implements Cloneable {
    private Range range;
    private Node parentNode;
    private List<Node> childrenNodes = new LinkedList<Node>();
    private List<Comment> orphanComments = new LinkedList<Comment>();
    private IdentityHashMap<UserDataKey<?>, Object> userData = null;
    private Comment comment;
    public static final int ABSOLUTE_BEGIN_LINE = -1;
    public static final int ABSOLUTE_END_LINE = -2;

    public Node() {
        this(Range.UNKNOWN);
    }

    public Node(Range range) {
        this.range = range;
    }

    public abstract <R, A> R accept(GenericVisitor<R, A> var1, A var2);

    public abstract <A> void accept(VoidVisitor<A> var1, A var2);

    public final Comment getComment() {
        return this.comment;
    }

    public Position getBegin() {
        return this.range.begin;
    }

    public Position getEnd() {
        return this.range.end;
    }

    public Node setBegin(Position begin) {
        this.range = this.range.withBegin(begin);
        return this;
    }

    public Node setEnd(Position end) {
        this.range = this.range.withEnd(end);
        return this;
    }

    public Range getRange() {
        return this.range;
    }

    public Node setRange(Range range) {
        this.range = range;
        return this;
    }

    public final Node setComment(Comment comment) {
        if (comment != null && this instanceof Comment) {
            throw new RuntimeException("A comment can not be commented");
        }
        if (this.comment != null) {
            this.comment.setCommentedNode(null);
        }
        this.comment = comment;
        if (comment != null) {
            this.comment.setCommentedNode(this);
        }
        return this;
    }

    public final Node setLineComment(String comment) {
        return this.setComment(new LineComment(comment));
    }

    public final Node setBlockComment(String comment) {
        return this.setComment(new BlockComment(comment));
    }

    public final String toString() {
        DumpVisitor visitor = new DumpVisitor();
        this.accept(visitor, null);
        return visitor.getSource();
    }

    public final String toStringWithoutComments() {
        DumpVisitor visitor = new DumpVisitor(false);
        this.accept(visitor, null);
        return visitor.getSource();
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Node)) {
            return false;
        }
        return EqualsVisitor.equals(this, (Node)obj);
    }

    public Node clone() {
        return this.accept(new CloneVisitor(), null);
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public <T> T getParentNodeOfType(Class<T> classType) {
        Node parent = this.parentNode;
        while (parent != null) {
            if (classType.isAssignableFrom(parent.getClass())) {
                return (T)parent;
            }
            parent = parent.parentNode;
        }
        return null;
    }

    public List<Node> getChildrenNodes() {
        return this.childrenNodes;
    }

    public boolean contains(Node other) {
        return this.range.contains(other.range);
    }

    public void addOrphanComment(Comment comment) {
        this.orphanComments.add(comment);
        comment.setParentNode(this);
    }

    public List<Comment> getOrphanComments() {
        return this.orphanComments;
    }

    public List<Comment> getAllContainedComments() {
        LinkedList<Comment> comments = new LinkedList<Comment>();
        comments.addAll(this.getOrphanComments());
        for (Node child : this.getChildrenNodes()) {
            if (child.getComment() != null) {
                comments.add(child.getComment());
            }
            comments.addAll(child.getAllContainedComments());
        }
        return comments;
    }

    public void setParentNode(Node parentNode) {
        if (this.parentNode != null) {
            this.parentNode.childrenNodes.remove(this);
        }
        this.parentNode = parentNode;
        if (this.parentNode != null) {
            this.parentNode.childrenNodes.add(this);
        }
    }

    protected void setAsParentNodeOf(List<? extends Node> childNodes) {
        if (childNodes != null) {
            for (Node node : childNodes) {
                node.setParentNode(this);
            }
        }
    }

    protected void setAsParentNodeOf(Node childNode) {
        if (childNode != null) {
            childNode.setParentNode(this);
        }
    }

    public boolean isPositionedAfter(Position position) {
        return this.range.isAfter(position);
    }

    public boolean isPositionedBefore(Position position) {
        return this.range.isBefore(position);
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void tryAddImportToParentCompilationUnit(Class<?> clazz) {
        CompilationUnit parentNode = this.getParentNodeOfType(CompilationUnit.class);
        if (parentNode != null) {
            parentNode.addImport(clazz);
        }
    }

    public <N extends Node> List<N> getNodesByType(Class<N> clazz) {
        ArrayList<N> nodes = new ArrayList<N>();
        for (Node child : this.getChildrenNodes()) {
            if (clazz.isInstance(child)) {
                nodes.add(clazz.cast(child));
            }
            nodes.addAll(child.getNodesByType(clazz));
        }
        return nodes;
    }

    public <M> M getUserData(UserDataKey<M> key) {
        if (this.userData == null) {
            return null;
        }
        return (M)this.userData.get(key);
    }

    public <M> void setUserData(UserDataKey<M> key, M object) {
        if (this.userData == null) {
            this.userData = new IdentityHashMap();
        }
        this.userData.put(key, object);
    }
}

