/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;

public class Name
extends Node {
    private String id;
    private Name qualifier;

    public Name() {
        this(Range.UNKNOWN, null, "empty");
    }

    public Name(String id) {
        this(Range.UNKNOWN, null, id);
    }

    public Name(Name qualifier, String id) {
        this(Range.UNKNOWN, qualifier, id);
    }

    public Name(Range range, Name qualifier, String id) {
        super(range);
        this.setId(id);
        this.setQualifier(qualifier);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public final String getId() {
        return this.id;
    }

    public Name setId(String id) {
        this.notifyPropertyChange(ObservableProperty.ID, this.id, id);
        this.id = Utils.assertNotNull(id);
        return this;
    }

    public static Name parse(String qualifiedName) {
        String[] split = qualifiedName.split("\\.");
        Name ret = new Name(split[0]);
        for (int i = 1; i < split.length; ++i) {
            ret = new Name(ret, split[i]);
        }
        return ret;
    }

    public Name getQualifier() {
        return this.qualifier;
    }

    public Name setQualifier(Name qualifier) {
        this.notifyPropertyChange(ObservableProperty.QUALIFIER, this.qualifier, qualifier);
        this.qualifier = qualifier;
        this.setAsParentNodeOf(qualifier);
        return this;
    }
}

