/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;

public final class BinaryExpr
extends Expression {
    private Expression left;
    private Expression right;
    private Operator op;

    public BinaryExpr() {
        this(Range.UNKNOWN, new BooleanLiteralExpr(), new BooleanLiteralExpr(), Operator.equals);
    }

    public BinaryExpr(Expression left, Expression right, Operator op) {
        this(Range.UNKNOWN, left, right, op);
    }

    public BinaryExpr(Range range, Expression left, Expression right, Operator op) {
        super(range);
        this.setLeft(left);
        this.setRight(right);
        this.setOperator(op);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Expression getLeft() {
        return this.left;
    }

    public Operator getOperator() {
        return this.op;
    }

    public Expression getRight() {
        return this.right;
    }

    public BinaryExpr setLeft(Expression left) {
        this.notifyPropertyChange(ObservableProperty.LEFT, this.left, left);
        this.left = left;
        this.setAsParentNodeOf(this.left);
        return this;
    }

    public BinaryExpr setOperator(Operator op) {
        this.notifyPropertyChange(ObservableProperty.OPERATOR, this.op, op);
        this.op = op;
        return this;
    }

    public BinaryExpr setRight(Expression right) {
        this.notifyPropertyChange(ObservableProperty.RIGHT, this.right, right);
        this.right = right;
        this.setAsParentNodeOf(this.right);
        return this;
    }

    public static enum Operator {
        or,
        and,
        binOr,
        binAnd,
        xor,
        equals,
        notEquals,
        less,
        greater,
        lessEquals,
        greaterEquals,
        lShift,
        rSignedShift,
        rUnsignedShift,
        plus,
        minus,
        times,
        divide,
        remainder;

    }
}

