/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.ArrayBracketPair;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithElementType;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public final class VariableDeclarator
extends Node
implements NodeWithType<VariableDeclarator, Type<?>> {
    private VariableDeclaratorId id;
    private Expression init;

    public VariableDeclarator() {
        this(Range.UNKNOWN, new VariableDeclaratorId(), null);
    }

    public VariableDeclarator(VariableDeclaratorId id) {
        this(Range.UNKNOWN, id, null);
    }

    public VariableDeclarator(String variableName) {
        this(Range.UNKNOWN, new VariableDeclaratorId(variableName), null);
    }

    public VariableDeclarator(VariableDeclaratorId id, Expression init) {
        this(Range.UNKNOWN, id, init);
    }

    public VariableDeclarator(String variableName, Expression init) {
        this(Range.UNKNOWN, new VariableDeclaratorId(variableName), init);
    }

    public VariableDeclarator(Range range, VariableDeclaratorId id, Expression init) {
        super(range);
        this.setId(id);
        this.setInit(init);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public VariableDeclaratorId getId() {
        return this.id;
    }

    public Optional<Expression> getInit() {
        return Optional.ofNullable(this.init);
    }

    public VariableDeclarator setId(VariableDeclaratorId id) {
        this.notifyPropertyChange(ObservableProperty.ID, this.id, id);
        this.id = Utils.assertNotNull(id);
        this.setAsParentNodeOf(this.id);
        return this;
    }

    public VariableDeclarator setInit(Expression init) {
        this.notifyPropertyChange(ObservableProperty.INIT, this.init, init);
        this.init = init;
        this.setAsParentNodeOf(this.init);
        return this;
    }

    public VariableDeclarator setInit(String init) {
        NameExpr newInit = new NameExpr(Utils.assertNotNull(init));
        this.notifyPropertyChange(ObservableProperty.INIT, this.init, newInit);
        this.init = newInit;
        this.setAsParentNodeOf(this.init);
        return this;
    }

    @Override
    public Type getType() {
        NodeWithElementType elementType = this.getAncestorOfType(NodeWithElementType.class);
        return ArrayType.wrapInArrayTypes(elementType.getElementType(), elementType.getArrayBracketPairsAfterElementType(), this.getId().getArrayBracketPairsAfterId());
    }

    @Override
    public VariableDeclarator setType(Type<?> type) {
        Pair<Type<?>, NodeList<ArrayBracketPair>> unwrapped = ArrayType.unwrapArrayTypes(type);
        NodeWithElementType nodeWithElementType = this.getAncestorOfType(NodeWithElementType.class);
        if (nodeWithElementType == null) {
            throw new IllegalStateException("Cannot set type without a parent");
        }
        nodeWithElementType.setElementType((Type)unwrapped.a);
        nodeWithElementType.setArrayBracketPairsAfterElementType(new NodeList<ArrayBracketPair>());
        this.getId().setArrayBracketPairsAfterId((NodeList)unwrapped.b);
        return this;
    }
}

