/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class ArrayCreationLevel
extends Node
implements NodeWithAnnotations<ArrayCreationLevel> {
    private Expression dimension;
    private NodeList<AnnotationExpr> annotations = new NodeList();

    public ArrayCreationLevel() {
        this(Range.UNKNOWN, null, new NodeList<AnnotationExpr>());
    }

    public ArrayCreationLevel(int dimension) {
        this(Range.UNKNOWN, new IntegerLiteralExpr("" + dimension), new NodeList<AnnotationExpr>());
    }

    public ArrayCreationLevel(Expression dimension) {
        this(Range.UNKNOWN, dimension, new NodeList<AnnotationExpr>());
    }

    public ArrayCreationLevel(Expression dimension, NodeList<AnnotationExpr> annotations) {
        this(Range.UNKNOWN, dimension, annotations);
    }

    public ArrayCreationLevel(Range range, Expression dimension, NodeList<AnnotationExpr> annotations) {
        super(range);
        this.setDimension(dimension);
        this.setAnnotations((NodeList)annotations);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public ArrayCreationLevel setDimension(Expression dimension) {
        this.notifyPropertyChange(ObservableProperty.DIMENSION, this.dimension, dimension);
        this.dimension = dimension;
        this.setAsParentNodeOf(dimension);
        return this;
    }

    public Optional<Expression> getDimension() {
        return Optional.ofNullable(this.dimension);
    }

    @Override
    public NodeList<AnnotationExpr> getAnnotations() {
        return this.annotations;
    }

    @Override
    public ArrayCreationLevel setAnnotations(NodeList<AnnotationExpr> annotations) {
        this.notifyPropertyChange(ObservableProperty.ANNOTATIONS, this.annotations, annotations);
        this.setAsParentNodeOf(annotations);
        this.annotations = Utils.assertNotNull(annotations);
        return this;
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        return Arrays.asList(this.annotations);
    }
}

