/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.stmt;

import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.List;

public final class BlockStmt
extends Statement {
    private List<Statement> stmts;

    public BlockStmt() {
    }

    public BlockStmt(List<Statement> stmts) {
        this.setStmts(stmts);
    }

    public BlockStmt(Range range, List<Statement> stmts) {
        super(range);
        this.setStmts(stmts);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public List<Statement> getStmts() {
        this.stmts = Utils.ensureNotNull(this.stmts);
        return this.stmts;
    }

    public void setStmts(List<Statement> stmts) {
        this.stmts = stmts;
        this.setAsParentNodeOf(this.stmts);
    }

    public BlockStmt addStatement(Statement statement) {
        this.getStmts().add(statement);
        statement.setParentNode(this);
        return this;
    }

    public BlockStmt addStatement(String statement) {
        return this.addStatement(new ExpressionStmt(new NameExpr(statement)));
    }

    public BlockStmt addStatement(Expression expr) {
        return this.addStatement(new ExpressionStmt(expr));
    }
}

