/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.ASTParser;
import com.github.javaparser.CommentsInserter;
import com.github.javaparser.ParseException;
import com.github.javaparser.Provider;
import com.github.javaparser.StreamProvider;
import com.github.javaparser.Token;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.List;

public final class JavaParser {
    private static final CommentsInserter commentsInserter = new CommentsInserter();
    private static final Charset UTF8 = Charset.forName("utf-8");
    private ASTParser astParser = null;
    private Provider provider = null;

    public JavaParser setSource(Provider provider) {
        this.provider = provider;
        if (this.astParser == null) {
            this.astParser = new ASTParser(provider);
        } else {
            this.astParser.ReInit(provider);
        }
        return this;
    }

    public JavaParser setSource(Reader reader) {
        return this.setSource(new StreamProvider(reader));
    }

    public JavaParser setSource(InputStream input) throws IOException {
        return this.setSource(new StreamProvider(input));
    }

    public JavaParser setSource(InputStream input, Charset encoding) throws IOException {
        return this.setSource(new StreamProvider(input, encoding.name()));
    }

    public JavaParser setSource(File file) throws IOException {
        return this.setSource(new FileInputStream(file));
    }

    public JavaParser setSource(File file, Charset encoding) throws IOException {
        return this.setSource(new FileInputStream(file), encoding);
    }

    public JavaParser setSource(String source) {
        return this.setSource(new StringReader(source));
    }

    public List<Token> getTokens() {
        this.checkSourceSet();
        return this.astParser.getTokens();
    }

    private void checkSourceSet() {
        if (this.astParser == null || this.provider == null) {
            throw new IllegalStateException("Please setSource() before doing any parsing.");
        }
    }

    public CompilationUnit parse() throws ParseException {
        try {
            this.checkSourceSet();
            CompilationUnit compilationUnit = this.astParser.CompilationUnit();
            return compilationUnit;
        }
        finally {
            this.closeProvider();
        }
    }

    private void closeProvider() {
        try {
            this.checkSourceSet();
            this.provider.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public BlockStmt parseBlock() throws ParseException {
        try {
            this.checkSourceSet();
            BlockStmt blockStmt = this.astParser.Block();
            return blockStmt;
        }
        finally {
            this.closeProvider();
        }
    }

    public List<Statement> parseStatements() throws ParseException {
        try {
            this.checkSourceSet();
            List<Statement> list = this.astParser.Statements();
            return list;
        }
        finally {
            this.closeProvider();
        }
    }

    public Statement parseStatement() throws ParseException {
        try {
            this.checkSourceSet();
            Statement statement = this.astParser.Statement();
            return statement;
        }
        finally {
            this.closeProvider();
        }
    }

    public ImportDeclaration parseImport() throws ParseException {
        try {
            this.checkSourceSet();
            ImportDeclaration importDeclaration = this.astParser.ImportDeclaration();
            return importDeclaration;
        }
        finally {
            this.closeProvider();
        }
    }

    public Expression parseExpression() throws ParseException {
        try {
            this.checkSourceSet();
            Expression expression = this.astParser.Expression();
            return expression;
        }
        finally {
            this.closeProvider();
        }
    }

    public AnnotationExpr parseAnnotation() throws ParseException {
        try {
            this.checkSourceSet();
            AnnotationExpr annotationExpr = this.astParser.Annotation();
            return annotationExpr;
        }
        finally {
            this.closeProvider();
        }
    }

    public BodyDeclaration<?> parseBodyDeclaration() throws ParseException {
        try {
            this.checkSourceSet();
            BodyDeclaration<?> bodyDeclaration = this.astParser.AnnotationBodyDeclaration();
            return bodyDeclaration;
        }
        finally {
            this.closeProvider();
        }
    }

    public BodyDeclaration<?> parseClassBodyDeclaration() throws ParseException {
        try {
            this.checkSourceSet();
            BodyDeclaration<?> bodyDeclaration = this.astParser.ClassOrInterfaceBodyDeclaration(false);
            return bodyDeclaration;
        }
        finally {
            this.closeProvider();
        }
    }

    public BodyDeclaration<?> parseInterfaceBodyDeclaration() throws ParseException {
        try {
            this.checkSourceSet();
            BodyDeclaration<?> bodyDeclaration = this.astParser.ClassOrInterfaceBodyDeclaration(true);
            return bodyDeclaration;
        }
        finally {
            this.closeProvider();
        }
    }

    public static boolean getDoNotConsiderAnnotationsAsNodeStartForCodeAttribution() {
        return commentsInserter.getDoNotConsiderAnnotationsAsNodeStartForCodeAttribution();
    }

    public static void setDoNotConsiderAnnotationsAsNodeStartForCodeAttribution(boolean newValue) {
        commentsInserter.setDoNotConsiderAnnotationsAsNodeStartForCodeAttribution(newValue);
    }

    public static boolean getDoNotAssignCommentsPreceedingEmptyLines() {
        return commentsInserter.getDoNotAssignCommentsPreceedingEmptyLines();
    }

    public static void setDoNotAssignCommentsPreceedingEmptyLines(boolean newValue) {
        commentsInserter.setDoNotAssignCommentsPreceedingEmptyLines(newValue);
    }

    public static CompilationUnit parse(InputStream in, Charset encoding) throws ParseException {
        return JavaParser.parse(in, encoding, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompilationUnit parse(InputStream in, Charset encoding, boolean considerComments) throws ParseException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(in, encoding);){
            CompilationUnit compilationUnit = JavaParser.parse(inputStreamReader, considerComments);
            return compilationUnit;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe.getMessage());
        }
    }

    public static CompilationUnit parse(InputStream in) throws ParseException {
        return JavaParser.parse(in, UTF8, true);
    }

    public static CompilationUnit parse(File file, Charset encoding) throws ParseException, IOException {
        return JavaParser.parse(file, encoding, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompilationUnit parse(File file, Charset encoding, boolean considerComments) throws ParseException {
        try (FileInputStream in = new FileInputStream(file);){
            CompilationUnit compilationUnit = JavaParser.parse(in, encoding, considerComments);
            return compilationUnit;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe.getMessage());
        }
    }

    public static CompilationUnit parse(File file) throws ParseException, IOException {
        return JavaParser.parse(file, UTF8, true);
    }

    public static CompilationUnit parse(Reader reader) throws ParseException {
        return JavaParser.parse(reader, true);
    }

    public static CompilationUnit parse(Reader reader, boolean considerComments) throws ParseException {
        try {
            String comments = Utils.readerToString(reader);
            CompilationUnit cu = new JavaParser().setSource(comments).parse();
            if (considerComments) {
                commentsInserter.insertComments(cu, comments);
            }
            return cu;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe.getMessage());
        }
    }

    public static CompilationUnit parse(String code, boolean considerComments) throws ParseException {
        return JavaParser.parse(new StringReader(code), considerComments);
    }

    public static CompilationUnit parse(String code) throws ParseException {
        return JavaParser.parse(code, true);
    }

    public static BlockStmt parseBlock(String blockStatement) throws ParseException {
        return new JavaParser().setSource(blockStatement).parseBlock();
    }

    public static Statement parseStatement(String statement) throws ParseException {
        return new JavaParser().setSource(statement).parseStatement();
    }

    public static List<Statement> parseStatements(String statements) throws ParseException {
        return new JavaParser().setSource(statements).parseStatements();
    }

    public static ImportDeclaration parseImport(String importDeclaration) throws ParseException {
        return new JavaParser().setSource(importDeclaration).parseImport();
    }

    public static Expression parseExpression(String expression) throws ParseException {
        return new JavaParser().setSource(expression).parseExpression();
    }

    public static AnnotationExpr parseAnnotation(String annotation) throws ParseException {
        return new JavaParser().setSource(annotation).parseAnnotation();
    }

    public static BodyDeclaration<?> parseBodyDeclaration(String body) throws ParseException {
        return new JavaParser().setSource(body).parseBodyDeclaration();
    }

    public static BodyDeclaration<?> parseClassBodyDeclaration(String body) throws ParseException {
        return new JavaParser().setSource(body).parseClassBodyDeclaration();
    }

    public static BodyDeclaration parseInterfaceBodyDeclaration(String body) throws ParseException {
        return new JavaParser().setSource(body).parseInterfaceBodyDeclaration();
    }
}

