/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.stmt;

import com.github.javaparser.Range;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithBody;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public final class ForStmt
extends Statement
implements NodeWithBody<ForStmt> {
    private NodeList<Expression> initialization;
    private Expression compare;
    private NodeList<Expression> update;
    private Statement body;

    public ForStmt() {
        this(null, new NodeList<Expression>(), new BooleanLiteralExpr(), new NodeList<Expression>(), new ReturnStmt());
    }

    public ForStmt(NodeList<Expression> initialization, Expression compare, NodeList<Expression> update, Statement body) {
        this(null, initialization, compare, update, body);
    }

    public ForStmt(Range range, NodeList<Expression> initialization, Expression compare, NodeList<Expression> update, Statement body) {
        super(range);
        this.setCompare(compare);
        this.setInitialization(initialization);
        this.setUpdate(update);
        this.setBody(body);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public Statement getBody() {
        return this.body;
    }

    public Optional<Expression> getCompare() {
        return Optional.ofNullable(this.compare);
    }

    public NodeList<Expression> getInitialization() {
        return this.initialization;
    }

    public NodeList<Expression> getUpdate() {
        return this.update;
    }

    @Override
    public ForStmt setBody(Statement body) {
        this.notifyPropertyChange(ObservableProperty.BODY, this.body, body);
        this.body = body;
        this.setAsParentNodeOf(this.body);
        return this;
    }

    public ForStmt setCompare(Expression compare) {
        this.notifyPropertyChange(ObservableProperty.COMPARE, this.compare, compare);
        this.compare = compare;
        this.setAsParentNodeOf(this.compare);
        return this;
    }

    public ForStmt setInitialization(NodeList<Expression> initialization) {
        this.notifyPropertyChange(ObservableProperty.INITIALIZER, this.initialization, initialization);
        this.initialization = Utils.assertNotNull(initialization);
        this.setAsParentNodeOf(this.initialization);
        return this;
    }

    public ForStmt setUpdate(NodeList<Expression> update) {
        this.notifyPropertyChange(ObservableProperty.UPDATE, this.update, update);
        this.update = Utils.assertNotNull(update);
        this.setAsParentNodeOf(this.update);
        return this;
    }
}

