/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.comments;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.observer.ObservableProperty;
import java.util.Optional;

public abstract class Comment
extends Node {
    private String content;
    private Node commentedNode;

    public Comment(Range range, String content) {
        super(range);
        this.content = content;
    }

    public final String getContent() {
        return this.content;
    }

    public Comment setContent(String content) {
        this.notifyPropertyChange(ObservableProperty.CONTENT, this.content, content);
        this.content = content;
        return this;
    }

    public boolean isLineComment() {
        return false;
    }

    public LineComment asLineComment() {
        if (this.isLineComment()) {
            return (LineComment)this;
        }
        throw new UnsupportedOperationException("Not a line comment");
    }

    public Optional<Node> getCommentedNode() {
        return Optional.ofNullable(this.commentedNode);
    }

    public Comment setCommentedNode(Node commentedNode) {
        this.notifyPropertyChange(ObservableProperty.COMMENTED_NODE, this.commentedNode, commentedNode);
        if (commentedNode == null) {
            this.commentedNode = null;
            return this;
        }
        if (commentedNode == this) {
            throw new IllegalArgumentException();
        }
        if (commentedNode instanceof Comment) {
            throw new IllegalArgumentException();
        }
        this.commentedNode = commentedNode;
        return this;
    }

    public boolean isOrphan() {
        return this.commentedNode == null;
    }
}

