/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.stmt;

import com.github.javaparser.Range;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithStatements;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public final class SwitchEntryStmt
extends Statement
implements NodeWithStatements<SwitchEntryStmt> {
    private Expression label;
    private NodeList<Statement> statements;

    public SwitchEntryStmt() {
        this(null, null, new NodeList<Statement>());
    }

    public SwitchEntryStmt(Expression label, NodeList<Statement> statements) {
        this(null, label, statements);
    }

    public SwitchEntryStmt(Range range, Expression label, NodeList<Statement> statements) {
        super(range);
        this.setLabel(label);
        this.setStatements((NodeList)statements);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Optional<Expression> getLabel() {
        return Optional.ofNullable(this.label);
    }

    @Override
    public NodeList<Statement> getStatements() {
        return this.statements;
    }

    public SwitchEntryStmt setLabel(Expression label) {
        this.notifyPropertyChange(ObservableProperty.LABEL, this.label, label);
        this.label = label;
        this.setAsParentNodeOf(this.label);
        return this;
    }

    @Override
    public SwitchEntryStmt setStatements(NodeList<Statement> statements) {
        this.notifyPropertyChange(ObservableProperty.STATEMENTS, this.statements, statements);
        this.statements = Utils.assertNotNull(statements);
        this.setAsParentNodeOf(this.statements);
        return this;
    }
}

