/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.nodeTypes;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface NodeWithMembers<N extends Node> {
    public NodeList<BodyDeclaration<?>> getMembers();

    default public BodyDeclaration<?> getMember(int i) {
        return (BodyDeclaration)this.getMembers().get(i);
    }

    public N setMembers(NodeList<BodyDeclaration<?>> var1);

    default public FieldDeclaration addField(Class<?> typeClass, String name, Modifier ... modifiers) {
        ((Node)((Object)this)).tryAddImportToParentCompilationUnit(typeClass);
        return this.addField(typeClass.getSimpleName(), name, modifiers);
    }

    default public FieldDeclaration addField(String type, String name, Modifier ... modifiers) {
        return this.addField(new ClassOrInterfaceType(type), name, modifiers);
    }

    default public FieldDeclaration addField(Type<?> type, String name, Modifier ... modifiers) {
        FieldDeclaration fieldDeclaration = new FieldDeclaration();
        this.getMembers().add(fieldDeclaration);
        VariableDeclarator variable = new VariableDeclarator(type, name);
        fieldDeclaration.getVariables().add(variable);
        fieldDeclaration.setModifiers(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))));
        return fieldDeclaration;
    }

    default public FieldDeclaration addPrivateField(Class<?> typeClass, String name) {
        return this.addField(typeClass, name, Modifier.PRIVATE);
    }

    default public FieldDeclaration addPrivateField(String type, String name) {
        return this.addField(type, name, Modifier.PRIVATE);
    }

    default public FieldDeclaration addPublicField(Class<?> typeClass, String name) {
        return this.addField(typeClass, name, Modifier.PUBLIC);
    }

    default public FieldDeclaration addPublicField(String type, String name) {
        return this.addField(type, name, Modifier.PUBLIC);
    }

    default public FieldDeclaration addProtectedField(Class<?> typeClass, String name) {
        return this.addField(typeClass, name, Modifier.PROTECTED);
    }

    default public FieldDeclaration addProtectedField(String type, String name) {
        return this.addField(type, name, Modifier.PROTECTED);
    }

    default public MethodDeclaration addMethod(String methodName, Modifier ... modifiers) {
        MethodDeclaration methodDeclaration = new MethodDeclaration();
        methodDeclaration.setName(methodName);
        methodDeclaration.setType((Type)VoidType.VOID_TYPE);
        methodDeclaration.setModifiers(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))));
        this.getMembers().add(methodDeclaration);
        methodDeclaration.setParentNode((Node)((Object)this));
        return methodDeclaration;
    }

    default public ConstructorDeclaration addConstructor(Modifier ... modifiers) {
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration();
        constructorDeclaration.setModifiers(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))));
        constructorDeclaration.setName(((TypeDeclaration)this).getName());
        this.getMembers().add(constructorDeclaration);
        constructorDeclaration.setParentNode((Node)((Object)this));
        return constructorDeclaration;
    }

    default public BlockStmt addInitializer() {
        BlockStmt block = new BlockStmt();
        InitializerDeclaration initializerDeclaration = new InitializerDeclaration(false, block);
        this.getMembers().add(initializerDeclaration);
        initializerDeclaration.setParentNode((Node)((Object)this));
        return block;
    }

    default public BlockStmt addStaticInitializer() {
        BlockStmt block = new BlockStmt();
        InitializerDeclaration initializerDeclaration = new InitializerDeclaration(true, block);
        this.getMembers().add(initializerDeclaration);
        initializerDeclaration.setParentNode((Node)((Object)this));
        return block;
    }

    default public List<MethodDeclaration> getMethodsByName(String name) {
        return this.getMembers().stream().filter(m -> m instanceof MethodDeclaration && ((MethodDeclaration)m).getNameAsString().equals(name)).map(m -> (MethodDeclaration)m).collect(Collectors.toList());
    }

    default public List<MethodDeclaration> getMethods() {
        return Collections.unmodifiableList(this.getMembers().stream().filter(m -> m instanceof MethodDeclaration).map(m -> (MethodDeclaration)m).collect(Collectors.toList()));
    }

    default public List<MethodDeclaration> getMethodsByParameterTypes(String ... paramTypes) {
        return this.getMembers().stream().filter(m -> m instanceof MethodDeclaration && ((MethodDeclaration)m).getParameters().stream().map(p -> p.getType().toString()).collect(Collectors.toSet()).equals(Stream.of(paramTypes).collect(Collectors.toSet()))).map(m -> (MethodDeclaration)m).collect(Collectors.toList());
    }

    default public List<MethodDeclaration> getMethodsByParameterTypes(Class<?> ... paramTypes) {
        return this.getMembers().stream().filter(m -> m instanceof MethodDeclaration && ((MethodDeclaration)m).getParameters().stream().map(p -> p.getType().toString()).collect(Collectors.toSet()).equals(Stream.of(paramTypes).map(Class::getSimpleName).collect(Collectors.toSet()))).map(m -> (MethodDeclaration)m).collect(Collectors.toList());
    }

    default public FieldDeclaration getFieldByName(String name) {
        return this.getMembers().stream().filter(m -> m instanceof FieldDeclaration && ((FieldDeclaration)m).getVariables().stream().anyMatch(var -> var.getNameAsString().equals(name))).findFirst().orElse(null);
    }

    default public List<FieldDeclaration> getFields() {
        return Collections.unmodifiableList(this.getMembers().stream().filter(m -> m instanceof FieldDeclaration).map(m -> (FieldDeclaration)m).collect(Collectors.toList()));
    }
}

