/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithExpression;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;

public final class UnaryExpr
extends Expression
implements NodeWithExpression<UnaryExpr> {
    private Expression expression;
    private Operator operator;

    public UnaryExpr() {
        this(null, new IntegerLiteralExpr(), Operator.POSTFIX_INCREMENT);
    }

    public UnaryExpr(Expression expression, Operator operator) {
        this(null, expression, operator);
    }

    public UnaryExpr(Range range, Expression expression, Operator operator) {
        super(range);
        this.setExpression(expression);
        this.setOperator(operator);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public UnaryExpr setExpression(Expression expr) {
        this.notifyPropertyChange(ObservableProperty.EXPRESSION, this.expression, expr);
        this.expression = expr;
        this.setAsParentNodeOf(this.expression);
        return this;
    }

    public UnaryExpr setOperator(Operator op) {
        this.notifyPropertyChange(ObservableProperty.OPERATOR, this.operator, op);
        this.operator = op;
        return this;
    }

    public static enum Operator {
        PLUS("+", false),
        MINUS("-", false),
        PREFIX_INCREMENT("++", false),
        PREFIX_DECREMENT("--", false),
        LOGICAL_COMPLEMENT("!", false),
        BITWISE_COMPLEMENT("~", false),
        POSTFIX_INCREMENT("++", true),
        POSTFIX_DECREMENT("--", true);

        private final String codeRepresentation;
        private final boolean isPostfix;

        private Operator(String codeRepresentation, boolean isPostfix) {
            this.codeRepresentation = codeRepresentation;
            this.isPostfix = isPostfix;
        }

        public String asString() {
            return this.codeRepresentation;
        }

        public boolean isPostfix() {
            return this.isPostfix;
        }

        public boolean isPrefix() {
            return !this.isPostfix();
        }
    }
}

