/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.LiteralExpr;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;

public class StringLiteralExpr
extends LiteralExpr {
    protected String value;

    public StringLiteralExpr() {
        this(null, "empty");
    }

    public StringLiteralExpr(String value) {
        this(null, value);
    }

    public static StringLiteralExpr escape(String string) {
        return new StringLiteralExpr(Utils.escapeEndOfLines(string));
    }

    public StringLiteralExpr(Range range, String value) {
        super(range);
        this.setValue(value);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public final String getValue() {
        return this.value;
    }

    public final StringLiteralExpr setValue(String value) {
        this.notifyPropertyChange(ObservableProperty.VALUE, this.value, value);
        this.value = Utils.assertNotNull(value);
        if (value.contains("\n") || value.contains("\r")) {
            throw new IllegalArgumentException("Illegal literal expression: newlines (line feed or carriage return) have to be escaped");
        }
        return this;
    }
}

