/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithParameters;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;

public class LambdaExpr
extends Expression
implements NodeWithParameters<LambdaExpr> {
    private NodeList<Parameter> parameters;
    private boolean isEnclosingParameters;
    private Statement body;

    public LambdaExpr() {
        this(null, new NodeList<Parameter>(), new EmptyStmt(), false);
    }

    public LambdaExpr(Range range, NodeList<Parameter> parameters, Statement body, boolean isEnclosingParameters) {
        super(range);
        this.setParameters((NodeList)parameters);
        this.setBody(body);
        this.setEnclosingParameters(isEnclosingParameters);
    }

    @Override
    public NodeList<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public LambdaExpr setParameters(NodeList<Parameter> parameters) {
        this.notifyPropertyChange(ObservableProperty.PARAMETERS, this.parameters, parameters);
        this.parameters = Utils.assertNotNull(parameters);
        this.setAsParentNodeOf(this.parameters);
        return this;
    }

    public Statement getBody() {
        return this.body;
    }

    public LambdaExpr setBody(Statement body) {
        this.body = body;
        this.setAsParentNodeOf(this.body);
        return this;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public boolean isEnclosingParameters() {
        return this.isEnclosingParameters;
    }

    public LambdaExpr setEnclosingParameters(boolean enclosingParameters) {
        this.notifyPropertyChange(ObservableProperty.ENCLOSING_PARAMETERS, this.isEnclosingParameters, enclosingParameters);
        this.isEnclosingParameters = enclosingParameters;
        return this;
    }
}

