/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;

public final class BinaryExpr
extends Expression {
    private Expression left;
    private Expression right;
    private Operator operator;

    public BinaryExpr() {
        this(null, new BooleanLiteralExpr(), new BooleanLiteralExpr(), Operator.EQUALS);
    }

    public BinaryExpr(Expression left, Expression right, Operator operator) {
        this(null, left, right, operator);
    }

    public BinaryExpr(Range range, Expression left, Expression right, Operator operator) {
        super(range);
        this.setLeft(left);
        this.setRight(right);
        this.setOperator(operator);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Expression getLeft() {
        return this.left;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getRight() {
        return this.right;
    }

    public BinaryExpr setLeft(Expression left) {
        this.notifyPropertyChange(ObservableProperty.LEFT, this.left, left);
        this.left = left;
        this.setAsParentNodeOf(this.left);
        return this;
    }

    public BinaryExpr setOperator(Operator op) {
        this.notifyPropertyChange(ObservableProperty.OPERATOR, this.operator, op);
        this.operator = op;
        return this;
    }

    public BinaryExpr setRight(Expression right) {
        this.notifyPropertyChange(ObservableProperty.RIGHT, this.right, right);
        this.right = right;
        this.setAsParentNodeOf(this.right);
        return this;
    }

    public static enum Operator {
        OR("||"),
        AND("&&"),
        BINARY_OR("|"),
        BINARY_AND("&"),
        XOR("^"),
        EQUALS("=="),
        NOT_EQUALS("!="),
        LESS("<"),
        GREATER(">"),
        LESS_EQUALS("<="),
        GREATER_EQUALS(">="),
        LEFT_SHIFT("<<"),
        SIGNED_RIGHT_SHIFT(">>"),
        UNSIGNED_RIGHT_SHIFT(">>>"),
        PLUS("+"),
        MINUS("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        REMAINDER("%");

        private final String codeRepresentation;

        private Operator(String codeRepresentation) {
            this.codeRepresentation = codeRepresentation;
        }

        public String asString() {
            return this.codeRepresentation;
        }
    }
}

