/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.nodeTypes.NodeWithJavaDoc;
import com.github.javaparser.ast.nodeTypes.NodeWithMembers;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

public abstract class TypeDeclaration<T extends Node>
extends BodyDeclaration<T>
implements NodeWithSimpleName<T>,
NodeWithJavaDoc<T>,
NodeWithModifiers<T>,
NodeWithMembers<T> {
    private SimpleName name;
    private EnumSet<Modifier> modifiers;
    private NodeList<BodyDeclaration<?>> members;

    public TypeDeclaration() {
        this(null, new NodeList<AnnotationExpr>(), EnumSet.noneOf(Modifier.class), new SimpleName(), new NodeList());
    }

    public TypeDeclaration(EnumSet<Modifier> modifiers, String name) {
        this(null, new NodeList<AnnotationExpr>(), modifiers, new SimpleName(name), new NodeList());
    }

    public TypeDeclaration(NodeList<AnnotationExpr> annotations, EnumSet<Modifier> modifiers, SimpleName name, NodeList<BodyDeclaration<?>> members) {
        this(null, annotations, modifiers, name, members);
    }

    public TypeDeclaration(Range range, NodeList<AnnotationExpr> annotations, EnumSet<Modifier> modifiers, SimpleName name, NodeList<BodyDeclaration<?>> members) {
        super(range, annotations);
        this.setName(name);
        this.setModifiers(modifiers);
        this.setMembers(members);
    }

    public TypeDeclaration<T> addMember(BodyDeclaration<?> decl) {
        NodeList<BodyDeclaration<?>> members = this.getMembers();
        members.add(decl);
        return this;
    }

    @Override
    public NodeList<BodyDeclaration<?>> getMembers() {
        return this.members;
    }

    @Override
    public final EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public T setMembers(NodeList<BodyDeclaration<?>> members) {
        this.notifyPropertyChange(ObservableProperty.MEMBERS, this.members, members);
        this.members = Utils.assertNotNull(members);
        this.setAsParentNodeOf(this.members);
        return (T)this;
    }

    @Override
    public T setModifiers(EnumSet<Modifier> modifiers) {
        this.notifyPropertyChange(ObservableProperty.MODIFIERS, this.modifiers, modifiers);
        this.modifiers = Utils.assertNotNull(modifiers);
        return (T)this;
    }

    @Override
    public T setName(SimpleName name) {
        this.notifyPropertyChange(ObservableProperty.NAME, this.name, name);
        this.name = Utils.assertNotNull(name);
        this.setAsParentNodeOf(name);
        return (T)this;
    }

    @Override
    public final SimpleName getName() {
        return this.name;
    }

    @Override
    public JavadocComment getJavaDoc() {
        if (this.getComment() instanceof JavadocComment) {
            return (JavadocComment)this.getComment();
        }
        return null;
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        LinkedList res = new LinkedList(super.getNodeLists());
        res.add(this.members);
        return res;
    }
}

