/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithJavaDoc;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithVariables;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

public final class FieldDeclaration
extends BodyDeclaration<FieldDeclaration>
implements NodeWithJavaDoc<FieldDeclaration>,
NodeWithModifiers<FieldDeclaration>,
NodeWithVariables<FieldDeclaration> {
    private EnumSet<Modifier> modifiers;
    private NodeList<VariableDeclarator> variables;

    public FieldDeclaration() {
        this(null, EnumSet.noneOf(Modifier.class), new NodeList<AnnotationExpr>(), new NodeList<VariableDeclarator>());
    }

    public FieldDeclaration(EnumSet<Modifier> modifiers, VariableDeclarator variable) {
        this(null, modifiers, new NodeList<AnnotationExpr>(), NodeList.nodeList((Node[])new VariableDeclarator[]{variable}));
    }

    public FieldDeclaration(EnumSet<Modifier> modifiers, NodeList<VariableDeclarator> variables) {
        this(null, modifiers, new NodeList<AnnotationExpr>(), variables);
    }

    public FieldDeclaration(EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<VariableDeclarator> variables) {
        this(null, modifiers, annotations, variables);
    }

    public FieldDeclaration(Range range, EnumSet<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<VariableDeclarator> variables) {
        super(range, annotations);
        this.setModifiers((EnumSet)modifiers);
        this.setVariables((NodeList)variables);
    }

    public FieldDeclaration(EnumSet<Modifier> modifiers, Type<?> type, String name) {
        this(Utils.assertNotNull(modifiers), new VariableDeclarator(type, Utils.assertNotNull(name)));
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public EnumSet<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public NodeList<VariableDeclarator> getVariables() {
        return this.variables;
    }

    @Override
    public FieldDeclaration setModifiers(EnumSet<Modifier> modifiers) {
        this.notifyPropertyChange(ObservableProperty.MODIFIERS, this.modifiers, modifiers);
        this.modifiers = Utils.assertNotNull(modifiers);
        return this;
    }

    @Override
    public FieldDeclaration setVariables(NodeList<VariableDeclarator> variables) {
        this.notifyPropertyChange(ObservableProperty.VARIABLES, this.variables, variables);
        this.variables = Utils.assertNotNull(variables);
        this.setAsParentNodeOf(this.variables);
        return this;
    }

    @Override
    public JavadocComment getJavaDoc() {
        if (this.getComment() instanceof JavadocComment) {
            return (JavadocComment)this.getComment();
        }
        return null;
    }

    public MethodDeclaration createGetter() {
        if (this.getVariables().size() != 1) {
            throw new IllegalStateException("You can use this only when the field declares only 1 variable name");
        }
        ClassOrInterfaceDeclaration parentClass = this.getAncestorOfType(ClassOrInterfaceDeclaration.class);
        EnumDeclaration parentEnum = this.getAncestorOfType(EnumDeclaration.class);
        if (parentClass == null && parentEnum == null || parentClass != null && parentClass.isInterface()) {
            throw new IllegalStateException("You can use this only when the field is attached to a class or an enum");
        }
        VariableDeclarator variable = this.getVariable(0);
        String fieldName = variable.getNameAsString();
        String fieldNameUpper = fieldName.toUpperCase().substring(0, 1) + fieldName.substring(1, fieldName.length());
        MethodDeclaration getter = parentClass != null ? parentClass.addMethod("get" + fieldNameUpper, Modifier.PUBLIC) : parentEnum.addMethod("get" + fieldNameUpper, Modifier.PUBLIC);
        getter.setType((Type)variable.getType());
        BlockStmt blockStmt = new BlockStmt();
        getter.setBody(blockStmt);
        blockStmt.addStatement(new ReturnStmt(fieldName));
        return getter;
    }

    public MethodDeclaration createSetter() {
        if (this.getVariables().size() != 1) {
            throw new IllegalStateException("You can use this only when the field declares only 1 variable name");
        }
        ClassOrInterfaceDeclaration parentClass = this.getAncestorOfType(ClassOrInterfaceDeclaration.class);
        EnumDeclaration parentEnum = this.getAncestorOfType(EnumDeclaration.class);
        if (parentClass == null && parentEnum == null || parentClass != null && parentClass.isInterface()) {
            throw new IllegalStateException("You can use this only when the field is attached to a class or an enum");
        }
        VariableDeclarator variable = this.getVariable(0);
        String fieldName = variable.getNameAsString();
        String fieldNameUpper = fieldName.toUpperCase().substring(0, 1) + fieldName.substring(1, fieldName.length());
        MethodDeclaration setter = parentClass != null ? parentClass.addMethod("set" + fieldNameUpper, Modifier.PUBLIC) : parentEnum.addMethod("set" + fieldNameUpper, Modifier.PUBLIC);
        setter.setType((Type)VoidType.VOID_TYPE);
        setter.getParameters().add(new Parameter(variable.getType(), fieldName));
        BlockStmt blockStmt2 = new BlockStmt();
        setter.setBody(blockStmt2);
        blockStmt2.addStatement(new AssignExpr(new NameExpr("this." + fieldName), new NameExpr(fieldName), AssignExpr.Operator.ASSIGN));
        return setter;
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        LinkedList res = new LinkedList(super.getNodeLists());
        res.add(this.variables);
        return res;
    }
}

