/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.stmt;

import com.github.javaparser.Range;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;

public final class LabeledStmt
extends Statement {
    private String label;
    private Statement statement;

    public LabeledStmt() {
        this(null, "empty", new EmptyStmt());
    }

    public LabeledStmt(String label, Statement statement) {
        this(null, label, statement);
    }

    public LabeledStmt(Range range, String label, Statement statement) {
        super(range);
        this.setLabel(label);
        this.setStatement(statement);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public String getLabel() {
        return this.label;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public LabeledStmt setLabel(String label) {
        this.notifyPropertyChange(ObservableProperty.LABEL, this.label, label);
        this.label = Utils.assertNotNull(label);
        return this;
    }

    public LabeledStmt setStatement(Statement statement) {
        this.notifyPropertyChange(ObservableProperty.STATEMENT, this.statement, statement);
        this.statement = Utils.assertNotNull(statement);
        this.setAsParentNodeOf(this.statement);
        return this;
    }
}

