/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;

public final class AssignExpr
extends Expression {
    private Expression target;
    private Expression value;
    private Operator operator;

    public AssignExpr() {
        this(null, new NameExpr(), new StringLiteralExpr(), Operator.ASSIGN);
    }

    public AssignExpr(Expression target, Expression value, Operator operator) {
        this(null, target, value, operator);
    }

    public AssignExpr(Range range, Expression target, Expression value, Operator operator) {
        super(range);
        this.setTarget(target);
        this.setValue(value);
        this.setOperator(operator);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getTarget() {
        return this.target;
    }

    public Expression getValue() {
        return this.value;
    }

    public AssignExpr setOperator(Operator op) {
        this.operator = op;
        return this;
    }

    public AssignExpr setTarget(Expression target) {
        this.notifyPropertyChange(ObservableProperty.TARGET, this.target, target);
        this.target = target;
        this.setAsParentNodeOf(this.target);
        return this;
    }

    public AssignExpr setValue(Expression value) {
        this.notifyPropertyChange(ObservableProperty.VALUE, this.value, value);
        this.value = value;
        this.setAsParentNodeOf(this.value);
        return this;
    }

    public static enum Operator {
        ASSIGN("="),
        PLUS("+="),
        MINUS("-="),
        MULTIPLY("*="),
        DIVIDE("/="),
        AND("&="),
        OR("|="),
        XOR("^="),
        REMAINDER("%="),
        LEFT_SHIFT("<<="),
        SIGNED_RIGHT_SHIFT(">>="),
        UNSIGNED_RIGHT_SHIFT(">>>=");

        private final String codeRepresentation;

        private Operator(String codeRepresentation) {
            this.codeRepresentation = codeRepresentation;
        }

        public String asString() {
            return this.codeRepresentation;
        }
    }
}

