/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Range;
import com.github.javaparser.ast.ArrayBracketPair;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithElementType;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.nodeTypes.NodeWithVariableDeclaratorId;
import com.github.javaparser.ast.observing.ObservableProperty;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public final class VariableDeclarator
extends Node
implements NodeWithType<VariableDeclarator, Type<?>>,
NodeWithVariableDeclaratorId<VariableDeclarator> {
    private VariableDeclaratorId identifier;
    private Expression initializer;

    public VariableDeclarator() {
        this(null, new VariableDeclaratorId(), null);
    }

    public VariableDeclarator(VariableDeclaratorId identifier) {
        this(null, identifier, null);
    }

    public VariableDeclarator(String variableName) {
        this(null, new VariableDeclaratorId(variableName), null);
    }

    public VariableDeclarator(VariableDeclaratorId identifier, Expression initializer) {
        this(null, identifier, initializer);
    }

    public VariableDeclarator(String variableName, Expression initializer) {
        this(null, new VariableDeclaratorId(variableName), initializer);
    }

    public VariableDeclarator(Range range, VariableDeclaratorId identifier, Expression initializer) {
        super(range);
        this.setIdentifier(identifier);
        this.setInitializer(initializer);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public VariableDeclaratorId getIdentifier() {
        return this.identifier;
    }

    public Optional<Expression> getInitializer() {
        return Optional.ofNullable(this.initializer);
    }

    @Override
    public VariableDeclarator setIdentifier(VariableDeclaratorId identifier) {
        this.notifyPropertyChange(ObservableProperty.IDENTIFIER, this.identifier, identifier);
        this.identifier = Utils.assertNotNull(identifier);
        this.setAsParentNodeOf(this.identifier);
        return this;
    }

    public VariableDeclarator setInitializer(Expression initializer) {
        this.notifyPropertyChange(ObservableProperty.INITIALIZER, this.initializer, initializer);
        this.initializer = initializer;
        this.setAsParentNodeOf(this.initializer);
        return this;
    }

    public VariableDeclarator setInit(String init) {
        NameExpr newInit = new NameExpr(Utils.assertNotNull(init));
        this.notifyPropertyChange(ObservableProperty.INITIALIZER, this.initializer, newInit);
        this.initializer = newInit;
        this.setAsParentNodeOf(this.initializer);
        return this;
    }

    @Override
    public Type getType() {
        NodeWithElementType elementType = this.getAncestorOfType(NodeWithElementType.class);
        return ArrayType.wrapInArrayTypes((Type)elementType.getElementType().clone(), elementType.getArrayBracketPairsAfterElementType(), this.getIdentifier().getArrayBracketPairsAfterId());
    }

    @Override
    public VariableDeclarator setType(Type<?> type) {
        Pair<Type<?>, NodeList<ArrayBracketPair>> unwrapped = ArrayType.unwrapArrayTypes(type);
        NodeWithElementType nodeWithElementType = this.getAncestorOfType(NodeWithElementType.class);
        if (nodeWithElementType == null) {
            throw new IllegalStateException("Cannot set type without a parent");
        }
        nodeWithElementType.setElementType((Type)unwrapped.a);
        nodeWithElementType.setArrayBracketPairsAfterElementType(new NodeList<ArrayBracketPair>());
        this.getIdentifier().setArrayBracketPairsAfterId((NodeList)unwrapped.b);
        return this;
    }
}

