/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.expr;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.internal.Utils;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import java.util.List;

public final class MethodCallExpr
extends Expression {
    private Expression scope;
    private List<Type> typeArgs;
    private NameExpr name;
    private List<Expression> args;

    public MethodCallExpr() {
    }

    public MethodCallExpr(Expression scope, String name) {
        this.setScope(scope);
        this.setName(name);
    }

    public MethodCallExpr(Expression scope, String name, List<Expression> args) {
        this.setScope(scope);
        this.setName(name);
        this.setArgs(args);
    }

    @Deprecated
    public MethodCallExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression scope, List<Type> typeArgs, String name, List<Expression> args) {
        this(new Range(Position.pos(beginLine, beginColumn), Position.pos(endLine, endColumn)), scope, typeArgs, name, args);
    }

    public MethodCallExpr(Range range, Expression scope, List<Type> typeArgs, String name, List<Expression> args) {
        super(range);
        this.setScope(scope);
        this.setTypeArgs(typeArgs);
        this.setName(name);
        this.setArgs(args);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public List<Expression> getArgs() {
        this.args = Utils.ensureNotNull(this.args);
        return this.args;
    }

    public String getName() {
        return this.name.getName();
    }

    public NameExpr getNameExpr() {
        return this.name;
    }

    public Expression getScope() {
        return this.scope;
    }

    public List<Type> getTypeArgs() {
        this.typeArgs = Utils.ensureNotNull(this.typeArgs);
        return this.typeArgs;
    }

    public void setArgs(List<Expression> args) {
        this.args = args;
        this.setAsParentNodeOf(this.args);
    }

    public void setName(String name) {
        this.setNameExpr(new NameExpr(name));
    }

    public void setNameExpr(NameExpr name) {
        this.name = name;
        this.setAsParentNodeOf(this.name);
    }

    public void setScope(Expression scope) {
        this.scope = scope;
        this.setAsParentNodeOf(this.scope);
    }

    public void setTypeArgs(List<Type> typeArgs) {
        this.typeArgs = typeArgs;
        this.setAsParentNodeOf(this.typeArgs);
    }
}

