/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.serialization;

import com.github.javaparser.JavaToken;
import com.github.javaparser.Range;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.metamodel.BaseNodeMetaModel;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.PropertyMetaModel;
import com.github.javaparser.utils.Log;
import com.github.javaparser.utils.Utils;
import java.util.EnumSet;
import java.util.Objects;
import javax.json.stream.JsonGenerator;

public class JavaParserJsonSerializer {
    public void serialize(Node node, JsonGenerator generator) {
        Objects.requireNonNull(node);
        Log.info((String)"Serializing Node to JSON.", (Object[])new Object[0]);
        this.serialize(null, node, generator);
    }

    private void serialize(String nodeName, Node node, JsonGenerator generator) {
        Objects.requireNonNull(node);
        BaseNodeMetaModel nodeMetaModel = (BaseNodeMetaModel)JavaParserMetaModel.getNodeMetaModel(node.getClass()).orElseThrow(() -> new IllegalStateException("Unknown Node: " + node.getClass()));
        if (nodeName == null) {
            generator.writeStartObject();
        } else {
            generator.writeStartObject(nodeName);
        }
        generator.write(JsonNode.Class.propertyKey, node.getClass().getName());
        this.writeNonMetaProperties(node, generator);
        for (PropertyMetaModel propertyMetaModel : nodeMetaModel.getAllPropertyMetaModels()) {
            String name = propertyMetaModel.getName();
            Object value = propertyMetaModel.getValue(node);
            if (value == null) continue;
            if (propertyMetaModel.isNodeList()) {
                NodeList list = (NodeList)value;
                generator.writeStartArray(name);
                for (Object n : list) {
                    this.serialize(null, (Node)n, generator);
                }
                generator.writeEnd();
                continue;
            }
            if (propertyMetaModel.isEnumSet()) {
                EnumSet set = (EnumSet)value;
                generator.writeStartArray(name);
                for (Object n : set) {
                    generator.write(((Enum)n).name());
                }
                generator.writeEnd();
                continue;
            }
            if (propertyMetaModel.isNode()) {
                this.serialize(name, (Node)value, generator);
                continue;
            }
            generator.write(name, value.toString());
        }
        generator.writeEnd();
    }

    protected void writeNonMetaProperties(Node node, JsonGenerator generator) {
        this.writeRange(node, generator);
        this.writeTokens(node, generator);
    }

    protected void writeRange(Node node, JsonGenerator generator) {
        if (node.getRange().isPresent()) {
            Range range = (Range)node.getRange().get();
            generator.writeStartObject(JsonNode.Range.propertyKey);
            generator.write(JsonRange.BeginLine.propertyKey, range.begin.line);
            generator.write(JsonRange.BeginColumn.propertyKey, range.begin.column);
            generator.write(JsonRange.EndLine.propertyKey, range.end.line);
            generator.write(JsonRange.EndColumn.propertyKey, range.end.column);
            generator.writeEnd();
        }
    }

    protected void writeTokens(Node node, JsonGenerator generator) {
        if (node.getTokenRange().isPresent()) {
            TokenRange tokenRange = (TokenRange)node.getTokenRange().get();
            generator.writeStartObject(JsonNode.TokenRange.propertyKey);
            this.writeToken(JsonTokenRange.BeginToken.propertyKey, tokenRange.getBegin(), generator);
            this.writeToken(JsonTokenRange.EndToken.propertyKey, tokenRange.getEnd(), generator);
            generator.writeEnd();
        }
    }

    protected void writeToken(String name, JavaToken token, JsonGenerator generator) {
        generator.writeStartObject(name);
        generator.write(JsonToken.Kind.propertyKey, token.getKind());
        generator.write(JsonToken.Text.propertyKey, token.getText());
        generator.writeEnd();
    }

    public static enum JsonToken {
        Text("text"),
        Kind("kind");

        final String propertyKey;

        private JsonToken(String p) {
            this.propertyKey = p;
        }

        public String toString() {
            return this.propertyKey;
        }
    }

    public static enum JsonTokenRange {
        BeginToken("beginToken"),
        EndToken("endToken");

        final String propertyKey;

        private JsonTokenRange(String p) {
            this.propertyKey = p;
        }

        public String toString() {
            return this.propertyKey;
        }
    }

    public static enum JsonRange {
        BeginLine("beginLine"),
        BeginColumn("beginColumn"),
        EndLine("endLine"),
        EndColumn("endColumn");

        final String propertyKey;

        private JsonRange(String p) {
            this.propertyKey = p;
        }

        public String toString() {
            return this.propertyKey;
        }
    }

    public static enum JsonNode {
        Range("range"),
        TokenRange("tokenRange"),
        Comment(Utils.decapitalize((String)"Comment")),
        Class("!");

        final String propertyKey;

        private JsonNode(String p) {
            this.propertyKey = p;
        }

        public String toString() {
            return this.propertyKey;
        }
    }
}

