/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.serialization;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.metamodel.BaseNodeMetaModel;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.PropertyMetaModel;
import com.github.javaparser.utils.Log;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;

public class JavaParserJsonDeserializer {
    public Node deserializeObject(JsonReader reader) {
        Log.info((String)"Deserializing JSON to Node.", (Object[])new Object[0]);
        JsonObject jsonObject = reader.readObject();
        return this.deserializeObject(jsonObject);
    }

    private Node deserializeObject(JsonObject nodeJson) {
        try {
            String serializedNodeType = nodeJson.getString("!");
            BaseNodeMetaModel nodeMetaModel = (BaseNodeMetaModel)JavaParserMetaModel.getNodeMetaModel(Class.forName(serializedNodeType)).orElseThrow(() -> new IllegalStateException("Trying to deserialize an unknown node type: " + serializedNodeType));
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            for (String name : nodeJson.keySet()) {
                if (name.equals("!")) continue;
                PropertyMetaModel propertyMetaModel = nodeMetaModel.getAllPropertyMetaModels().stream().filter(mm -> mm.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalStateException("Unknown property: " + nodeMetaModel.getQualifiedClassName() + "." + name));
                if (propertyMetaModel.isNodeList()) {
                    JsonArray nodeListJson = nodeJson.getJsonArray(name);
                    parameters.put(name, this.deserializeNodeList(nodeListJson));
                    continue;
                }
                if (propertyMetaModel.isEnumSet()) {
                    JsonArray enumSetJson = nodeJson.getJsonArray(name);
                    parameters.put(name, this.deserializeEnumSet(enumSetJson));
                    continue;
                }
                if (propertyMetaModel.isNode()) {
                    parameters.put(name, this.deserializeObject(nodeJson.getJsonObject(name)));
                    continue;
                }
                Class type = propertyMetaModel.getType();
                if (type == String.class) {
                    parameters.put(name, nodeJson.getString(name));
                    continue;
                }
                if (type == Boolean.TYPE) {
                    parameters.put(name, Boolean.parseBoolean(nodeJson.getString(name)));
                    continue;
                }
                throw new IllegalStateException("Don't know how to convert: " + type);
            }
            return nodeMetaModel.construct(parameters);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private EnumSet<?> deserializeEnumSet(JsonArray enumSetJson) {
        return enumSetJson.stream().map(v -> (JsonString)v).map(s -> Modifier.valueOf((String)s.getString())).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class)));
    }

    private NodeList<?> deserializeNodeList(JsonArray nodeListJson) {
        return (NodeList)nodeListJson.stream().map(nodeJson -> this.deserializeObject((JsonObject)nodeJson)).collect(NodeList.toNodeList());
    }
}

