/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.serialization;

import com.github.javaparser.JavaParser;
import com.github.javaparser.JavaToken;
import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.metamodel.BaseNodeMetaModel;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.PropertyMetaModel;
import com.github.javaparser.serialization.JavaParserJsonSerializer;
import com.github.javaparser.utils.Log;
import java.util.HashMap;
import java.util.Optional;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class JavaParserJsonDeserializer {
    public Node deserializeObject(JsonReader reader) {
        Log.info((String)"Deserializing JSON to Node.", (Object[])new Object[0]);
        JsonObject jsonObject = reader.readObject();
        return this.deserializeObject(jsonObject);
    }

    private Node deserializeObject(JsonObject nodeJson) {
        try {
            String serializedNodeType = nodeJson.getString(JavaParserJsonSerializer.JsonNode.CLASS.propertyKey);
            BaseNodeMetaModel nodeMetaModel = (BaseNodeMetaModel)JavaParserMetaModel.getNodeMetaModel(Class.forName(serializedNodeType)).orElseThrow(() -> new IllegalStateException("Trying to deserialize an unknown node type: " + serializedNodeType));
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            HashMap<String, Object> deferredJsonValues = new HashMap<String, Object>();
            for (String name : nodeJson.keySet()) {
                if (name.equals(JavaParserJsonSerializer.JsonNode.CLASS.propertyKey)) continue;
                Optional<PropertyMetaModel> optionalPropertyMetaModel = nodeMetaModel.getAllPropertyMetaModels().stream().filter(mm -> mm.getName().equals(name)).findFirst();
                if (!optionalPropertyMetaModel.isPresent()) {
                    deferredJsonValues.put(name, nodeJson.get((Object)name));
                    continue;
                }
                PropertyMetaModel propertyMetaModel = optionalPropertyMetaModel.get();
                if (propertyMetaModel.isNodeList()) {
                    JsonArray nodeListJson = nodeJson.getJsonArray(name);
                    parameters.put(name, this.deserializeNodeList(nodeListJson));
                    continue;
                }
                if (propertyMetaModel.isNode()) {
                    parameters.put(name, this.deserializeObject(nodeJson.getJsonObject(name)));
                    continue;
                }
                Class type = propertyMetaModel.getType();
                if (type == String.class) {
                    parameters.put(name, nodeJson.getString(name));
                    continue;
                }
                if (type == Boolean.TYPE) {
                    parameters.put(name, Boolean.parseBoolean(nodeJson.getString(name)));
                    continue;
                }
                if (Enum.class.isAssignableFrom(type)) {
                    parameters.put(name, Enum.valueOf(type, nodeJson.getString(name)));
                    continue;
                }
                throw new IllegalStateException("Don't know how to convert: " + type);
            }
            Node node = nodeMetaModel.construct(parameters);
            if (parameters.containsKey(JavaParserJsonSerializer.JsonNode.COMMENT.propertyKey)) {
                node.setComment((Comment)parameters.get(JavaParserJsonSerializer.JsonNode.COMMENT.propertyKey));
            }
            for (String name : deferredJsonValues.keySet()) {
                if (this.readNonMetaProperties(name, (JsonValue)deferredJsonValues.get(name), node)) continue;
                throw new IllegalStateException("Unknown propertyKey: " + nodeMetaModel.getQualifiedClassName() + "." + name);
            }
            this.setSymbolResolverIfCompilationUnit(node);
            return node;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private NodeList<?> deserializeNodeList(JsonArray nodeListJson) {
        return (NodeList)nodeListJson.stream().map(nodeJson -> this.deserializeObject((JsonObject)nodeJson)).collect(NodeList.toNodeList());
    }

    protected boolean readNonMetaProperties(String name, JsonValue jsonValue, Node node) {
        return this.readRange(name, jsonValue, node) || this.readTokenRange(name, jsonValue, node);
    }

    protected boolean readRange(String name, JsonValue jsonValue, Node node) {
        if (name.equals(JavaParserJsonSerializer.JsonNode.RANGE.propertyKey)) {
            JsonObject jsonObject = (JsonObject)jsonValue;
            Position begin = new Position(jsonObject.getInt(JavaParserJsonSerializer.JsonRange.BEGIN_LINE.propertyKey), jsonObject.getInt(JavaParserJsonSerializer.JsonRange.BEGIN_COLUMN.propertyKey));
            Position end = new Position(jsonObject.getInt(JavaParserJsonSerializer.JsonRange.END_LINE.propertyKey), jsonObject.getInt(JavaParserJsonSerializer.JsonRange.END_COLUMN.propertyKey));
            node.setRange(new Range(begin, end));
            return true;
        }
        return false;
    }

    protected boolean readTokenRange(String name, JsonValue jsonValue, Node node) {
        if (name.equals(JavaParserJsonSerializer.JsonNode.TOKEN_RANGE.propertyKey)) {
            JsonObject jsonObject = (JsonObject)jsonValue;
            JavaToken begin = this.readToken(JavaParserJsonSerializer.JsonTokenRange.BEGIN_TOKEN.propertyKey, jsonObject);
            JavaToken end = this.readToken(JavaParserJsonSerializer.JsonTokenRange.END_TOKEN.propertyKey, jsonObject);
            node.setTokenRange(new TokenRange(begin, end));
            return true;
        }
        return false;
    }

    protected JavaToken readToken(String name, JsonObject jsonObject) {
        JsonObject tokenJson = jsonObject.getJsonObject(name);
        return new JavaToken(tokenJson.getInt(JavaParserJsonSerializer.JsonToken.KIND.propertyKey), tokenJson.getString(JavaParserJsonSerializer.JsonToken.TEXT.propertyKey));
    }

    private void setSymbolResolverIfCompilationUnit(Node node) {
        if (node instanceof CompilationUnit && JavaParser.getStaticConfiguration().getSymbolResolver().isPresent()) {
            CompilationUnit cu = (CompilationUnit)node;
            cu.setData(Node.SYMBOL_RESOLVER_KEY, JavaParser.getStaticConfiguration().getSymbolResolver().get());
        }
    }
}

