/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.SuperExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedClassDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedArrayType;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.resolution.types.ResolvedVoidType;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.javaparser.Navigator;
import com.github.javaparser.symbolsolver.javaparsermodel.DefaultVisitorAdapter;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFactory;
import com.github.javaparser.symbolsolver.javaparsermodel.UnsolvedSymbolException;
import com.github.javaparser.symbolsolver.javaparsermodel.declarations.JavaParserSymbolDeclaration;
import com.github.javaparser.symbolsolver.logic.FunctionalInterfaceLogic;
import com.github.javaparser.symbolsolver.logic.InferenceContext;
import com.github.javaparser.symbolsolver.logic.ObjectProvider;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.resolution.Value;
import com.github.javaparser.symbolsolver.model.typesystem.NullType;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.reflectionmodel.MyObjectProvider;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.resolution.SymbolSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TypeExtractor
extends DefaultVisitorAdapter {
    private static Logger logger = Logger.getLogger(TypeExtractor.class.getCanonicalName());
    private TypeSolver typeSolver;
    private JavaParserFacade facade;

    public TypeExtractor(TypeSolver typeSolver, JavaParserFacade facade) {
        this.typeSolver = typeSolver;
        this.facade = facade;
    }

    @Override
    public ResolvedType visit(VariableDeclarator node, Boolean solveLambdas) {
        if (Navigator.getParentNode((Node)node) instanceof FieldDeclaration) {
            return this.facade.convertToUsageVariableType(node);
        }
        if (Navigator.getParentNode((Node)node) instanceof VariableDeclarationExpr) {
            return this.facade.convertToUsageVariableType(node);
        }
        throw new UnsupportedOperationException(Navigator.getParentNode((Node)node).getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(Parameter node, Boolean solveLambdas) {
        if (node.getType() instanceof UnknownType) {
            throw new IllegalStateException("Parameter has unknown type: " + node);
        }
        return this.facade.convertToUsage(node.getType(), (Node)node);
    }

    @Override
    public ResolvedType visit(ArrayAccessExpr node, Boolean solveLambdas) {
        ResolvedType arrayUsageType = (ResolvedType)node.getName().accept((GenericVisitor)this, (Object)solveLambdas);
        if (arrayUsageType.isArray()) {
            return ((ResolvedArrayType)arrayUsageType).getComponentType();
        }
        return arrayUsageType;
    }

    @Override
    public ResolvedType visit(ArrayCreationExpr node, Boolean solveLambdas) {
        ResolvedType res = this.facade.convertToUsage(node.getElementType(), JavaParserFactory.getContext((Node)node, this.typeSolver));
        for (int i = 0; i < node.getLevels().size(); ++i) {
            res = new ResolvedArrayType(res);
        }
        return res;
    }

    @Override
    public ResolvedType visit(ArrayInitializerExpr node, Boolean solveLambdas) {
        throw new UnsupportedOperationException(node.getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(AssignExpr node, Boolean solveLambdas) {
        return (ResolvedType)node.getTarget().accept((GenericVisitor)this, (Object)solveLambdas);
    }

    @Override
    public ResolvedType visit(BinaryExpr node, Boolean solveLambdas) {
        switch (node.getOperator()) {
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case MULTIPLY: {
                return this.facade.getBinaryTypeConcrete((Node)node.getLeft(), (Node)node.getRight(), solveLambdas);
            }
            case LESS_EQUALS: 
            case LESS: 
            case GREATER: 
            case GREATER_EQUALS: 
            case EQUALS: 
            case NOT_EQUALS: 
            case OR: 
            case AND: {
                return ResolvedPrimitiveType.BOOLEAN;
            }
            case BINARY_AND: 
            case BINARY_OR: 
            case SIGNED_RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case LEFT_SHIFT: 
            case REMAINDER: 
            case XOR: {
                return (ResolvedType)node.getLeft().accept((GenericVisitor)this, (Object)solveLambdas);
            }
        }
        throw new UnsupportedOperationException("Operator " + node.getOperator().name());
    }

    @Override
    public ResolvedType visit(CastExpr node, Boolean solveLambdas) {
        return this.facade.convertToUsage(node.getType(), JavaParserFactory.getContext((Node)node, this.typeSolver));
    }

    @Override
    public ResolvedType visit(ClassExpr node, Boolean solveLambdas) {
        Type astType = node.getType();
        ResolvedType jssType = this.facade.convertToUsage(astType, (Node)node.getType());
        return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)new ReflectionClassDeclaration(Class.class, this.typeSolver), (List<ResolvedType>)ImmutableList.of((Object)jssType), this.typeSolver);
    }

    @Override
    public ResolvedType visit(ConditionalExpr node, Boolean solveLambdas) {
        return (ResolvedType)node.getThenExpr().accept((GenericVisitor)this, (Object)solveLambdas);
    }

    @Override
    public ResolvedType visit(EnclosedExpr node, Boolean solveLambdas) {
        return (ResolvedType)node.getInner().accept((GenericVisitor)this, (Object)solveLambdas);
    }

    private ResolvedType solveDotExpressionType(ResolvedReferenceTypeDeclaration parentType, FieldAccessExpr node) {
        if (parentType.hasField(node.getName().getId())) {
            return parentType.getField(node.getName().getId()).getType();
        }
        if (parentType.hasInternalType(node.getName().getId())) {
            return new ReferenceTypeImpl(parentType.getInternalType(node.getName().getId()), this.typeSolver);
        }
        throw new UnsolvedSymbolException(node.getName().getId());
    }

    @Override
    public ResolvedType visit(FieldAccessExpr node, Boolean solveLambdas) {
        Optional<Value> value;
        block10: {
            SymbolReference sr;
            if (node.getScope() instanceof NameExpr || node.getScope() instanceof FieldAccessExpr) {
                Expression staticValue = node.getScope();
                SymbolReference<ResolvedTypeDeclaration> typeAccessedStatically = JavaParserFactory.getContext((Node)node, this.typeSolver).solveType(staticValue.toString(), this.typeSolver);
                if (typeAccessedStatically.isSolved()) {
                    return this.solveDotExpressionType(((ResolvedTypeDeclaration)typeAccessedStatically.getCorrespondingDeclaration()).asReferenceType(), node);
                }
            } else if (node.getScope() instanceof ThisExpr) {
                ResolvedTypeDeclaration correspondingDeclaration;
                SymbolReference<ResolvedTypeDeclaration> solve = this.facade.solve((ThisExpr)node.getScope());
                if (solve.isSolved() && (correspondingDeclaration = (ResolvedTypeDeclaration)solve.getCorrespondingDeclaration()) instanceof ResolvedReferenceTypeDeclaration) {
                    return this.solveDotExpressionType(correspondingDeclaration.asReferenceType(), node);
                }
            } else if (node.getScope().toString().indexOf(46) > 0 && (sr = this.typeSolver.tryToSolveType(node.getScope().toString())).isSolved()) {
                return this.solveDotExpressionType((ResolvedReferenceTypeDeclaration)sr.getCorrespondingDeclaration(), node);
            }
            value = null;
            try {
                value = new SymbolSolver(this.typeSolver).solveSymbolAsValue(node.getField().getId(), (Node)node);
            }
            catch (UnsolvedSymbolException use) {
                SymbolReference sref = this.typeSolver.tryToSolveType(node.toString());
                if (!sref.isSolved()) break block10;
                return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)sref.getCorrespondingDeclaration(), this.typeSolver);
            }
        }
        if (value != null && value.isPresent()) {
            return value.get().getType();
        }
        throw new UnsolvedSymbolException(node.getField().getId());
    }

    @Override
    public ResolvedType visit(InstanceOfExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.BOOLEAN;
    }

    @Override
    public ResolvedType visit(StringLiteralExpr node, Boolean solveLambdas) {
        return new ReferenceTypeImpl(new ReflectionTypeSolver().solveType(String.class.getCanonicalName()), this.typeSolver);
    }

    @Override
    public ResolvedType visit(IntegerLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.INT;
    }

    @Override
    public ResolvedType visit(LongLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.LONG;
    }

    @Override
    public ResolvedType visit(CharLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.CHAR;
    }

    @Override
    public ResolvedType visit(DoubleLiteralExpr node, Boolean solveLambdas) {
        if (node.getValue().toLowerCase().endsWith("f")) {
            return ResolvedPrimitiveType.FLOAT;
        }
        return ResolvedPrimitiveType.DOUBLE;
    }

    @Override
    public ResolvedType visit(BooleanLiteralExpr node, Boolean solveLambdas) {
        return ResolvedPrimitiveType.BOOLEAN;
    }

    @Override
    public ResolvedType visit(NullLiteralExpr node, Boolean solveLambdas) {
        return NullType.INSTANCE;
    }

    @Override
    public ResolvedType visit(MethodCallExpr node, Boolean solveLambdas) {
        logger.finest("getType on method call " + node);
        MethodUsage ref = this.facade.solveMethodAsUsage(node);
        logger.finest("getType on method call " + node + " resolved to " + ref);
        logger.finest("getType on method call " + node + " return type is " + ref.returnType());
        return ref.returnType();
    }

    @Override
    public ResolvedType visit(NameExpr node, Boolean solveLambdas) {
        logger.finest("getType on name expr " + node);
        Optional<Value> value = new SymbolSolver(this.typeSolver).solveSymbolAsValue(node.getName().getId(), (Node)node);
        if (!value.isPresent()) {
            throw new UnsolvedSymbolException("Solving " + node, node.getName().getId());
        }
        return value.get().getType();
    }

    @Override
    public ResolvedType visit(ObjectCreationExpr node, Boolean solveLambdas) {
        ResolvedType type = this.facade.convertToUsage((Type)node.getType(), (Node)node);
        return type;
    }

    @Override
    public ResolvedType visit(ThisExpr node, Boolean solveLambdas) {
        if (node.getClassExpr().isPresent()) {
            Optional classByName;
            String className = ((Expression)node.getClassExpr().get()).toString();
            SymbolReference clazz = this.typeSolver.tryToSolveType(className);
            if (clazz.isSolved()) {
                return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)clazz.getCorrespondingDeclaration(), this.typeSolver);
            }
            Optional cu = node.getAncestorOfType(CompilationUnit.class);
            if (cu.isPresent() && (classByName = ((CompilationUnit)cu.get()).getClassByName(className)).isPresent()) {
                return new ReferenceTypeImpl(this.facade.getTypeDeclaration((ClassOrInterfaceDeclaration)classByName.get()), this.typeSolver);
            }
        }
        return new ReferenceTypeImpl(this.facade.getTypeDeclaration(this.facade.findContainingTypeDeclOrObjectCreationExpr((Node)node)), this.typeSolver);
    }

    @Override
    public ResolvedType visit(SuperExpr node, Boolean solveLambdas) {
        ResolvedReferenceTypeDeclaration typeOfNode = this.facade.getTypeDeclaration(this.facade.findContainingTypeDecl((Node)node));
        if (typeOfNode instanceof ResolvedClassDeclaration) {
            return ((ResolvedClassDeclaration)typeOfNode).getSuperClass();
        }
        throw new UnsupportedOperationException(node.getClass().getCanonicalName());
    }

    @Override
    public ResolvedType visit(UnaryExpr node, Boolean solveLambdas) {
        switch (node.getOperator()) {
            case MINUS: 
            case PLUS: {
                return (ResolvedType)node.getExpression().accept((GenericVisitor)this, (Object)solveLambdas);
            }
            case LOGICAL_COMPLEMENT: {
                return ResolvedPrimitiveType.BOOLEAN;
            }
            case POSTFIX_DECREMENT: 
            case PREFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_INCREMENT: {
                return (ResolvedType)node.getExpression().accept((GenericVisitor)this, (Object)solveLambdas);
            }
        }
        throw new UnsupportedOperationException(node.getOperator().name());
    }

    @Override
    public ResolvedType visit(VariableDeclarationExpr node, Boolean solveLambdas) {
        if (node.getVariables().size() != 1) {
            throw new UnsupportedOperationException();
        }
        return this.facade.convertToUsageVariableType((VariableDeclarator)node.getVariables().get(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResolvedType visit(LambdaExpr node, Boolean solveLambdas) {
        ResolvedType actualType;
        if (!(Navigator.getParentNode((Node)node) instanceof MethodCallExpr)) throw new UnsupportedOperationException("The type of a lambda expr depends on the position and its return value");
        MethodCallExpr callExpr = (MethodCallExpr)Navigator.getParentNode((Node)node);
        int pos = JavaParserSymbolDeclaration.getParamPos((Node)node);
        SymbolReference<ResolvedMethodDeclaration> refMethod = this.facade.solve(callExpr);
        if (!refMethod.isSolved()) {
            throw new UnsolvedSymbolException(Navigator.getParentNode((Node)node).toString(), callExpr.getName().getId());
        }
        logger.finest("getType on lambda expr " + ((ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration()).getName());
        if (solveLambdas == false) return ((ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration()).getParam(pos).getType();
        ResolvedType result = ((ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration()).getParam(pos).getType();
        if (callExpr.getScope().isPresent()) {
            ResolvedType scopeType;
            Expression scope = (Expression)callExpr.getScope().get();
            boolean staticCall = false;
            if (scope instanceof NameExpr) {
                NameExpr nameExpr = (NameExpr)scope;
                try {
                    SymbolReference<ResolvedTypeDeclaration> type = JavaParserFactory.getContext((Node)nameExpr, this.typeSolver).solveType(nameExpr.getName().getId(), this.typeSolver);
                    if (type.isSolved()) {
                        staticCall = true;
                    }
                }
                catch (Exception type) {
                    // empty catch block
                }
            }
            if (!staticCall && (scopeType = this.facade.getType((Node)scope)).isReferenceType()) {
                result = scopeType.asReferenceType().useThisTypeParametersOnTheGivenType(result);
            }
        }
        Context ctx = JavaParserFactory.getContext((Node)node, this.typeSolver);
        Optional functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod((ResolvedType)(result = JavaParserFacade.solveGenericTypes(result, ctx, this.typeSolver)));
        if (!functionalMethod.isPresent()) return result;
        LambdaExpr lambdaExpr = node;
        InferenceContext lambdaCtx = new InferenceContext((ObjectProvider)MyObjectProvider.INSTANCE);
        InferenceContext funcInterfaceCtx = new InferenceContext((ObjectProvider)MyObjectProvider.INSTANCE);
        ResolvedReferenceType functionalInterfaceType = ReferenceTypeImpl.undeterminedParameters(((MethodUsage)functionalMethod.get()).getDeclaration().declaringType(), this.typeSolver);
        lambdaCtx.addPair(result, (ResolvedType)functionalInterfaceType);
        if (lambdaExpr.getBody() instanceof ExpressionStmt) {
            actualType = this.facade.getType((Node)((ExpressionStmt)lambdaExpr.getBody()).getExpression());
        } else {
            if (!(lambdaExpr.getBody() instanceof BlockStmt)) throw new UnsupportedOperationException();
            BlockStmt blockStmt = (BlockStmt)lambdaExpr.getBody();
            NodeList statements = blockStmt.getStatements();
            List returnStmts = blockStmt.getNodesByType(ReturnStmt.class);
            if (returnStmts.size() <= 0) return ResolvedVoidType.INSTANCE;
            actualType = returnStmts.stream().map(returnStmt -> {
                Optional expression = returnStmt.getExpression();
                if (expression.isPresent()) {
                    return this.facade.getType((Node)expression.get());
                }
                return ResolvedVoidType.INSTANCE;
            }).filter(x -> x != null && !x.isVoid() && !x.isNull()).findFirst().orElse(ResolvedVoidType.INSTANCE);
        }
        ResolvedType formalType = ((MethodUsage)functionalMethod.get()).returnType();
        funcInterfaceCtx.addPair(formalType, actualType);
        ResolvedType functionalTypeWithReturn = funcInterfaceCtx.resolve(funcInterfaceCtx.addSingle((ResolvedType)functionalInterfaceType));
        if (formalType instanceof ResolvedVoidType) return result;
        lambdaCtx.addPair(result, functionalTypeWithReturn);
        return lambdaCtx.resolve(lambdaCtx.addSingle(result));
    }

    @Override
    public ResolvedType visit(MethodReferenceExpr node, Boolean solveLambdas) {
        if (Navigator.getParentNode((Node)node) instanceof MethodCallExpr) {
            MethodCallExpr callExpr = (MethodCallExpr)Navigator.getParentNode((Node)node);
            int pos = JavaParserSymbolDeclaration.getParamPos((Node)node);
            SymbolReference<ResolvedMethodDeclaration> refMethod = this.facade.solve(callExpr, false);
            if (!refMethod.isSolved()) {
                throw new UnsolvedSymbolException(Navigator.getParentNode((Node)node).toString(), callExpr.getName().getId());
            }
            logger.finest("getType on method reference expr " + ((ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration()).getName());
            if (solveLambdas.booleanValue()) {
                MethodUsage usage = this.facade.solveMethodAsUsage(callExpr);
                ResolvedType result = usage.getParamType(pos);
                Context ctx = JavaParserFactory.getContext((Node)node, this.typeSolver);
                Optional functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod((ResolvedType)(result = JavaParserFacade.solveGenericTypes(result, ctx, this.typeSolver)));
                if (functionalMethod.isPresent() && node instanceof MethodReferenceExpr) {
                    MethodReferenceExpr methodReferenceExpr = node;
                    ResolvedType actualType = this.facade.toMethodUsage(methodReferenceExpr).returnType();
                    ResolvedType formalType = ((MethodUsage)functionalMethod.get()).returnType();
                    InferenceContext inferenceContext = new InferenceContext((ObjectProvider)MyObjectProvider.INSTANCE);
                    inferenceContext.addPair(formalType, actualType);
                    result = inferenceContext.resolve(inferenceContext.addSingle(result));
                }
                return result;
            }
            return ((ResolvedMethodDeclaration)refMethod.getCorrespondingDeclaration()).getParam(pos).getType();
        }
        throw new UnsupportedOperationException("The type of a method reference expr depends on the position and its return value");
    }

    @Override
    public ResolvedType visit(FieldDeclaration node, Boolean solveLambdas) {
        if (node.getVariables().size() == 1) {
            return (ResolvedType)((VariableDeclarator)node.getVariables().get(0)).accept((GenericVisitor)this, (Object)solveLambdas);
        }
        throw new IllegalArgumentException("Cannot resolve the type of a field with multiple variable declarations. Pick one");
    }

    static {
        logger.setLevel(Level.INFO);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.INFO);
        logger.addHandler(consoleHandler);
    }
}

