/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit.ext;

import ando.toolkit.AppUtils;
import ando.toolkit.ext.DeviceExtKt;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0013\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u0004\u0018\u00010\bJ\b\u0010\u0011\u001a\u0004\u0018\u00010\bJ\b\u0010\u0012\u001a\u0004\u0018\u00010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\u0004\u00a8\u0006\u0017"}, d2={"Lando/toolkit/ext/DeviceUtils;", "", "()V", "checkDeviceHasNavigationBar", "", "context", "Landroid/content/Context;", "getAppName", "", "getCpuABIS", "", "()[Ljava/lang/String;", "getDeviceBrand", "getNavBarHeight", "", "getStatusBarHeight", "getSystemDevice", "getSystemModel", "getSystemVersion", "getVersionCode", "", "getVersionName", "isNavigationBarExist", "ando_toolkit_release"})
public final class DeviceUtils {
    @NotNull
    public static final DeviceUtils INSTANCE;

    @NotNull
    public final String getAppName() {
        return DeviceExtKt.getAppName(AppUtils.INSTANCE.getContext());
    }

    public final long getVersionCode() {
        return DeviceExtKt.getVersionCode(AppUtils.INSTANCE.getContext());
    }

    @NotNull
    public final String getVersionName() {
        return DeviceExtKt.getVersionName(AppUtils.INSTANCE.getContext());
    }

    @Nullable
    public final String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    @Nullable
    public final String getSystemModel() {
        return Build.MODEL;
    }

    @Nullable
    public final String getDeviceBrand() {
        return Build.BRAND;
    }

    @Nullable
    public final String getSystemDevice() {
        return Build.DEVICE;
    }

    @Nullable
    public final String[] getCpuABIS() {
        return Build.SUPPORTED_ABIS;
    }

    public final int getNavBarHeight() {
        Resources res = Resources.getSystem();
        int resourceId = res.getIdentifier("navigation_bar_height", "dimen", "android");
        return resourceId != 0 ? res.getDimensionPixelSize(resourceId) : 0;
    }

    public final int getStatusBarHeight() {
        Resources res = Resources.getSystem();
        int resourceId = res.getIdentifier("status_bar_height", "dimen", "android");
        return resourceId > 0 ? res.getDimensionPixelSize(resourceId) : 0;
    }

    public final boolean isNavigationBarExist() {
        return this.getNavBarHeight() > 0;
    }

    public final boolean checkDeviceHasNavigationBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean hasNavigationBar = false;
        Resources rs = context.getResources();
        int id2 = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id2 > 0) {
            hasNavigationBar = rs.getBoolean(id2);
        }
        try {
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Method m = systemPropertiesClass.getMethod("get", String.class);
            Object object = m.invoke(systemPropertiesClass, "qemu.hw.mainkeys");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String navBarOverride = (String)object;
            if (Intrinsics.areEqual((Object)"1", (Object)navBarOverride)) {
                hasNavigationBar = false;
            } else if (Intrinsics.areEqual((Object)"0", (Object)navBarOverride)) {
                hasNavigationBar = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasNavigationBar;
    }

    private DeviceUtils() {
    }

    static {
        DeviceUtils deviceUtils;
        INSTANCE = deviceUtils = new DeviceUtils();
    }
}

