/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import ando.toolkit.AppUtils;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import androidx.annotation.AnimRes;
import androidx.annotation.ArrayRes;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.annotation.StyleableRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u00020\b2\b\b\u0001\u0010\u000e\u001a\u00020\bJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0001\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u00020\u000b2\b\b\u0001\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u0013\u001a\u00020\b2\b\b\u0001\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u00020\b2\b\b\u0001\u0010\u000e\u001a\u00020\bJ\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u000e\u001a\u00020\bJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0001\u0010\u000e\u001a\u00020\bJ\u001d\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u001a2\b\b\u0001\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001bJ\"\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020\bJ\u0010\u0010 \u001a\u00020!2\b\b\u0001\u0010\u000e\u001a\u00020\bJ\u0010\u0010\"\u001a\u00020#2\b\b\u0001\u0010\u000e\u001a\u00020\bJ\u001b\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u001a2\b\b\u0001\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0002\u0010%J\u001a\u0010&\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u000e\u001a\u00020\bJ\b\u0010'\u001a\u00020(H\u0007J\u0016\u0010)\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006*"}, d2={"Lando/toolkit/ResUtils;", "", "()V", "resources", "Landroid/content/res/Resources;", "getResources", "()Landroid/content/res/Resources;", "darker", "", "color", "factor", "", "getAnim", "Landroid/view/animation/Animation;", "resId", "getColor", "getColors", "Landroid/content/res/ColorStateList;", "getDimens", "getDimensionPixelOffset", "getDimensionPixelSize", "getDrawable", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "getDrawableArray", "", "(I)[Landroid/graphics/drawable/Drawable;", "getDrawableAttrRes", "typedArray", "Landroid/content/res/TypedArray;", "index", "getIntArray", "", "getString", "", "getStringArray", "(I)[Ljava/lang/String;", "getVectorDrawable", "isRtl", "", "lighter", "ando_toolkit_release"})
public final class ResUtils {
    @NotNull
    public static final ResUtils INSTANCE;

    private final Resources getResources() {
        Resources resources = AppUtils.INSTANCE.getContext().getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"getContext().resources");
        return resources;
    }

    @NotNull
    public final String getString(@StringRes int resId) {
        String string = this.getResources().getString(resId);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resources.getString(resId)");
        return string;
    }

    @Nullable
    public final Drawable getDrawable(@DrawableRes int resId) {
        return ContextCompat.getDrawable((Context)AppUtils.INSTANCE.getContext(), (int)resId);
    }

    @Nullable
    public final Drawable getDrawable(@NotNull Context context, @DrawableRes int resId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return ContextCompat.getDrawable((Context)context, (int)resId);
    }

    @Nullable
    public final Drawable getVectorDrawable(@NotNull Context context, @DrawableRes int resId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Build.VERSION.SDK_INT >= 21 ? ContextCompat.getDrawable((Context)context, (int)resId) : AppCompatResources.getDrawable((Context)context, (int)resId);
    }

    @Nullable
    public final Drawable getDrawableAttrRes(@NotNull Context context, @NotNull TypedArray typedArray, @StyleableRes int index) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)typedArray, (String)"typedArray");
        if (Build.VERSION.SDK_INT >= 21) {
            return typedArray.getDrawable(index);
        }
        int resourceId = typedArray.getResourceId(index, -1);
        if (resourceId != -1) {
            return AppCompatResources.getDrawable((Context)context, (int)resourceId);
        }
        return null;
    }

    public final float getDimens(@DimenRes int resId) {
        return this.getResources().getDimension(resId);
    }

    public final int getDimensionPixelOffset(@DimenRes int resId) {
        return this.getResources().getDimensionPixelOffset(resId);
    }

    public final int getDimensionPixelSize(@DimenRes int resId) {
        return this.getResources().getDimensionPixelSize(resId);
    }

    public final int getColor(@ColorRes int resId) {
        return ContextCompat.getColor((Context)AppUtils.INSTANCE.getContext(), (int)resId);
    }

    @Nullable
    public final ColorStateList getColors(@ColorRes int resId) {
        return ContextCompat.getColorStateList((Context)AppUtils.INSTANCE.getContext(), (int)resId);
    }

    @NotNull
    public final String[] getStringArray(@ArrayRes int resId) {
        String[] stringArray = this.getResources().getStringArray(resId);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"resources.getStringArray(resId)");
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Drawable[] getDrawableArray(@ArrayRes int resId) {
        TypedArray typedArray = AppUtils.INSTANCE.getContext().getResources().obtainTypedArray(resId);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"getContext().resources.obtainTypedArray(resId)");
        TypedArray ta = typedArray;
        Drawable[] icons = new Drawable[ta.length()];
        int n = 0;
        int n2 = ta.length();
        while (n < n2) {
            void i;
            int id2 = ta.getResourceId((int)i, 0);
            if (id2 != 0) {
                icons[i] = ContextCompat.getDrawable((Context)AppUtils.INSTANCE.getContext(), (int)id2);
            }
            ++i;
        }
        ta.recycle();
        return icons;
    }

    @NotNull
    public final int[] getIntArray(@ArrayRes int resId) {
        int[] nArray = this.getResources().getIntArray(resId);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"resources.getIntArray(resId)");
        return nArray;
    }

    @NotNull
    public final Animation getAnim(@AnimRes int resId) {
        Animation animation = AnimationUtils.loadAnimation((Context)AppUtils.INSTANCE.getContext(), (int)resId);
        Intrinsics.checkNotNullExpressionValue((Object)animation, (String)"AnimationUtils.loadAnimation(getContext(), resId)");
        return animation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"ObsoleteSdkInt"})
    public final boolean isRtl() {
        if (Build.VERSION.SDK_INT < 17) return false;
        Configuration configuration = this.getResources().getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"resources.configuration");
        if (configuration.getLayoutDirection() != 1) return false;
        return true;
    }

    public final int darker(int color, float factor) {
        int n = (int)((float)Color.red((int)color) * factor);
        int n2 = 0;
        boolean bl = false;
        int n3 = Math.max(n, n2);
        n = (int)((float)Color.green((int)color) * factor);
        n2 = 0;
        bl = false;
        int n4 = Math.max(n, n2);
        n = (int)((float)Color.blue((int)color) * factor);
        n2 = 0;
        bl = false;
        return Color.argb((int)Color.alpha((int)color), (int)n3, (int)n4, (int)Math.max(n, n2));
    }

    public final int lighter(int color, float factor) {
        int red = (int)(((float)Color.red((int)color) * (1.0f - factor) / (float)255 + factor) * (float)255);
        int green = (int)(((float)Color.green((int)color) * (1.0f - factor) / (float)255 + factor) * (float)255);
        int blue = (int)(((float)Color.blue((int)color) * (1.0f - factor) / (float)255 + factor) * (float)255);
        return Color.argb((int)Color.alpha((int)color), (int)red, (int)green, (int)blue);
    }

    private ResUtils() {
    }

    static {
        ResUtils resUtils;
        INSTANCE = resUtils = new ResUtils();
    }
}

