/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010$\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010&\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010'\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010(\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010)\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010*\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010+\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010,\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006-"}, d2={"Lando/toolkit/ValidateUtils;", "", "()V", "isChineseString", "", "inputString", "", "isDoubleByteString", "isEmail", "isEnglishAlphabetString", "isFloat", "isHtmlString", "isIdCard", "isInteger", "isIntegerBlowZero", "isIntegerUpZero", "isLowerEnglishAlphabetString", "isMobilePhone", "mobile", "isNegativeFloat", "isNegativeInteger", "isNotNegativeFloat", "isNotNegativeInteger", "isNotPositiveFloat", "isNotPositiveInteger", "isNumber", "isNumberEnglishAlphabetString", "isNumberEnglishAlphabetWithUnderlineString", "isNumberFormatLength", "length", "", "isNumberInPositiveWhichHasOneToThreeLengthAfterPoint", "isNumberInPositiveWhichHasTwolengthAfterPoint", "isNumberLengthBetweenLowerAndUpper", "lower", "upper", "isNumberLengthLess", "isNumberStartWithZeroOrNot", "isPassword", "isPositiveFloat", "isPositiveInteger", "isTelephone", "isTrimStartAndEndInthisString", "isUppercaseEnglishAlphabetString", "isUrl", "ando_toolkit_release"})
public final class ValidateUtils {
    @NotNull
    public static final ValidateUtils INSTANCE;

    public final boolean isDoubleByteString(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("[^x00-xff]");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isHtmlString(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("/< (.*)>.*|< (.*) />/");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isTrimStartAndEndInthisString(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("[\\s*)]+\\w+[\\s*$]");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isEmail(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^([a-z0-9A-Z]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isUrl(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^http://[a-zA-Z0-9./\\s]");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isPassword(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^[a-zA-Z]\\w{5,17}$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isIdCard(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^\\d{15}(\\d{2}[0-9xX])?$");
        Matcher matcher = pattern.matcher(inputString);
        if (matcher.find()) {
            String string = inputString;
            int n = inputString.length() - 12;
            int n2 = inputString.length() - 4;
            boolean bl = false;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String power = string2;
            pattern = Pattern.compile("^[1-2]+([0-9]{3})+(0[1-9][0-2][0-9]|0[1-9]3[0-1]|1[0-2][0-3][0-1]|1[0-2][0-2][0-9])");
            matcher = pattern.matcher(power);
        }
        return matcher.find();
    }

    public final boolean isTelephone(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^(([0-9]{3,4})|([0-9]{3,4})-)?[0-9]{7,8}$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isMobilePhone(@NotNull String mobile) {
        Intrinsics.checkNotNullParameter((Object)mobile, (String)"mobile");
        return Pattern.matches("^[1][3-9][0-9]{9}$", mobile);
    }

    public final boolean isChineseString(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^[\u4e00-\u9fa5]*$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isPositiveInteger(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^[1-9]d*$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNegativeInteger(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^-[1-9]d*$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isInteger(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^-?[1-9]d*$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNotNegativeInteger(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^[1-9]d*|0$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNotPositiveInteger(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^-[1-9]d*|0$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isPositiveFloat(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^[1-9]d*.d*|0.d*[1-9]d*$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNegativeFloat(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^-([1-9]d*.d*|0.d*[1-9]d*)$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isFloat(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^-?([1-9]d*.d*|0.d*[1-9]d*|0?.0+|0)$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNotNegativeFloat(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^[1-9]d*.d*|0.d*[1-9]d*|0?.0+|0$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNotPositiveFloat(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^(-([1-9]d*.d*|0.d*[1-9]d*))|0?.0+|0$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNumber(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^[0-9]*$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNumberFormatLength(int length, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^d{" + length + "}$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNumberLengthLess(int length, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^d{" + length + ",}$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNumberLengthBetweenLowerAndUpper(int lower, int upper, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^d{" + lower + ',' + upper + "}$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNumberStartWithZeroOrNot(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^(0|[1-9][0-9]*)$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNumberInPositiveWhichHasTwolengthAfterPoint(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^[0-9]+(.[0-9]{2})?$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNumberInPositiveWhichHasOneToThreeLengthAfterPoint(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^[0-9]+(.[0-9]{1,3})?$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isIntegerUpZero(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^+?[1-9][0-9]*$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isIntegerBlowZero(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^-[1-9][0-9]*$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isEnglishAlphabetString(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^[A-Za-z]+$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isUppercaseEnglishAlphabetString(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^[A-Z]+$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isLowerEnglishAlphabetString(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^[a-z]+$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNumberEnglishAlphabetString(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^[A-Za-z0-9]+$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    public final boolean isNumberEnglishAlphabetWithUnderlineString(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        Pattern pattern = Pattern.compile("^w+$");
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }

    private ValidateUtils() {
    }

    static {
        ValidateUtils validateUtils;
        INSTANCE = validateUtils = new ValidateUtils();
    }
}

