/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import ando.toolkit.AppUtils;
import ando.toolkit.ShellUtils;
import ando.toolkit.log.L;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Formatter;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001<B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\"\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\bJ\u0010\u0010$\u001a\u0004\u0018\u00010\b2\u0006\u0010%\u001a\u00020\u0010J\u0010\u0010&\u001a\u0004\u0018\u00010\b2\u0006\u0010%\u001a\u00020\u0010J\u0012\u0010'\u001a\u0004\u0018\u00010\b2\b\u0010(\u001a\u0004\u0018\u00010)J\b\u0010*\u001a\u0004\u0018\u00010\bJ\u0014\u0010+\u001a\u0004\u0018\u00010\b2\b\u0010(\u001a\u0004\u0018\u00010)H\u0007J\u0006\u0010,\u001a\u00020\bJ\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020)H\u0007J\u000e\u00101\u001a\u00020\b2\u0006\u0010(\u001a\u00020)J\u0010\u00102\u001a\u00020\b2\u0006\u00103\u001a\u000200H\u0002J\u0006\u00104\u001a\u00020\u0010J\b\u00105\u001a\u00020\u0010H\u0007J\u0010\u0010\u0012\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u00106\u001a\u00020\bJ\u000e\u00107\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)J\u0006\u00108\u001a\u00020\u0010J\u0006\u00109\u001a\u00020\bJ\u000e\u0010:\u001a\u00020;2\u0006\u0010(\u001a\u00020)R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u00108CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u0017\u001a\u00020\u00108G\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\u00108G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\u0019\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\nR\u0011\u0010\u001b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\nR$\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00108G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u0011\"\u0004\b \u0010!\u00a8\u0006="}, d2={"Lando/toolkit/NetworkUtils;", "", "()V", "activeNetworkInfo", "Landroid/net/NetworkInfo;", "getActiveNetworkInfo", "()Landroid/net/NetworkInfo;", "broadcastIpAddress", "", "getBroadcastIpAddress", "()Ljava/lang/String;", "gatewayByWifi", "getGatewayByWifi", "ipAddressByWifi", "getIpAddressByWifi", "isAvailable", "", "()Z", "isAvailableByDns", "isAvailableByPing", "isConnected", "isEthernet", "isMobile", "isMobileEnabled", "isWifiConnected", "netMaskByWifi", "getNetMaskByWifi", "serverAddressByWifi", "getServerAddressByWifi", "enabled", "wifiEnabled", "getWifiEnabled", "setWifiEnabled", "(Z)V", "getDomainAddress", "domain", "getIPAddress", "useIPv4", "getIPAddress2", "getMac", "context", "Landroid/content/Context;", "getMacAddress", "getMacDefault", "getMacFromHardware", "getNetworkType", "Lando/toolkit/NetworkUtils$NetworkType;", "getWifiRSSI", "", "getWifiSSID", "intToIp", "ipAddress", "is4G", "is5G", "ip", "isWifi", "isWifiAvailable", "networkOperatorName", "openWirelessSettings", "", "NetworkType", "ando_toolkit_release"})
public final class NetworkUtils {
    @NotNull
    public static final NetworkUtils INSTANCE;

    public final void openWirelessSettings(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.startActivity(new Intent("android.settings.WIRELESS_SETTINGS").setFlags(0x10000000));
    }

    public final boolean isConnected() {
        NetworkInfo info = this.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    public final boolean isAvailable() {
        return this.isAvailableByDns() || this.isAvailableByPing("");
    }

    public final boolean isAvailableByPing() {
        return this.isAvailableByPing("");
    }

    public final boolean isAvailableByPing(@NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        String realIp = TextUtils.isEmpty((CharSequence)ip) ? "223.5.5.5" : ip;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "ping -c 1 %s";
        Object[] objectArray = new Object[]{realIp};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        ShellUtils.CommandResult result = ShellUtils.INSTANCE.execCmd(string2, false);
        return result.getResult() == 0;
    }

    public final boolean isAvailableByDns() {
        return this.isAvailableByDns("");
    }

    public final boolean isAvailableByDns(@Nullable String domain) {
        CharSequence charSequence = domain;
        boolean bl = false;
        boolean bl2 = false;
        String realDomain = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "www.baidu.com" : domain;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(realDomain);
            return inetAddress != null;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public final boolean isMobileEnabled() {
        try {
            Object object = AppUtils.INSTANCE.getContext().getSystemService("phone");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
            }
            TelephonyManager tm = (TelephonyManager)object;
            if (Build.VERSION.SDK_INT >= 26) {
                return tm.isDataEnabled();
            }
            Method getMobileDataEnabledMethod = tm.getClass().getDeclaredMethod("getDataEnabled", new Class[0]);
            Object object2 = getMobileDataEnabledMethod.invoke((Object)tm, new Object[0]);
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            return (Boolean)object2;
        }
        catch (Exception e) {
            Log.e((String)"NetworkUtils", (String)"getMobileDataEnabled: ", (Throwable)e);
            return false;
        }
    }

    public final boolean isMobile() {
        NetworkInfo info = this.getActiveNetworkInfo();
        return info != null && info.isAvailable() && info.getType() == 0;
    }

    public final boolean is4G() {
        NetworkInfo info = this.getActiveNetworkInfo();
        return info != null && info.isAvailable() && info.getSubtype() == 13;
    }

    @RequiresApi(api=29)
    public final boolean is5G() {
        NetworkInfo info = this.getActiveNetworkInfo();
        return info != null && info.isAvailable() && info.getSubtype() == 20;
    }

    @RequiresPermission(allOf={"android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE"})
    public final boolean getWifiEnabled() {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager manager = (WifiManager)object;
        return manager.isWifiEnabled();
    }

    public final void setWifiEnabled(boolean enabled) {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager manager = (WifiManager)object;
        if (enabled == manager.isWifiEnabled()) {
            return;
        }
        manager.setWifiEnabled(enabled);
    }

    @SuppressLint(value={"MissingPermission"})
    public final boolean isWifiConnected() {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager cm2 = (ConnectivityManager)object;
        NetworkInfo ni = cm2.getActiveNetworkInfo();
        return ni != null && ni.getType() == 1;
    }

    public final boolean isWifiAvailable() {
        return this.getWifiEnabled() && this.isAvailable();
    }

    @NotNull
    public final String networkOperatorName() {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("phone");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.telephony.TelephonyManager");
        }
        String string = ((TelephonyManager)object).getNetworkOperatorName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(getContext().getSystemS\u2026ager).networkOperatorName");
        return string;
    }

    @NotNull
    public final NetworkType getNetworkType() {
        NetworkType networkType;
        if (this.isEthernet()) {
            return NetworkType.NETWORK_ETHERNET;
        }
        Object object = AppUtils.INSTANCE.getContext().getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager cm2 = (ConnectivityManager)object;
        NetworkInfo networkInfo = cm2.getActiveNetworkInfo();
        if (networkInfo == null) {
            return NetworkType.NETWORK_NO;
        }
        NetworkInfo info = networkInfo;
        if (!info.isConnected()) {
            return NetworkType.NETWORK_NO;
        }
        if (info.isAvailable()) {
            block0 : switch (info.getType()) {
                case 1: {
                    networkType = NetworkType.NETWORK_WIFI;
                    break;
                }
                case 0: {
                    switch (info.getSubtype()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: 
                        case 16: {
                            networkType = NetworkType.NETWORK_2G;
                            break block0;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: 
                        case 17: {
                            networkType = NetworkType.NETWORK_3G;
                            break block0;
                        }
                        case 13: 
                        case 18: {
                            networkType = NetworkType.NETWORK_4G;
                            break block0;
                        }
                        case 20: {
                            networkType = NetworkType.NETWORK_5G;
                            break block0;
                        }
                    }
                    String subtypeName = info.getSubtypeName();
                    if (StringsKt.equals((String)"TD-SCDMA", (String)subtypeName, (boolean)true) || StringsKt.equals((String)"WCDMA", (String)subtypeName, (boolean)true) || StringsKt.equals((String)"CDMA2000", (String)subtypeName, (boolean)true)) {
                        networkType = NetworkType.NETWORK_3G;
                        break;
                    }
                    networkType = NetworkType.NETWORK_UNKNOWN;
                    break;
                }
                default: {
                    networkType = NetworkType.NETWORK_UNKNOWN;
                    break;
                }
            }
        } else {
            networkType = NetworkType.NETWORK_NO;
        }
        return networkType;
    }

    @SuppressLint(value={"MissingPermission"})
    private final boolean isEthernet() {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager cm2 = (ConnectivityManager)object;
        NetworkInfo networkInfo = cm2.getNetworkInfo(9);
        if (networkInfo == null) {
            return false;
        }
        NetworkInfo info = networkInfo;
        NetworkInfo.State state = info.getState();
        if (state == null) {
            return false;
        }
        NetworkInfo.State state2 = state;
        return state2 == NetworkInfo.State.CONNECTED || state2 == NetworkInfo.State.CONNECTING;
    }

    @SuppressLint(value={"MissingPermission"})
    private final NetworkInfo getActiveNetworkInfo() {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager cm2 = (ConnectivityManager)object;
        return cm2.getActiveNetworkInfo();
    }

    private final String intToIp(int ipAddress) {
        return String.valueOf(ipAddress & 0xFF) + "." + (ipAddress >> 8 & 0xFF) + "." + (ipAddress >> 16 & 0xFF) + "." + (ipAddress >> 24 & 0xFF);
    }

    @Nullable
    public final String getIPAddress(boolean useIPv4) {
        String string;
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface networkInterface = en.nextElement();
                Intrinsics.checkNotNullExpressionValue((Object)networkInterface, (String)"en.nextElement()");
                Enumeration<InetAddress> enumIpAddress = networkInterface.getInetAddresses();
                while (enumIpAddress.hasMoreElements()) {
                    InetAddress inetAddress;
                    InetAddress inetAddress2 = inetAddress = enumIpAddress.nextElement();
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"inetAddress");
                    if (inetAddress2.isLoopbackAddress()) continue;
                    if (useIPv4) {
                        if (inetAddress.isLinkLocalAddress()) continue;
                        inetAddress.getHostAddress();
                        continue;
                    }
                    if (!(inetAddress instanceof Inet6Address)) continue;
                    inetAddress.getHostAddress();
                }
            }
            string = null;
        }
        catch (Exception ex) {
            L.INSTANCE.i("IP Address Ex ", ex.toString());
            string = null;
        }
        return string;
    }

    @Nullable
    public final String getIPAddress2(boolean useIPv4) {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            LinkedList<InetAddress> adds = new LinkedList<InetAddress>();
            while (nis.hasMoreElements()) {
                NetworkInterface ni;
                NetworkInterface networkInterface = ni = nis.nextElement();
                Intrinsics.checkNotNullExpressionValue((Object)networkInterface, (String)"ni");
                if (!networkInterface.isUp() || ni.isLoopback()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    adds.addFirst(addresses.nextElement());
                }
            }
            Iterator iterator = adds.iterator();
            while (iterator.hasNext()) {
                String string;
                boolean isIPv4;
                String hostAddress;
                InetAddress add;
                InetAddress inetAddress = add = (InetAddress)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"add");
                if (inetAddress.isLoopbackAddress()) continue;
                String string2 = hostAddress = add.getHostAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"hostAddress");
                boolean bl = isIPv4 = StringsKt.indexOf$default((CharSequence)string2, (char)':', (int)0, (boolean)false, (int)6, null) < 0;
                if (useIPv4) {
                    if (!isIPv4) continue;
                    return hostAddress;
                }
                if (isIPv4) continue;
                int index = StringsKt.indexOf$default((CharSequence)hostAddress, (char)'%', (int)0, (boolean)false, (int)6, null);
                if (index < 0) {
                    String string3 = hostAddress;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
                    Locale locale2 = locale;
                    boolean bl2 = false;
                    String string4 = string3;
                    boolean bl3 = false;
                    String string5 = string4.toUpperCase(locale2);
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toUpperCase(locale)");
                } else {
                    String string6 = hostAddress;
                    int n = 0;
                    boolean bl4 = false;
                    String string7 = string6.substring(n, index);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string6 = string7;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
                    Locale locale3 = locale;
                    bl4 = false;
                    String string8 = string6;
                    boolean bl5 = false;
                    String string9 = string8;
                    if (string9 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string10 = string9.toUpperCase(locale3);
                    string = string10;
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).toUpperCase(locale)");
                }
                return string;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    @NotNull
    public final String getBroadcastIpAddress() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            LinkedList adds = new LinkedList();
            while (nis.hasMoreElements()) {
                NetworkInterface ni;
                NetworkInterface networkInterface = ni = nis.nextElement();
                Intrinsics.checkNotNullExpressionValue((Object)networkInterface, (String)"ni");
                if (!networkInterface.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> ias = ni.getInterfaceAddresses();
                int size = ias.size();
                for (int i = 0; i < size; ++i) {
                    InterfaceAddress ia;
                    InterfaceAddress interfaceAddress = ia = ias.get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)interfaceAddress, (String)"ia");
                    InetAddress broadcast = interfaceAddress.getBroadcast();
                    if (broadcast == null) continue;
                    String string = broadcast.getHostAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"broadcast.hostAddress");
                    return string;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return "";
    }

    @NotNull
    public final String getDomainAddress(@Nullable String domain) {
        String string;
        InetAddress inetAddress = null;
        try {
            InetAddress inetAddress2 = InetAddress.getByName(domain);
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"InetAddress.getByName(domain)");
            inetAddress = inetAddress2;
            String string2 = inetAddress.getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"inetAddress.hostAddress");
            string = string2;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getIpAddressByWifi() {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wm = (WifiManager)object;
        String string = Formatter.formatIpAddress((int)wm.getDhcpInfo().ipAddress);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getGatewayByWifi() {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wm = (WifiManager)object;
        String string = Formatter.formatIpAddress((int)wm.getDhcpInfo().gateway);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getNetMaskByWifi() {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wm = (WifiManager)object;
        String string = Formatter.formatIpAddress((int)wm.getDhcpInfo().netmask);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getServerAddressByWifi() {
        Object object = AppUtils.INSTANCE.getContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wm = (WifiManager)object;
        String string = Formatter.formatIpAddress((int)wm.getDhcpInfo().serverAddress);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @SuppressLint(value={"MissingPermission"})
    public final int getWifiRSSI(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wifiManager = (WifiManager)object;
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        Intrinsics.checkNotNullExpressionValue((Object)wifiInfo, (String)"wifiManager.connectionInfo");
        return wifiInfo.getRssi();
    }

    @NotNull
    public final String getWifiSSID(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String ssid = "unknown id";
        if (Build.VERSION.SDK_INT <= 26 || Build.VERSION.SDK_INT == 28) {
            String string;
            Object object = context.getApplicationContext().getSystemService("wifi");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
            }
            WifiManager wifiManager = (WifiManager)object;
            WifiInfo info = wifiManager.getConnectionInfo();
            if (Build.VERSION.SDK_INT < 19) {
                WifiInfo wifiInfo = info;
                Intrinsics.checkNotNullExpressionValue((Object)wifiInfo, (String)"info");
                String string2 = wifiInfo.getSSID();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"info.ssid");
            } else {
                WifiInfo wifiInfo = info;
                Intrinsics.checkNotNullExpressionValue((Object)wifiInfo, (String)"info");
                String string3 = wifiInfo.getSSID();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"info.ssid");
                string = StringsKt.replace$default((String)string3, (String)"\"", (String)"", (boolean)false, (int)4, null);
            }
            return string;
        }
        if (Build.VERSION.SDK_INT == 27) {
            Object object = context.getApplicationContext().getSystemService("connectivity");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager connManager = (ConnectivityManager)object;
            NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnected() && networkInfo.getExtraInfo() != null) {
                String string = networkInfo.getExtraInfo();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"networkInfo.extraInfo");
                return StringsKt.replace$default((String)string, (String)"\"", (String)"", (boolean)false, (int)4, null);
            }
        }
        return ssid;
    }

    public final boolean isWifi(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        NetworkInfo info = connectivityManager.getActiveNetworkInfo();
        return info != null && info.getType() == 1;
    }

    @Nullable
    public final String getMac(@Nullable Context context) {
        String mac = "";
        if (Build.VERSION.SDK_INT < 23) {
            mac = this.getMacDefault(context);
        } else if (Build.VERSION.SDK_INT >= 23 && Build.VERSION.SDK_INT < 24) {
            mac = this.getMacAddress();
        } else if (Build.VERSION.SDK_INT >= 24) {
            mac = this.getMacFromHardware();
        }
        return mac;
    }

    @SuppressLint(value={"MissingPermission", "HardwareIds"})
    @Nullable
    public final String getMacDefault(@Nullable Context context) {
        String mac = "";
        if (context == null) {
            return mac;
        }
        Object object = context.getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        WifiManager wifi = (WifiManager)object;
        WifiInfo info = null;
        try {
            info = wifi.getConnectionInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (info == null) {
            return null;
        }
        String string = info.getMacAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"info.macAddress");
        mac = string;
        if (!TextUtils.isEmpty((CharSequence)mac)) {
            String string2 = mac;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
            Locale locale2 = locale;
            boolean bl = false;
            String string3 = string2;
            boolean bl2 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toUpperCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toUpperCase(locale)");
            mac = string5;
        }
        return mac;
    }

    @Nullable
    public final String getMacAddress() {
        String macSerial = null;
        String str = "";
        try {
            Process pp;
            Process process = pp = Runtime.getRuntime().exec("cat/sys/class/net/wlan0/address");
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"pp");
            InputStreamReader ir = new InputStreamReader(process.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (StringsKt.isBlank((CharSequence)str)) {
                Intrinsics.checkNotNullExpressionValue((Object)input.readLine(), (String)"input.readLine()");
                if (str == null) continue;
                String $this$trim$iv = str;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                macSerial = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return macSerial;
    }

    @NotNull
    public final String getMacFromHardware() {
        try {
            Enumeration<NetworkInterface> all = NetworkInterface.getNetworkInterfaces();
            while (all.hasMoreElements()) {
                NetworkInterface nif;
                NetworkInterface networkInterface = nif = all.nextElement();
                Intrinsics.checkNotNullExpressionValue((Object)networkInterface, (String)"nif");
                if (!StringsKt.equals((String)networkInterface.getName(), (String)"wlan0", (boolean)true)) continue;
                byte[] byArray = nif.getHardwareAddress();
                if (byArray == null) {
                    return "";
                }
                byte[] macBytes = byArray;
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string = "%02X:";
                    Object[] objectArray = new Object[]{b};
                    boolean bl = false;
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                    res1.append(string2);
                }
                if (!TextUtils.isEmpty((CharSequence)res1)) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                String string = res1.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"res1.toString()");
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private NetworkUtils() {
    }

    static {
        NetworkUtils networkUtils;
        INSTANCE = networkUtils = new NetworkUtils();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lando/toolkit/NetworkUtils$NetworkType;", "", "(Ljava/lang/String;I)V", "NETWORK_ETHERNET", "NETWORK_WIFI", "NETWORK_5G", "NETWORK_4G", "NETWORK_3G", "NETWORK_2G", "NETWORK_UNKNOWN", "NETWORK_NO", "ando_toolkit_release"})
    public static final class NetworkType
    extends Enum<NetworkType> {
        public static final /* enum */ NetworkType NETWORK_ETHERNET;
        public static final /* enum */ NetworkType NETWORK_WIFI;
        public static final /* enum */ NetworkType NETWORK_5G;
        public static final /* enum */ NetworkType NETWORK_4G;
        public static final /* enum */ NetworkType NETWORK_3G;
        public static final /* enum */ NetworkType NETWORK_2G;
        public static final /* enum */ NetworkType NETWORK_UNKNOWN;
        public static final /* enum */ NetworkType NETWORK_NO;
        private static final /* synthetic */ NetworkType[] $VALUES;

        static {
            NetworkType[] networkTypeArray = new NetworkType[8];
            NetworkType[] networkTypeArray2 = networkTypeArray;
            networkTypeArray[0] = NETWORK_ETHERNET = new NetworkType();
            networkTypeArray[1] = NETWORK_WIFI = new NetworkType();
            networkTypeArray[2] = NETWORK_5G = new NetworkType();
            networkTypeArray[3] = NETWORK_4G = new NetworkType();
            networkTypeArray[4] = NETWORK_3G = new NetworkType();
            networkTypeArray[5] = NETWORK_2G = new NetworkType();
            networkTypeArray[6] = NETWORK_UNKNOWN = new NetworkType();
            networkTypeArray[7] = NETWORK_NO = new NetworkType();
            $VALUES = networkTypeArray;
        }

        public static NetworkType[] values() {
            return (NetworkType[])$VALUES.clone();
        }

        public static NetworkType valueOf(String string) {
            return Enum.valueOf(NetworkType.class, string);
        }
    }
}

