/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit;

import ando.toolkit.R;
import ando.toolkit.ext.DimensionsExtKt;
import ando.toolkit.log.L;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Space;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.content.ContextCompat;
import com.google.android.material.snackbar.BaseTransientBottomBar;
import com.google.android.material.snackbar.Snackbar;
import com.google.android.material.snackbar.SnackbarContentLayout;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 D2\u00020\u0001:\u0001DB\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0002B\u0019\b\u0012\u0012\u0010\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J&\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eJ&\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u00020\u00002\b\b\u0001\u0010\u0013\u001a\u00020\u000eJ\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000eJ\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00002\b\b\u0001\u0010\u001a\u001a\u00020\u000eJ&\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eJ&\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eJ\b\u0010\u001d\u001a\u00020\u000eH\u0002J$\u0010\u001e\u001a\u00020\u00002\b\b\u0001\u0010\u001a\u001a\u00020\u000e2\b\b\u0001\u0010\u001f\u001a\u00020\u000e2\b\b\u0001\u0010\u0013\u001a\u00020\u000eJ\u0006\u0010 \u001a\u00020\u0000J\u0006\u0010!\u001a\u00020\u0000J\u0014\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u000eJ\u000e\u0010(\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u000eJ\u0006\u0010)\u001a\u00020\u0000J\u001a\u0010*\u001a\u00020\u00002\b\u0010+\u001a\u0004\u0018\u00010%2\b\u0010,\u001a\u0004\u0018\u00010%J#\u0010*\u001a\u00020\u00002\n\b\u0001\u0010+\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u000eJ&\u0010.\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u000eJ\b\u00104\u001a\u00020\u0000H\u0007J\u0010\u0010\u001f\u001a\u00020\u00002\b\b\u0001\u0010\u001f\u001a\u00020\u000eJ\b\u00105\u001a\u00020\u0000H\u0007J\u000e\u00106\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0018J \u00106\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000e2\b\b\u0001\u00108\u001a\u00020\u000eJ\u001a\u00109\u001a\u00020\u00002\b\u0010:\u001a\u0004\u0018\u00010;2\b\u0010<\u001a\u0004\u0018\u00010=J\u001a\u00109\u001a\u00020\u00002\b\b\u0001\u0010>\u001a\u00020\u000e2\b\u0010<\u001a\u0004\u0018\u00010=J\u0010\u0010?\u001a\u00020\u00002\b\u0010?\u001a\u0004\u0018\u00010@J\u0006\u0010A\u001a\u00020BJ\u0006\u0010C\u001a\u00020\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006E"}, d2={"Lando/toolkit/SnackbarUtils;", "", "()V", "snackbarWeakReference", "Ljava/lang/ref/WeakReference;", "Lcom/google/android/material/snackbar/Snackbar;", "(Ljava/lang/ref/WeakReference;)V", "snackBar", "getSnackBar", "()Lcom/google/android/material/snackbar/Snackbar;", "above", "targetView", "Landroid/view/View;", "contentViewTop", "", "marginLeft", "marginRight", "aboveCoordinatorLayout", "actionColor", "actionTextColor", "addView", "index", "layoutId", "alpha", "", "backColor", "backgroundColor", "bellow", "bellowCoordinatorLayout", "calculateSnackBarHeight", "colors", "messageColor", "confirm", "danger", "getRadiusDrawable", "Landroid/graphics/drawable/GradientDrawable;", "backgroundOri", "Landroid/graphics/drawable/Drawable;", "gravityCoordinatorLayout", "gravity", "gravityFrameLayout", "info", "leftAndRightDrawable", "leftDrawable", "rightDrawable", "(Ljava/lang/Integer;Ljava/lang/Integer;)Lando/toolkit/SnackbarUtils;", "margins", "margin", "left", "top", "right", "bottom", "messageCenter", "messageRight", "radius", "strokeWidth", "strokeColor", "setAction", "text", "", "listener", "Landroid/view/View$OnClickListener;", "resId", "setCallback", "Lcom/google/android/material/snackbar/Snackbar$Callback;", "show", "", "warning", "Companion", "ando_toolkit_release"})
public final class SnackbarUtils {
    private static final String TAG = "SnackbarUtils";
    private static int sColorInfo;
    private static int sColorConfirm;
    private static int sColorWarning;
    private static int sColorDanger;
    private static WeakReference<Snackbar> mSnackbarWeakRef;
    @NotNull
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Snackbar getSnackBar() {
        if (mSnackbarWeakRef == null) return null;
        WeakReference<Snackbar> weakReference = mSnackbarWeakRef;
        if (weakReference == null) return null;
        Snackbar snackbar = (Snackbar)weakReference.get();
        if (snackbar == null) return null;
        WeakReference<Snackbar> weakReference2 = mSnackbarWeakRef;
        if (weakReference2 == null) return null;
        Snackbar snackbar2 = (Snackbar)weakReference2.get();
        return snackbar2;
    }

    @NotNull
    public final SnackbarUtils info() {
        block0: {
            Snackbar snackbar;
            if (this.getSnackBar() == null || (snackbar = this.getSnackBar()) == null || (snackbar = snackbar.getView()) == null) break block0;
            snackbar.setBackgroundColor(sColorInfo);
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils confirm() {
        block0: {
            Snackbar snackbar;
            if (this.getSnackBar() == null || (snackbar = this.getSnackBar()) == null || (snackbar = snackbar.getView()) == null) break block0;
            snackbar.setBackgroundColor(sColorConfirm);
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils warning() {
        block0: {
            Snackbar snackbar;
            if (this.getSnackBar() == null || (snackbar = this.getSnackBar()) == null || (snackbar = snackbar.getView()) == null) break block0;
            snackbar.setBackgroundColor(sColorWarning);
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils danger() {
        block0: {
            Snackbar snackbar;
            if (this.getSnackBar() == null || (snackbar = this.getSnackBar()) == null || (snackbar = snackbar.getView()) == null) break block0;
            snackbar.setBackgroundColor(sColorDanger);
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils backColor(@ColorInt int backgroundColor) {
        block0: {
            Snackbar snackbar;
            if (this.getSnackBar() == null || (snackbar = this.getSnackBar()) == null || (snackbar = snackbar.getView()) == null) break block0;
            snackbar.setBackgroundColor(backgroundColor);
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils messageColor(@ColorInt int messageColor) {
        if (this.getSnackBar() != null) {
            Snackbar snackbar = this.getSnackBar();
            View view = snackbar != null && (snackbar = snackbar.getView()) != null ? snackbar.findViewById(R.id.snackbar_text) : null;
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
            }
            ((TextView)view).setTextColor(messageColor);
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils actionColor(@ColorInt int actionTextColor) {
        if (this.getSnackBar() != null) {
            Snackbar snackbar = this.getSnackBar();
            View view = snackbar != null && (snackbar = snackbar.getView()) != null ? snackbar.findViewById(R.id.snackbar_action) : null;
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.Button");
            }
            ((Button)view).setTextColor(actionTextColor);
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils colors(@ColorInt int backgroundColor, @ColorInt int messageColor, @ColorInt int actionTextColor) {
        if (this.getSnackBar() != null) {
            Snackbar snackbar;
            Snackbar snackbar2 = this.getSnackBar();
            if (snackbar2 != null && (snackbar2 = snackbar2.getView()) != null) {
                snackbar2.setBackgroundColor(backgroundColor);
            }
            View view = (snackbar = this.getSnackBar()) != null && (snackbar = snackbar.getView()) != null ? snackbar.findViewById(R.id.snackbar_text) : null;
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
            }
            ((TextView)view).setTextColor(messageColor);
            Snackbar snackbar3 = this.getSnackBar();
            View view2 = snackbar3 != null && (snackbar3 = snackbar3.getView()) != null ? snackbar3.findViewById(R.id.snackbar_action) : null;
            if (view2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.Button");
            }
            ((Button)view2).setTextColor(actionTextColor);
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils alpha(float alpha) {
        block3: {
            Snackbar snackbar;
            float f;
            float a = alpha;
            if (this.getSnackBar() == null) break block3;
            if (a >= 1.0f) {
                f = 1.0f;
            } else {
                float f2 = 0.0f;
                boolean bl = false;
                f = a = Math.max(a, f2);
            }
            if ((snackbar = this.getSnackBar()) != null && (snackbar = snackbar.getView()) != null) {
                snackbar.setAlpha(a);
            }
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils gravityFrameLayout(int gravity) {
        block1: {
            Snackbar snackbar;
            if (this.getSnackBar() == null) break block1;
            Snackbar snackbar2 = this.getSnackBar();
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(snackbar2 != null && (snackbar2 = snackbar2.getView()) != null && (snackbar2 = snackbar2.getLayoutParams()) != null ? snackbar2.width : 0, (snackbar = this.getSnackBar()) != null && (snackbar = snackbar.getView()) != null && (snackbar = snackbar.getLayoutParams()) != null ? snackbar.height : 0);
            params.gravity = gravity;
            Snackbar snackbar3 = this.getSnackBar();
            if (snackbar3 != null && (snackbar3 = snackbar3.getView()) != null) {
                snackbar3.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils gravityCoordinatorLayout(int gravity) {
        block1: {
            Snackbar snackbar;
            if (this.getSnackBar() == null) break block1;
            Snackbar snackbar2 = this.getSnackBar();
            CoordinatorLayout.LayoutParams params = new CoordinatorLayout.LayoutParams(snackbar2 != null && (snackbar2 = snackbar2.getView()) != null && (snackbar2 = snackbar2.getLayoutParams()) != null ? snackbar2.width : 0, (snackbar = this.getSnackBar()) != null && (snackbar = snackbar.getView()) != null && (snackbar = snackbar.getLayoutParams()) != null ? snackbar.height : 0);
            params.gravity = gravity;
            Snackbar snackbar3 = this.getSnackBar();
            if (snackbar3 != null && (snackbar3 = snackbar3.getView()) != null) {
                snackbar3.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils setAction(@StringRes int resId, @Nullable View.OnClickListener listener) {
        Snackbar snackbar;
        return this.getSnackBar() != null ? this.setAction((snackbar = this.getSnackBar()) != null && (snackbar = snackbar.getView()) != null && (snackbar = snackbar.getResources()) != null ? snackbar.getText(resId) : null, listener) : this;
    }

    @NotNull
    public final SnackbarUtils setAction(@Nullable CharSequence text, @Nullable View.OnClickListener listener) {
        block1: {
            if (this.getSnackBar() == null) break block1;
            Snackbar snackbar = this.getSnackBar();
            if (snackbar != null) {
                snackbar.setAction(text, listener);
            }
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils setCallback(@Nullable Snackbar.Callback setCallback) {
        block0: {
            Snackbar snackbar = this.getSnackBar();
            if (snackbar == null) break block0;
            Snackbar cfr_ignored_0 = (Snackbar)snackbar.addCallback((BaseTransientBottomBar.BaseCallback)setCallback);
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils leftAndRightDrawable(@DrawableRes @Nullable Integer leftDrawable, @DrawableRes @Nullable Integer rightDrawable) {
        if (this.getSnackBar() == null) {
            return this;
        }
        Drawable drawableLeft = null;
        Drawable drawableRight = null;
        if (leftDrawable != null) {
            try {
                Snackbar snackbar = this.getSnackBar();
                if (snackbar == null || (snackbar = snackbar.getContext()) == null) {
                    return this;
                }
                drawableLeft = ContextCompat.getDrawable((Context)snackbar, (int)leftDrawable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rightDrawable != null) {
            try {
                Snackbar snackbar = this.getSnackBar();
                if (snackbar == null || (snackbar = snackbar.getContext()) == null) {
                    return this;
                }
                drawableRight = ContextCompat.getDrawable((Context)snackbar, (int)rightDrawable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.leftAndRightDrawable(drawableLeft, drawableRight);
    }

    @NotNull
    public final SnackbarUtils leftAndRightDrawable(@Nullable Drawable leftDrawable, @Nullable Drawable rightDrawable) {
        TextView message;
        if (this.getSnackBar() == null) {
            return this;
        }
        Snackbar snackbar = this.getSnackBar();
        TextView textView = message = snackbar != null && (snackbar = snackbar.getView()) != null ? (TextView)snackbar.findViewById(R.id.snackbar_text) : null;
        Object object = textView != null ? textView.getLayoutParams() : null;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        }
        LinearLayout.LayoutParams paramsMessage = (LinearLayout.LayoutParams)object;
        paramsMessage = new LinearLayout.LayoutParams(paramsMessage.width, paramsMessage.height, 0.0f);
        message.setLayoutParams((ViewGroup.LayoutParams)paramsMessage);
        message.setCompoundDrawablePadding(message.getPaddingLeft());
        int textSize = (int)message.getTextSize();
        L.INSTANCE.d(TAG, "textSize:" + textSize);
        Drawable drawable = leftDrawable;
        if (drawable != null) {
            drawable.setBounds(0, 0, textSize, textSize);
        }
        Drawable drawable2 = rightDrawable;
        if (drawable2 != null) {
            drawable2.setBounds(0, 0, textSize, textSize);
        }
        message.setCompoundDrawables(leftDrawable, null, rightDrawable, null);
        LinearLayout.LayoutParams paramsSpace = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        Snackbar snackbar2 = this.getSnackBar();
        Object object2 = snackbar2 != null ? snackbar2.getView() : null;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.android.material.snackbar.Snackbar.SnackbarLayout");
        }
        Snackbar snackbar3 = this.getSnackBar();
        ((Snackbar.SnackbarLayout)object2).addView((View)new Space(snackbar3 != null && (snackbar3 = snackbar3.getView()) != null ? snackbar3.getContext() : null), 1, (ViewGroup.LayoutParams)paramsSpace);
        return this;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    @TargetApi(value=17)
    @NotNull
    public final SnackbarUtils messageCenter() {
        block3: {
            TextView message;
            if (this.getSnackBar() == null) {
                return this;
            }
            if (Build.VERSION.SDK_INT < 17) break block3;
            Snackbar snackbar = this.getSnackBar();
            TextView textView = message = snackbar != null && (snackbar = snackbar.getView()) != null ? (TextView)snackbar.findViewById(R.id.snackbar_text) : null;
            if (textView != null) {
                textView.setTextAlignment(1);
            }
            TextView textView2 = message;
            if (textView2 != null) {
                textView2.setGravity(17);
            }
        }
        return this;
    }

    @SuppressLint(value={"RtlHardcoded", "ObsoleteSdkInt"})
    @TargetApi(value=17)
    @NotNull
    public final SnackbarUtils messageRight() {
        block2: {
            TextView message;
            if (Build.VERSION.SDK_INT < 17 || this.getSnackBar() == null) break block2;
            Snackbar snackbar = this.getSnackBar();
            TextView textView = message = snackbar != null && (snackbar = snackbar.getView()) != null ? (TextView)snackbar.findViewById(R.id.snackbar_text) : null;
            if (textView != null) {
                textView.setTextAlignment(1);
            }
            TextView textView2 = message;
            if (textView2 != null) {
                textView2.setGravity(21);
            }
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils addView(int layoutId, int index) {
        SnackbarUtils snackbarUtils;
        if (this.getSnackBar() != null) {
            View addView;
            Snackbar snackbar = this.getSnackBar();
            View view = addView = LayoutInflater.from(snackbar != null && (snackbar = snackbar.getView()) != null ? snackbar.getContext() : null).inflate(layoutId, null);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"addView");
            snackbarUtils = this.addView(view, index);
        } else {
            snackbarUtils = this;
        }
        return snackbarUtils;
    }

    @NotNull
    public final SnackbarUtils addView(@NotNull View addView, int index) {
        Intrinsics.checkNotNullParameter((Object)addView, (String)"addView");
        if (this.getSnackBar() != null) {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            params.gravity = 16;
            addView.setLayoutParams((ViewGroup.LayoutParams)params);
            Snackbar snackbar = this.getSnackBar();
            Object object = snackbar != null ? snackbar.getView() : null;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.google.android.material.snackbar.Snackbar.SnackbarLayout");
            }
            View view = ((Snackbar.SnackbarLayout)object).getChildAt(0);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.google.android.material.snackbar.SnackbarContentLayout");
            }
            SnackbarContentLayout contentLayout = (SnackbarContentLayout)view;
            contentLayout.addView(addView, index);
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils margins(int margin) {
        return this.getSnackBar() != null ? this.margins(margin, margin, margin, margin) : this;
    }

    @NotNull
    public final SnackbarUtils margins(int left, int top, int right, int bottom) {
        block2: {
            ViewGroup.LayoutParams params;
            if (this.getSnackBar() == null) {
                return this;
            }
            Snackbar snackbar = this.getSnackBar();
            ViewGroup.LayoutParams layoutParams = params = snackbar != null && (snackbar = snackbar.getView()) != null ? snackbar.getLayoutParams() : null;
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            }
            ((ViewGroup.MarginLayoutParams)layoutParams).setMargins(left, top, right, bottom);
            Snackbar snackbar2 = this.getSnackBar();
            if (snackbar2 == null || (snackbar2 = snackbar2.getView()) == null) break block2;
            snackbar2.setLayoutParams(params);
        }
        return this;
    }

    private final GradientDrawable getRadiusDrawable(Drawable backgroundOri) {
        GradientDrawable background = null;
        if (backgroundOri instanceof GradientDrawable) {
            background = (GradientDrawable)backgroundOri;
        } else if (backgroundOri instanceof ColorDrawable) {
            int backgroundColor = ((ColorDrawable)backgroundOri).getColor();
            background = new GradientDrawable();
            background.setColor(backgroundColor);
        }
        return background;
    }

    @NotNull
    public final SnackbarUtils radius(float radius) {
        block2: {
            float r = radius;
            if (this.getSnackBar() == null) {
                return this;
            }
            Snackbar snackbar = this.getSnackBar();
            GradientDrawable background = this.getRadiusDrawable(snackbar != null && (snackbar = snackbar.getView()) != null ? snackbar.getBackground() : null);
            if (background == null) break block2;
            r = r <= 0.0f ? 12.0f : r;
            background.setCornerRadius(r);
            Snackbar snackbar2 = this.getSnackBar();
            if (snackbar2 != null && (snackbar2 = snackbar2.getView()) != null) {
                snackbar2.setBackgroundDrawable((Drawable)background);
            }
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils radius(int radius, int strokeWidth, @ColorInt int strokeColor) {
        block2: {
            Snackbar snackbar;
            int r = radius;
            int sWidth = strokeWidth;
            if (this.getSnackBar() == null) {
                return this;
            }
            Snackbar snackbar2 = this.getSnackBar();
            GradientDrawable background = this.getRadiusDrawable(snackbar2 != null && (snackbar2 = snackbar2.getView()) != null ? snackbar2.getBackground() : null);
            if (background == null) break block2;
            r = r <= 0 ? 12 : r;
            sWidth = sWidth <= 0 ? 1 : (sWidth >= ((snackbar = this.getSnackBar()) != null && (snackbar = snackbar.getView()) != null && (snackbar = snackbar.findViewById(R.id.snackbar_text)) != null ? snackbar.getPaddingTop() : 0) ? 2 : sWidth);
            background.setCornerRadius((float)r);
            background.setStroke(sWidth, strokeColor);
            Snackbar snackbar3 = this.getSnackBar();
            if (snackbar3 != null && (snackbar3 = snackbar3.getView()) != null) {
                snackbar3.setBackgroundDrawable((Drawable)background);
            }
        }
        return this;
    }

    private final int calculateSnackBarHeight() {
        Snackbar snackbar;
        Snackbar snackbar2;
        Snackbar snackbar3 = this.getSnackBar();
        Integer snackBarHeight = snackbar3 != null && (snackbar3 = snackbar3.getView()) != null && (snackbar3 = snackbar3.getContext()) != null ? Integer.valueOf(DimensionsExtKt.dp2px((Context)snackbar3, 28.0f) + ((snackbar2 = this.getSnackBar()) != null && (snackbar2 = snackbar2.getView()) != null && (snackbar2 = snackbar2.getContext()) != null ? DimensionsExtKt.sp2px((Context)snackbar2, 14.0f) : 0)) : null;
        L.INSTANCE.d(TAG, "\u76f4\u63a5\u83b7\u53d6MessageView\u9ad8\u5ea6:" + ((snackbar = this.getSnackBar()) != null && (snackbar = snackbar.getView()) != null && (snackbar = snackbar.findViewById(R.id.snackbar_text)) != null ? Integer.valueOf(snackbar.getHeight()) : null));
        Integer n = snackBarHeight;
        return n != null ? n : 0;
    }

    @NotNull
    public final SnackbarUtils above(@NotNull View targetView, int contentViewTop, int marginLeft, int marginRight) {
        block3: {
            ViewGroup.LayoutParams params;
            Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
            int mLeft = marginLeft;
            int mRight = marginRight;
            if (this.getSnackBar() == null) {
                return this;
            }
            int n = 0;
            boolean bl = false;
            mLeft = Math.max(mLeft, n);
            n = 0;
            bl = false;
            mRight = Math.max(mRight, n);
            int[] locations = new int[2];
            targetView.getLocationOnScreen(locations);
            L.INSTANCE.d(TAG, "\u8ddd\u79bb\u5c4f\u5e55\u5de6\u4fa7:" + locations[0] + "==\u8ddd\u79bb\u5c4f\u5e55\u9876\u90e8:" + locations[1]);
            int snackBarHeight = this.calculateSnackBarHeight();
            L.INSTANCE.d(TAG, "Snackbar\u9ad8\u5ea6:" + snackBarHeight);
            if (locations[1] < contentViewTop + snackBarHeight) break block3;
            this.gravityFrameLayout(80);
            Snackbar snackbar = this.getSnackBar();
            ViewGroup.LayoutParams layoutParams = params = snackbar != null && (snackbar = snackbar.getView()) != null ? snackbar.getLayoutParams() : null;
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            }
            Snackbar snackbar2 = this.getSnackBar();
            ((ViewGroup.MarginLayoutParams)layoutParams).setMargins(mLeft, 0, mRight, snackbar2 != null && (snackbar2 = snackbar2.getView()) != null && (snackbar2 = snackbar2.getResources()) != null && (snackbar2 = snackbar2.getDisplayMetrics()) != null ? snackbar2.heightPixels : 0 - locations[1]);
            Snackbar snackbar3 = this.getSnackBar();
            if (snackbar3 != null && (snackbar3 = snackbar3.getView()) != null) {
                snackbar3.setLayoutParams(params);
            }
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils aboveCoordinatorLayout(@NotNull View targetView, int contentViewTop, int marginLeft, int marginRight) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
            int mLeft = marginLeft;
            int mRight = marginRight;
            if (this.getSnackBar() == null) break block3;
            int n = 0;
            boolean bl = false;
            mLeft = Math.max(mLeft, n);
            n = 0;
            bl = false;
            mRight = Math.max(mRight, n);
            int[] locations = new int[2];
            targetView.getLocationOnScreen(locations);
            L.INSTANCE.d(TAG, "\u8ddd\u79bb\u5c4f\u5e55\u5de6\u4fa7:" + locations[0] + "==\u8ddd\u79bb\u5c4f\u5e55\u9876\u90e8:" + locations[1]);
            int snackbarHeight = this.calculateSnackBarHeight();
            L.INSTANCE.d(TAG, "Snackbar\u9ad8\u5ea6:" + snackbarHeight);
            if (locations[1] >= contentViewTop + snackbarHeight) {
                ViewGroup.LayoutParams params;
                this.gravityCoordinatorLayout(80);
                Snackbar snackbar = this.getSnackBar();
                ViewGroup.LayoutParams layoutParams = params = snackbar != null && (snackbar = snackbar.getView()) != null ? snackbar.getLayoutParams() : null;
                if (layoutParams == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                }
                Snackbar snackbar2 = this.getSnackBar();
                ((ViewGroup.MarginLayoutParams)layoutParams).setMargins(mLeft, 0, mRight, snackbar2 != null && (snackbar2 = snackbar2.getView()) != null && (snackbar2 = snackbar2.getResources()) != null && (snackbar2 = snackbar2.getDisplayMetrics()) != null ? snackbar2.heightPixels : 0 - locations[1]);
                Snackbar snackbar3 = this.getSnackBar();
                if (snackbar3 != null && (snackbar3 = snackbar3.getView()) != null) {
                    snackbar3.setLayoutParams(params);
                }
            }
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils bellow(@NotNull View targetView, int contentViewTop, int marginLeft, int marginRight) {
        block4: {
            ViewGroup.LayoutParams params;
            int screenHeight;
            int snackBarHeight;
            int[] locations;
            int marRight;
            int marLeft;
            block5: {
                ViewGroup.LayoutParams params2;
                Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
                marLeft = marginLeft;
                marRight = marginRight;
                if (this.getSnackBar() == null) break block4;
                int n = 0;
                boolean bl = false;
                marLeft = Math.max(marLeft, n);
                n = 0;
                bl = false;
                marRight = Math.max(marRight, n);
                locations = new int[2];
                targetView.getLocationOnScreen(locations);
                snackBarHeight = this.calculateSnackBarHeight();
                Snackbar snackbar = this.getSnackBar();
                int n2 = snackbar != null && (snackbar = snackbar.getView()) != null && (snackbar = snackbar.getContext()) != null ? DimensionsExtKt.getScreenHeight((Context)snackbar) : (screenHeight = 0);
                if (Build.VERSION.SDK_INT < 21) break block5;
                if (locations[1] + targetView.getHeight() < contentViewTop || locations[1] + targetView.getHeight() + snackBarHeight + 2 > screenHeight) break block4;
                this.gravityFrameLayout(80);
                Snackbar snackbar2 = this.getSnackBar();
                ViewGroup.LayoutParams layoutParams = params2 = snackbar2 != null && (snackbar2 = snackbar2.getView()) != null ? snackbar2.getLayoutParams() : null;
                if (layoutParams == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                }
                ((ViewGroup.MarginLayoutParams)layoutParams).setMargins(marLeft, 0, marRight, screenHeight - (locations[1] + targetView.getHeight() + snackBarHeight + 2));
                Snackbar snackbar3 = this.getSnackBar();
                if (snackbar3 != null && (snackbar3 = snackbar3.getView()) != null) {
                    snackbar3.setLayoutParams(params2);
                }
                break block4;
            }
            if (locations[1] + targetView.getHeight() < contentViewTop || locations[1] + targetView.getHeight() + snackBarHeight > screenHeight) break block4;
            this.gravityFrameLayout(80);
            Snackbar snackbar = this.getSnackBar();
            ViewGroup.LayoutParams layoutParams = params = snackbar != null && (snackbar = snackbar.getView()) != null ? snackbar.getLayoutParams() : null;
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            }
            ((ViewGroup.MarginLayoutParams)layoutParams).setMargins(marLeft, 0, marRight, screenHeight - (locations[1] + targetView.getHeight() + snackBarHeight));
            Snackbar snackbar4 = this.getSnackBar();
            if (snackbar4 != null && (snackbar4 = snackbar4.getView()) != null) {
                snackbar4.setLayoutParams(params);
            }
        }
        return this;
    }

    @NotNull
    public final SnackbarUtils bellowCoordinatorLayout(@NotNull View targetView, int contentViewTop, int marginLeft, int marginRight) {
        block6: {
            ViewGroup.LayoutParams params;
            int screenHeight;
            int snackBarHeight;
            int[] locations;
            int marRight;
            int marLeft;
            block5: {
                ViewGroup.LayoutParams params2;
                Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
                marLeft = marginLeft;
                marRight = marginRight;
                if (this.getSnackBar() == null) {
                    return this;
                }
                int n = 0;
                boolean bl = false;
                marLeft = Math.max(marLeft, n);
                n = 0;
                bl = false;
                marRight = Math.max(marRight, n);
                locations = new int[2];
                targetView.getLocationOnScreen(locations);
                snackBarHeight = this.calculateSnackBarHeight();
                Snackbar snackbar = this.getSnackBar();
                int n2 = snackbar != null && (snackbar = snackbar.getView()) != null && (snackbar = snackbar.getContext()) != null ? DimensionsExtKt.getScreenHeight((Context)snackbar) : (screenHeight = 0);
                if (Build.VERSION.SDK_INT < 21) break block5;
                if (locations[1] + targetView.getHeight() < contentViewTop || locations[1] + targetView.getHeight() + snackBarHeight + 2 > screenHeight) break block6;
                this.gravityCoordinatorLayout(80);
                Snackbar snackbar2 = this.getSnackBar();
                ViewGroup.LayoutParams layoutParams = params2 = snackbar2 != null && (snackbar2 = snackbar2.getView()) != null ? snackbar2.getLayoutParams() : null;
                if (layoutParams == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                }
                ((ViewGroup.MarginLayoutParams)layoutParams).setMargins(marLeft, 0, marRight, screenHeight - (locations[1] + targetView.getHeight() + snackBarHeight + 2));
                Snackbar snackbar3 = this.getSnackBar();
                if (snackbar3 != null && (snackbar3 = snackbar3.getView()) != null) {
                    snackbar3.setLayoutParams(params2);
                }
                break block6;
            }
            if (locations[1] + targetView.getHeight() < contentViewTop || locations[1] + targetView.getHeight() + snackBarHeight > screenHeight) break block6;
            this.gravityCoordinatorLayout(80);
            Snackbar snackbar = this.getSnackBar();
            ViewGroup.LayoutParams layoutParams = params = snackbar != null && (snackbar = snackbar.getView()) != null ? snackbar.getLayoutParams() : null;
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            }
            ((ViewGroup.MarginLayoutParams)layoutParams).setMargins(marLeft, 0, marRight, screenHeight - (locations[1] + targetView.getHeight() + snackBarHeight));
            Snackbar snackbar4 = this.getSnackBar();
            if (snackbar4 != null && (snackbar4 = snackbar4.getView()) != null) {
                snackbar4.setLayoutParams(params);
            }
        }
        return this;
    }

    public final void show() {
        if (this.getSnackBar() != null) {
            Snackbar snackbar = this.getSnackBar();
            if (snackbar != null) {
                snackbar.show();
            }
        } else {
            L.INSTANCE.d(TAG, "\u5df2\u7ecf\u88ab\u56de\u6536");
        }
    }

    private SnackbarUtils() {
        throw (Throwable)new UnsupportedOperationException("u can't instantiate me...");
    }

    private SnackbarUtils(WeakReference<Snackbar> snackbarWeakReference) {
        mSnackbarWeakRef = snackbarWeakReference;
    }

    static {
        Companion = new Companion(null);
        sColorInfo = -14049565;
        sColorConfirm = -11751346;
        sColorWarning = -81915;
        sColorDanger = -769226;
    }

    public static final /* synthetic */ int access$getSColorInfo$cp() {
        return sColorInfo;
    }

    public static final /* synthetic */ int access$getSColorConfirm$cp() {
        return sColorConfirm;
    }

    public static final /* synthetic */ int access$getSColorWarning$cp() {
        return sColorWarning;
    }

    public static final /* synthetic */ int access$getSColorDanger$cp() {
        return sColorDanger;
    }

    public /* synthetic */ SnackbarUtils(WeakReference snackbarWeakReference, DefaultConstructorMarker $constructor_marker) {
        this(snackbarWeakReference);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\tJ\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\tJ\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lando/toolkit/SnackbarUtils$Companion;", "", "()V", "TAG", "", "mSnackbarWeakRef", "Ljava/lang/ref/WeakReference;", "Lcom/google/android/material/snackbar/Snackbar;", "sColorConfirm", "", "sColorDanger", "sColorInfo", "sColorWarning", "Custom", "Lando/toolkit/SnackbarUtils;", "view", "Landroid/view/View;", "message", "duration", "Indefinite", "Long", "Short", "setColorConfirm", "", "colorConfirm", "setColorDanger", "colorDanger", "setColorInfo", "colorInfo", "setColorWarning", "colorWarning", "ando_toolkit_release"})
    public static final class Companion {
        public final void setColorInfo(int colorInfo) {
            sColorInfo = colorInfo;
        }

        public final void setColorConfirm(int colorConfirm) {
            sColorConfirm = colorConfirm;
        }

        public final void setColorWarning(int colorWarning) {
            sColorWarning = colorWarning;
        }

        public final void setColorDanger(int colorDanger) {
            sColorDanger = colorDanger;
        }

        @NotNull
        public final SnackbarUtils Short(@NotNull View view, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new SnackbarUtils(new WeakReference<Snackbar>(Snackbar.make((View)view, (CharSequence)message, (int)-1)), null).backColor(-13487566);
        }

        @NotNull
        public final SnackbarUtils Long(@NotNull View view, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new SnackbarUtils(new WeakReference<Snackbar>(Snackbar.make((View)view, (CharSequence)message, (int)0)), null).backColor(-13487566);
        }

        @NotNull
        public final SnackbarUtils Indefinite(@NotNull View view, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new SnackbarUtils(new WeakReference<Snackbar>(Snackbar.make((View)view, (CharSequence)message, (int)-2)), null).backColor(-13487566);
        }

        @NotNull
        public final SnackbarUtils Custom(@NotNull View view, @NotNull String message, int duration) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new SnackbarUtils(new WeakReference<BaseTransientBottomBar>(Snackbar.make((View)view, (CharSequence)message, (int)-1).setDuration(duration)), null).backColor(-13487566);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

