/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit.ext;

import android.content.Context;
import androidx.annotation.DimenRes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004J\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004J\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"Lando/toolkit/ext/DimensionsUtils;", "", "()V", "dimen2px", "", "context", "Landroid/content/Context;", "resource", "dp2px", "value", "", "px2dp", "px", "px2sp", "sp2px", "ando_toolkit_release"})
public final class DimensionsUtils {
    @NotNull
    public static final DimensionsUtils INSTANCE = new DimensionsUtils();

    private DimensionsUtils() {
    }

    public final int dp2px(@NotNull Context context, int value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (int)((float)value * context.getResources().getDisplayMetrics().density);
    }

    public final int dp2px(@NotNull Context context, float value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (int)(value * context.getResources().getDisplayMetrics().density);
    }

    public final int sp2px(@NotNull Context context, int value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (int)((float)value * context.getResources().getDisplayMetrics().scaledDensity);
    }

    public final int sp2px(@NotNull Context context, float value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (int)(value * context.getResources().getDisplayMetrics().scaledDensity);
    }

    public final float px2dp(@NotNull Context context, int px) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (float)px / context.getResources().getDisplayMetrics().density;
    }

    public final float px2sp(@NotNull Context context, int px) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (float)px / context.getResources().getDisplayMetrics().scaledDensity;
    }

    public final int dimen2px(@NotNull Context context, @DimenRes int resource) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getDimensionPixelSize(resource);
    }
}

