/*
 * Decompiled with CFR 0.152.
 */
package ando.toolkit.immersion;

import ando.toolkit.OSUtils;
import ando.toolkit.WindowUtils;
import ando.toolkit.ext.DimensionUtils;
import ando.toolkit.immersion.FlymeStatusBar;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\tH\u0003J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\tH\u0002J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001f\u001a\u00020\u0004J\u0006\u0010 \u001a\u00020\tJ\u000e\u0010!\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lando/toolkit/immersion/StatusBarUtils;", "", "()V", "SYSTEM_UI_FLAG_OP_STATUS_BAR_TINT", "", "calculateStatusColor", "color", "alpha", "checkDeviceHasNavigationBar", "", "context", "Landroid/content/Context;", "getNavigationBarHeight", "getStatusBarHeight", "setDarkMode", "", "window", "Landroid/view/Window;", "setFlymeStatusBarDarkMode", "darkMode", "setLightMode", "setMIUIStatusBarDarkMode", "setOppoStatusBarDarkMode", "setStatusBarColor", "setStatusBarDarkMode", "setStatusBarDrawable", "activity", "Landroid/app/Activity;", "drawable", "Landroid/graphics/drawable/Drawable;", "setStatusBarView", "statusBarColor", "supportTransparentStatusBar", "transparentStatusBar", "transparentStatusBarAbove21", "ando_toolkit_release"})
public final class StatusBarUtils {
    private static final int SYSTEM_UI_FLAG_OP_STATUS_BAR_TINT = 16;
    @NotNull
    public static final StatusBarUtils INSTANCE;

    public final void setStatusBarView(@NotNull Activity activity, @ColorRes int statusBarColor) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 21) {
            View view = activity.findViewById(0x1020002);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout");
            }
            FrameLayout decorView = (FrameLayout)view;
            int count = decorView.getChildCount();
            if (count > 0) {
                View layout;
                int statusBarHeight = this.getStatusBarHeight((Context)activity);
                View view2 = layout = decorView.getChildAt(0);
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"layout");
                ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
                if (layoutParams == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                }
                FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
                layoutParams2.topMargin = statusBarHeight;
                View statusBarView = null;
                if (count > 1) {
                    View view3 = decorView.getChildAt(1);
                    if (view3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.view.View");
                    }
                    statusBarView = view3;
                } else {
                    statusBarView = new View((Context)activity);
                    LinearLayout.LayoutParams viewParams = new LinearLayout.LayoutParams(-1, statusBarHeight);
                    statusBarView.setLayoutParams((ViewGroup.LayoutParams)viewParams);
                    decorView.addView(statusBarView);
                }
                statusBarView.setBackgroundResource(statusBarColor);
            }
        }
    }

    public final void setStatusBarDrawable(@NotNull Activity activity, @Nullable Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                Field field;
                Class<?> decorViewClazz = Class.forName("com.android.internal.policy.DecorView");
                Field field2 = field = decorViewClazz.getDeclaredField("mSemiTransparentStatusBarColor");
                Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"field");
                field2.setAccessible(true);
                Window window = activity.getWindow();
                Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
                field.setInt(window.getDecorView(), 0);
            }
            catch (Exception e) {
                Log.e((String)WindowUtils.class.getSimpleName(), (String)e.getMessage());
            }
        }
        if (drawable == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            View view = activity.findViewById(0x1020002);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout");
            }
            FrameLayout rootView = (FrameLayout)view;
            int count = rootView.getChildCount();
            if (count > 0) {
                View layout = rootView.getChildAt(0);
                int statusBarHeight = DimensionUtils.INSTANCE.getStatusBarHeight();
                View view2 = layout;
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"layout");
                ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
                if (layoutParams == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                }
                FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
                layoutParams2.topMargin = statusBarHeight;
                ImageView statusBarView = null;
                if (count > 1) {
                    View view3 = rootView.getChildAt(1);
                    if (view3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.widget.ImageView");
                    }
                    statusBarView = (ImageView)view3;
                } else {
                    statusBarView = new ImageView((Context)activity);
                    LinearLayout.LayoutParams viewParams = new LinearLayout.LayoutParams(-1, statusBarHeight);
                    statusBarView.setScaleType(ImageView.ScaleType.FIT_XY);
                    statusBarView.setLayoutParams((ViewGroup.LayoutParams)viewParams);
                    rootView.addView((View)statusBarView);
                }
                statusBarView.setImageDrawable(drawable);
            }
        }
    }

    public final boolean supportTransparentStatusBar() {
        return OSUtils.INSTANCE.isMiui() || OSUtils.INSTANCE.isFlyme() || OSUtils.INSTANCE.isOppo() && Build.VERSION.SDK_INT >= 21 || Build.VERSION.SDK_INT >= 23;
    }

    public final void transparentStatusBar(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (OSUtils.INSTANCE.isMiui() || OSUtils.INSTANCE.isFlyme()) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.transparentStatusBarAbove21(window);
            } else if (Build.VERSION.SDK_INT >= 19) {
                window.addFlags(0x4000000);
            }
        } else if (OSUtils.INSTANCE.isOppo() && Build.VERSION.SDK_INT >= 21) {
            this.transparentStatusBarAbove21(window);
        } else if (Build.VERSION.SDK_INT >= 23) {
            this.transparentStatusBarAbove21(window);
        }
    }

    @TargetApi(value=21)
    private final void transparentStatusBarAbove21(Window window) {
        window.addFlags(Integer.MIN_VALUE);
        window.clearFlags(0x4000000);
        View view = window.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
        view.setSystemUiVisibility(1280);
        window.setStatusBarColor(0);
    }

    public final void setLightMode(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (OSUtils.INSTANCE.isMiui()) {
            this.setMIUIStatusBarDarkMode(window, false);
        } else if (OSUtils.INSTANCE.isFlyme()) {
            this.setFlymeStatusBarDarkMode(window, false);
        } else if (OSUtils.INSTANCE.isOppo()) {
            this.setOppoStatusBarDarkMode(window, false);
        } else {
            this.setStatusBarDarkMode(window, false);
        }
    }

    public final void setDarkMode(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (OSUtils.INSTANCE.isMiui()) {
            this.setMIUIStatusBarDarkMode(window, true);
        } else if (OSUtils.INSTANCE.isFlyme()) {
            this.setFlymeStatusBarDarkMode(window, true);
        } else if (OSUtils.INSTANCE.isOppo()) {
            this.setOppoStatusBarDarkMode(window, true);
        } else {
            this.setStatusBarDarkMode(window, true);
        }
    }

    private final void setStatusBarDarkMode(Window window, boolean darkMode) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (darkMode) {
                View view = window.getDecorView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
                view.setSystemUiVisibility(9216);
            } else {
                View view = window.getDecorView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
                view.setSystemUiVisibility(1024);
            }
        }
    }

    @SuppressLint(value={"PrivateApi"})
    private final void setMIUIStatusBarDarkMode(Window window, boolean darkMode) {
        if (Build.VERSION.SDK_INT < 23) {
            Class<?> clazz = window.getClass();
            try {
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                int darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                extraFlagField.invoke((Object)window, darkMode ? darkModeFlag : 0, darkModeFlag);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setStatusBarDarkMode(window, darkMode);
    }

    private final void setFlymeStatusBarDarkMode(Window window, boolean darkMode) {
        FlymeStatusBar.INSTANCE.setStatusBarDarkIcon(window, darkMode);
    }

    private final void setOppoStatusBarDarkMode(Window window, boolean darkMode) {
        View view = window.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
        int vis = view.getSystemUiVisibility();
        if (Build.VERSION.SDK_INT >= 23) {
            vis = darkMode ? vis | 0x2000 : vis & ~8192;
        } else if (Build.VERSION.SDK_INT >= 21) {
            vis = darkMode ? vis | 0x10 : vis & ~16;
        }
        View view2 = window.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"window.decorView");
        view2.setSystemUiVisibility(vis);
    }

    public final void setStatusBarColor(@NotNull Window window, @ColorInt int color, int alpha) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (Build.VERSION.SDK_INT >= 21) {
            window.setStatusBarColor(this.calculateStatusColor(color, alpha));
        }
    }

    private final int calculateStatusColor(@ColorInt int color, int alpha) {
        if (alpha == 0) {
            return color;
        }
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public final int getStatusBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(resourceId);
    }

    public final int getNavigationBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int resourceId = context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(resourceId);
    }

    public final boolean checkDeviceHasNavigationBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean hasNavigationBar = false;
        Resources rs = context.getResources();
        int id2 = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id2 > 0) {
            hasNavigationBar = rs.getBoolean(id2);
        }
        try {
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Method m = systemPropertiesClass.getMethod("get", String.class);
            Object object = m.invoke(systemPropertiesClass, "qemu.hw.mainkeys");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String navBarOverride = (String)object;
            if (Intrinsics.areEqual((Object)"1", (Object)navBarOverride)) {
                hasNavigationBar = false;
            } else if (Intrinsics.areEqual((Object)"0", (Object)navBarOverride)) {
                hasNavigationBar = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasNavigationBar;
    }

    private StatusBarUtils() {
    }

    static {
        StatusBarUtils statusBarUtils;
        INSTANCE = statusBarUtils = new StatusBarUtils();
    }
}

