/*
 * Decompiled with CFR 0.152.
 */
package com.github.underscore;

import com.github.underscore.BiConsumer;
import com.github.underscore.BiFunction;
import com.github.underscore.BinaryOperator;
import com.github.underscore.Consumer;
import com.github.underscore.Function;
import com.github.underscore.MemoizeFunction;
import com.github.underscore.Optional;
import com.github.underscore.Predicate;
import com.github.underscore.PredicateIndexed;
import com.github.underscore.Supplier;
import com.github.underscore.Template;
import com.github.underscore.Tuple;
import com.github.underscore.UnaryOperator;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class U<T> {
    private static final Map<String, Function<String, String>> FUNCTIONS = U.newLinkedHashMap();
    private static final Map<String, String> TEMPLATE_SETTINGS = new HashMap<String, String>();
    private static final int MIN_PASSWORD_LENGTH_8 = 8;
    private static final long CAPACITY_SIZE_5 = 5L;
    private static final long CAPACITY_COEFF_2 = 2L;
    private static final long CAPACITY_SIZE_16 = 16L;
    private static final AtomicInteger UNIQUE_ID = new AtomicInteger(0);
    private static final String ALL_SYMBOLS = "([\\s\\S]+?)";
    private static final String EVALUATE = "evaluate";
    private static final String INTERPOLATE = "interpolate";
    private static final String ESCAPE = "escape";
    private static final String S_Q = "\\s*\\Q";
    private static final String E_S = "\\E\\s*";
    private static final Pattern FORMAT_PATTERN = Pattern.compile("\\{\\s*(\\d*)\\s*\\}");
    private static final Map<Character, String> ESCAPES = new HashMap<Character, String>();
    private final Iterable<T> iterable;
    private final Optional<String> string;

    public U(Iterable<T> iterable) {
        this.iterable = iterable;
        this.string = Optional.absent();
    }

    public U(String string) {
        this.iterable = null;
        this.string = Optional.of(string);
    }

    private static void setTemplateKey(Map<String, String> templateSettings, String key) {
        if (templateSettings.containsKey(key) && templateSettings.get(key).contains(ALL_SYMBOLS)) {
            TEMPLATE_SETTINGS.put(key, templateSettings.get(key));
        }
    }

    public static void templateSettings(Map<String, String> templateSettings) {
        U.setTemplateKey(templateSettings, EVALUATE);
        U.setTemplateKey(templateSettings, INTERPOLATE);
        U.setTemplateKey(templateSettings, ESCAPE);
    }

    public static <K, V> Function<Map<K, V>, V> iteratee(final K key) {
        return new Function<Map<K, V>, V>(){

            @Override
            public V apply(Map<K, V> item) {
                return item.get(key);
            }
        };
    }

    public static <T> void each(Iterable<T> iterable, Consumer<? super T> func) {
        for (T element : iterable) {
            func.accept(element);
        }
    }

    public static <T> void eachIndexed(Iterable<T> iterable, BiConsumer<Integer, ? super T> func) {
        int index = 0;
        for (T element : iterable) {
            func.accept(index, element);
            ++index;
        }
    }

    public void each(Consumer<? super T> func) {
        U.each(this.iterable, func);
    }

    public static <T> void eachRight(Iterable<T> iterable, Consumer<? super T> func) {
        U.each(U.reverse(iterable), func);
    }

    public void eachRight(Consumer<? super T> func) {
        U.eachRight(this.iterable, func);
    }

    public static <T> void forEach(Iterable<T> iterable, Consumer<? super T> func) {
        U.each(iterable, func);
    }

    public static <T> void forEachIndexed(Iterable<T> iterable, BiConsumer<Integer, ? super T> func) {
        U.eachIndexed(iterable, func);
    }

    public void forEach(Consumer<? super T> func) {
        U.each(this.iterable, func);
    }

    public void forEachIndexed(BiConsumer<Integer, ? super T> func) {
        U.eachIndexed(this.iterable, func);
    }

    public static <T> void forEachRight(Iterable<T> iterable, Consumer<? super T> func) {
        U.eachRight(iterable, func);
    }

    public void forEachRight(Consumer<? super T> func) {
        U.eachRight(this.iterable, func);
    }

    public static <T, E> List<T> map(List<E> list, Function<? super E, T> func) {
        List<T> transformed = U.newArrayListWithExpectedSize(list.size());
        for (E element : list) {
            transformed.add(func.apply(element));
        }
        return transformed;
    }

    public <F> List<F> map(Function<? super T, F> func) {
        return U.map(U.newArrayList(this.iterable), func);
    }

    public static <T> List<T> map(int[] array, Function<? super Integer, T> func) {
        List<T> transformed = U.newArrayListWithExpectedSize(array.length);
        for (int element : array) {
            transformed.add(func.apply(element));
        }
        return transformed;
    }

    public static <T, E> Set<T> map(Set<E> set, Function<? super E, T> func) {
        Set<T> transformed = U.newLinkedHashSetWithExpectedSize(set.size());
        for (E element : set) {
            transformed.add(func.apply(element));
        }
        return transformed;
    }

    public static <T, E> List<T> mapIndexed(List<E> list, BiFunction<Integer, ? super E, T> func) {
        List<T> transformed = U.newArrayListWithExpectedSize(list.size());
        int index = 0;
        for (E element : list) {
            transformed.add(func.apply(index, element));
            ++index;
        }
        return transformed;
    }

    public static <T> List<T> replace(Iterable<T> iter, Predicate<T> pred, T value) {
        List<T> list = U.newArrayList(iter);
        if (pred == null) {
            return list;
        }
        ListIterator<T> itera = list.listIterator();
        while (itera.hasNext()) {
            if (!pred.test(itera.next())) continue;
            itera.set(value);
        }
        return list;
    }

    public List<T> replace(Predicate<T> pred, T value) {
        return U.replace(this.value(), pred, value);
    }

    public static <T> List<T> replaceIndexed(Iterable<T> iter, PredicateIndexed<T> pred, T value) {
        List<T> list = U.newArrayList(iter);
        if (pred == null) {
            return list;
        }
        ListIterator<T> itera = list.listIterator();
        int index = 0;
        while (itera.hasNext()) {
            if (pred.test(index, itera.next())) {
                itera.set(value);
            }
            ++index;
        }
        return list;
    }

    public List<T> replaceIndexed(PredicateIndexed<T> pred, T value) {
        return U.replaceIndexed(this.value(), pred, value);
    }

    public <F> List<F> mapIndexed(BiFunction<Integer, ? super T, F> func) {
        return U.mapIndexed(U.newArrayList(this.iterable), func);
    }

    public static <T, E> List<T> collect(List<E> list, Function<? super E, T> func) {
        return U.map(list, func);
    }

    public static <T, E> Set<T> collect(Set<E> set, Function<? super E, T> func) {
        return U.map(set, func);
    }

    public static <T, E> E reduce(Iterable<T> iterable, BiFunction<E, T, E> func, E zeroElem) {
        E accum = zeroElem;
        for (T element : iterable) {
            accum = func.apply(accum, element);
        }
        return accum;
    }

    public static <T> Optional<T> reduce(Iterable<T> iterable, BinaryOperator<T> func) {
        boolean foundAny = false;
        Object accum = null;
        for (T element : iterable) {
            if (foundAny) {
                accum = func.apply(accum, element);
                continue;
            }
            foundAny = true;
            accum = element;
        }
        return foundAny ? Optional.of(accum) : Optional.absent();
    }

    public static <E> E reduce(int[] array, BiFunction<E, ? super Integer, E> func, E zeroElem) {
        E accum = zeroElem;
        for (int element : array) {
            accum = func.apply(accum, element);
        }
        return accum;
    }

    public static <T, E> E reduce(T[] array, BiFunction<E, T, E> func, E zeroElem) {
        E accum = zeroElem;
        for (T element : array) {
            accum = func.apply(accum, element);
        }
        return accum;
    }

    public static <T, E> E foldl(Iterable<T> iterable, BiFunction<E, T, E> func, E zeroElem) {
        return U.reduce(iterable, func, zeroElem);
    }

    public static <T, E> E inject(Iterable<T> iterable, BiFunction<E, T, E> func, E zeroElem) {
        return U.reduce(iterable, func, zeroElem);
    }

    public static <T, E> E reduceRight(Iterable<T> iterable, BiFunction<E, T, E> func, E zeroElem) {
        return U.reduce(U.reverse(iterable), func, zeroElem);
    }

    public static <T> Optional<T> reduceRight(Iterable<T> iterable, BinaryOperator<T> func) {
        return U.reduce(U.reverse(iterable), func);
    }

    public static <E> E reduceRight(int[] array, BiFunction<E, ? super Integer, E> func, E zeroElem) {
        E accum = zeroElem;
        for (Integer element : U.reverse(array)) {
            accum = func.apply(accum, element);
        }
        return accum;
    }

    public static <T, E> E reduceRight(T[] array, BiFunction<E, T, E> func, E zeroElem) {
        return U.reduce(U.reverse(array), func, zeroElem);
    }

    public static <T, E> E foldr(Iterable<T> iterable, BiFunction<E, T, E> func, E zeroElem) {
        return U.reduceRight(iterable, func, zeroElem);
    }

    public static <E> Optional<E> find(Iterable<E> iterable, Predicate<E> pred) {
        for (E element : iterable) {
            if (!pred.test(element)) continue;
            return Optional.of(element);
        }
        return Optional.absent();
    }

    public static <E> Optional<E> detect(Iterable<E> iterable, Predicate<E> pred) {
        return U.find(iterable, pred);
    }

    public static <E> Optional<E> findLast(Iterable<E> iterable, Predicate<E> pred) {
        return U.find(U.reverse(iterable), pred);
    }

    public static <E> List<E> filter(Iterable<E> iterable, Predicate<E> pred) {
        List filtered = U.newArrayList();
        for (E element : iterable) {
            if (!pred.test(element)) continue;
            filtered.add(element);
        }
        return filtered;
    }

    public static <E> List<E> filter(List<E> list, Predicate<E> pred) {
        List filtered = U.newArrayList();
        for (E element : list) {
            if (!pred.test(element)) continue;
            filtered.add(element);
        }
        return filtered;
    }

    public List<T> filter(Predicate<T> pred) {
        List<T> filtered = U.newArrayList();
        for (T element : this.value()) {
            if (!pred.test(element)) continue;
            filtered.add(element);
        }
        return filtered;
    }

    public static <E> List<E> filterIndexed(List<E> list, PredicateIndexed<E> pred) {
        List filtered = U.newArrayList();
        int index = 0;
        for (E element : list) {
            if (pred.test(index, element)) {
                filtered.add(element);
            }
            ++index;
        }
        return filtered;
    }

    public static <E> Set<E> filter(Set<E> set, Predicate<E> pred) {
        Set filtered = U.newLinkedHashSet();
        for (E element : set) {
            if (!pred.test(element)) continue;
            filtered.add(element);
        }
        return filtered;
    }

    public static <E> List<E> select(List<E> list, Predicate<E> pred) {
        return U.filter(list, pred);
    }

    public static <E> Set<E> select(Set<E> set, Predicate<E> pred) {
        return U.filter(set, pred);
    }

    public static <E> List<E> reject(List<E> list, final Predicate<E> pred) {
        return U.filter(list, new Predicate<E>(){

            @Override
            public boolean test(E input) {
                return !pred.test(input);
            }
        });
    }

    public List<T> reject(final Predicate<T> pred) {
        return this.filter(new Predicate<T>(){

            @Override
            public boolean test(T input) {
                return !pred.test(input);
            }
        });
    }

    public static <E> List<E> rejectIndexed(List<E> list, final PredicateIndexed<E> pred) {
        return U.filterIndexed(list, new PredicateIndexed<E>(){

            @Override
            public boolean test(int index, E input) {
                return !pred.test(index, input);
            }
        });
    }

    public static <E> Set<E> reject(Set<E> set, final Predicate<E> pred) {
        return U.filter(set, new Predicate<E>(){

            @Override
            public boolean test(E input) {
                return !pred.test(input);
            }
        });
    }

    public static <E> List<E> filterFalse(List<E> list, Predicate<E> pred) {
        return U.reject(list, pred);
    }

    public List<T> filterFalse(Predicate<T> pred) {
        return this.reject(pred);
    }

    public static <E> Set<E> filterFalse(Set<E> set, Predicate<E> pred) {
        return U.reject(set, pred);
    }

    public static <E> boolean every(Iterable<E> iterable, Predicate<E> pred) {
        for (E item : iterable) {
            if (pred.test(item)) continue;
            return false;
        }
        return true;
    }

    public boolean every(Predicate<T> pred) {
        return U.every(this.iterable, pred);
    }

    public static <E> boolean all(Iterable<E> iterable, Predicate<E> pred) {
        return U.every(iterable, pred);
    }

    public boolean all(Predicate<T> pred) {
        return U.every(this.iterable, pred);
    }

    public static <E> boolean some(Iterable<E> iterable, Predicate<E> pred) {
        return U.find(iterable, pred).isPresent();
    }

    public boolean some(Predicate<T> pred) {
        return U.some(this.iterable, pred);
    }

    public static <E> boolean any(Iterable<E> iterable, Predicate<E> pred) {
        return U.some(iterable, pred);
    }

    public boolean any(Predicate<T> pred) {
        return U.some(this.iterable, pred);
    }

    public static <E> int count(Iterable<E> iterable, Predicate<E> pred) {
        int result = 0;
        for (E item : iterable) {
            if (!pred.test(item)) continue;
            ++result;
        }
        return result;
    }

    public int count(Predicate<T> pred) {
        return U.count(this.iterable, pred);
    }

    public static <E> boolean contains(Iterable<E> iterable, final E elem) {
        return U.some(iterable, new Predicate<E>(){

            @Override
            public boolean test(E e) {
                return elem == null ? e == null : elem.equals(e);
            }
        });
    }

    public boolean contains(T elem) {
        return U.contains(this.iterable, elem);
    }

    public static <E> boolean containsWith(Iterable<E> iterable, final E elem) {
        return U.some(iterable, new Predicate<E>(){

            @Override
            public boolean test(E e) {
                return elem == null ? e == null : String.valueOf(e).contains(String.valueOf(elem));
            }
        });
    }

    public boolean containsWith(T elem) {
        return U.containsWith(this.iterable, elem);
    }

    public static <E> boolean contains(Iterable<E> iterable, E elem, int fromIndex) {
        List<E> list = U.newArrayList(iterable);
        return U.contains(list.subList(fromIndex, list.size()), elem);
    }

    public boolean containsAtLeast(T value, int count) {
        return U.containsAtLeast(this.iterable, value, count);
    }

    public boolean containsAtMost(T value, int count) {
        return U.containsAtMost(this.iterable, value, count);
    }

    public static <E> boolean containsAtLeast(Iterable<E> iterable, E value, int count) {
        int foundItems = 0;
        for (E element : iterable) {
            if (element == null ? value == null : element.equals(value)) {
                ++foundItems;
            }
            if (foundItems < count) continue;
            break;
        }
        return foundItems >= count;
    }

    public static <E> boolean containsAtMost(Iterable<E> iterable, E value, int count) {
        int foundItems = U.size(iterable);
        for (E element : iterable) {
            if (!(element != null ? element.equals(value) : value == null)) {
                --foundItems;
            }
            if (foundItems > count) continue;
            break;
        }
        return foundItems <= count;
    }

    public static <E> boolean include(Iterable<E> iterable, E elem) {
        return U.contains(iterable, elem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <E> List<E> invoke(Iterable<E> iterable, String methodName, List<Object> args) {
        List result = U.newArrayList();
        List<Class> argTypes = U.map(args, new Function<Object, Class<?>>(){

            @Override
            public Class<?> apply(Object input) {
                return input.getClass();
            }
        });
        try {
            Method method = iterable.iterator().next().getClass().getMethod(methodName, argTypes.toArray(new Class[0]));
            for (E arg : iterable) {
                try {
                    result.add(method.invoke(arg, args.toArray(new Object[0])));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                    return result;
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public List<T> invoke(String methodName, List<Object> args) {
        return U.invoke(this.iterable, methodName, args);
    }

    public static <E> List<E> invoke(Iterable<E> iterable, String methodName) {
        return U.invoke(iterable, methodName, Collections.<Object>emptyList());
    }

    public List<T> invoke(String methodName) {
        return U.invoke(this.iterable, methodName);
    }

    public static <E> List<Object> pluck(List<E> list, final String propertyName) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return U.map(list, new Function<E, Object>(){

            @Override
            public Object apply(E elem) {
                try {
                    return elem.getClass().getField(propertyName).get(elem);
                }
                catch (Exception e) {
                    try {
                        return elem.getClass().getMethod(propertyName, new Class[0]).invoke(elem, new Object[0]);
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
            }
        });
    }

    public List<Object> pluck(String propertyName) {
        return U.pluck(U.newArrayList(this.iterable), propertyName);
    }

    public static <E> Set<Object> pluck(Set<E> set, final String propertyName) {
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        return U.map(set, new Function<E, Object>(){

            @Override
            public Object apply(E elem) {
                try {
                    return elem.getClass().getField(propertyName).get(elem);
                }
                catch (Exception e) {
                    try {
                        return elem.getClass().getMethod(propertyName, new Class[0]).invoke(elem, new Object[0]);
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
            }
        });
    }

    public static <T, E> List<E> where(List<E> list, List<Tuple<String, T>> properties) {
        return U.filter(list, new WherePredicate(properties));
    }

    public <E> List<T> where(List<Tuple<String, E>> properties) {
        return U.where(U.newArrayList(this.iterable), properties);
    }

    public static <T, E> Set<E> where(Set<E> set, List<Tuple<String, T>> properties) {
        return U.filter(set, new WherePredicate(properties));
    }

    public static <T, E> Optional<E> findWhere(Iterable<E> iterable, List<Tuple<String, T>> properties) {
        return U.find(iterable, new WherePredicate(properties));
    }

    public <E> Optional<T> findWhere(List<Tuple<String, E>> properties) {
        return U.findWhere(this.iterable, properties);
    }

    public static <E extends Comparable<? super E>> E max(Collection<E> collection) {
        return (E)((Comparable)Collections.max(collection));
    }

    public T max() {
        return (T)U.max((Collection)this.iterable);
    }

    public static <E, F extends Comparable> E max(Collection<E> collection, final Function<E, F> func) {
        return Collections.max(collection, new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return ((Comparable)func.apply(o1)).compareTo(func.apply(o2));
            }
        });
    }

    public <F extends Comparable<? super F>> T max(Function<T, F> func) {
        return U.max((Collection)this.iterable, func);
    }

    public static <E extends Comparable<? super E>> E min(Collection<E> collection) {
        return (E)((Comparable)Collections.min(collection));
    }

    public T min() {
        return (T)U.min((Collection)this.iterable);
    }

    public static <E, F extends Comparable> E min(Collection<E> collection, final Function<E, F> func) {
        return Collections.min(collection, new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return ((Comparable)func.apply(o1)).compareTo(func.apply(o2));
            }
        });
    }

    public <F extends Comparable<? super F>> T min(Function<T, F> func) {
        return U.min((Collection)this.iterable, func);
    }

    public static <E> List<E> shuffle(Iterable<E> iterable) {
        List<E> shuffled = U.newArrayList(iterable);
        Collections.shuffle(shuffled);
        return shuffled;
    }

    public List<T> shuffle() {
        return U.shuffle(this.iterable);
    }

    public static <E> E sample(Iterable<E> iterable) {
        return U.newArrayList(iterable).get(new SecureRandom().nextInt(U.size(iterable)));
    }

    public T sample() {
        return U.sample(this.iterable);
    }

    public static <E> Set<E> sample(List<E> list, int howMany) {
        int size = Math.min(howMany, list.size());
        Set samples = U.newLinkedHashSetWithExpectedSize(size);
        while (samples.size() < size) {
            E sample = U.sample(list);
            samples.add(sample);
        }
        return samples;
    }

    public static <T extends Comparable<? super T>> List<T> sortWith(Iterable<T> iterable, Comparator<T> comparator) {
        List<T> sortedList = U.newArrayList(iterable);
        Collections.sort(sortedList, comparator);
        return sortedList;
    }

    public <E extends Comparable<? super E>> List<E> sortWith(Comparator<E> comparator) {
        return U.sortWith(this.iterable, comparator);
    }

    public static <E, T extends Comparable<? super T>> List<E> sortBy(Iterable<E> iterable, final Function<E, T> func) {
        List<E> sortedList = U.newArrayList(iterable);
        Collections.sort(sortedList, new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                return ((Comparable)func.apply(o1)).compareTo(func.apply(o2));
            }
        });
        return sortedList;
    }

    public <E, V extends Comparable<? super V>> List<E> sortBy(Function<E, V> func) {
        return U.sortBy(this.iterable, func);
    }

    public static <K, V extends Comparable<? super V>> List<Map<K, V>> sortBy(Iterable<Map<K, V>> iterable, final K key) {
        List<Map<K, V>> sortedList = U.newArrayList(iterable);
        Collections.sort(sortedList, new Comparator<Map<K, V>>(){

            @Override
            public int compare(Map<K, V> o1, Map<K, V> o2) {
                return ((Comparable)o1.get(key)).compareTo(o2.get(key));
            }
        });
        return sortedList;
    }

    public static <K, E> Map<K, List<E>> groupBy(Iterable<E> iterable, Function<E, K> func) {
        Map<K, E> retVal = U.newLinkedHashMap();
        for (E e : iterable) {
            K key = func.apply(e);
            List val = retVal.containsKey(key) ? (List)retVal.get(key) : U.newArrayList();
            val.add(e);
            retVal.put(key, val);
        }
        return retVal;
    }

    public <K, E> Map<K, List<E>> groupBy(Function<E, K> func) {
        return U.groupBy(this.iterable, func);
    }

    public static <K, E> Map<K, Optional<E>> groupBy(Iterable<E> iterable, Function<E, K> func, BinaryOperator<E> binaryOperator) {
        Map<K, E> retVal = U.newLinkedHashMap();
        for (Map.Entry<K, List<E>> entry : U.groupBy(iterable, func).entrySet()) {
            retVal.put(entry.getKey(), U.reduce((Iterable)entry.getValue(), binaryOperator));
        }
        return retVal;
    }

    public <K, E> Map<K, Optional<E>> groupBy(Function<E, K> func, BinaryOperator<E> binaryOperator) {
        return U.groupBy(this.iterable, func, binaryOperator);
    }

    public static <K, E> Map<K, List<E>> indexBy(Iterable<E> iterable, final String property) {
        return U.groupBy(iterable, new Function<E, K>(){

            @Override
            public K apply(E elem) {
                try {
                    return elem.getClass().getField(property).get(elem);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    public <K, E> Map<K, List<E>> indexBy(String property) {
        return U.indexBy(this.iterable, property);
    }

    public static <K, E> Map<K, Integer> countBy(Iterable<E> iterable, Function<E, K> func) {
        Map<K, E> retVal = U.newLinkedHashMap();
        for (E e : iterable) {
            K key = func.apply(e);
            if (retVal.containsKey(key)) {
                retVal.put(key, 1 + (Integer)retVal.get(key));
                continue;
            }
            retVal.put(key, 1);
        }
        return retVal;
    }

    public static <K> Map<K, Integer> countBy(Iterable<K> iterable) {
        Map retVal = U.newLinkedHashMap();
        for (K key : iterable) {
            if (retVal.containsKey(key)) {
                retVal.put(key, 1 + (Integer)retVal.get(key));
                continue;
            }
            retVal.put(key, 1);
        }
        return retVal;
    }

    public <K, E> Map<K, Integer> countBy(Function<E, K> func) {
        return U.countBy(this.iterable, func);
    }

    public <K> Map<K, Integer> countBy() {
        return U.countBy(this.iterable);
    }

    public static <E> E[] toArray(Iterable<E> iterable) {
        return U.newArrayList(iterable).toArray();
    }

    public <E> E[] toArray() {
        return U.toArray(this.iterable);
    }

    public static <K, V> Map<K, V> toMap(Iterable<Map.Entry<K, V>> iterable) {
        Map result = U.newLinkedHashMap();
        for (Map.Entry<K, V> entry : iterable) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public <K, V> Map<K, V> toMap() {
        return U.toMap(this.iterable);
    }

    public static <K, V> Map<K, V> toMap(List<Tuple<K, V>> tuples) {
        Map result = U.newLinkedHashMap();
        for (Tuple<K, V> entry : tuples) {
            result.put(entry.fst(), entry.snd());
        }
        return result;
    }

    public Map<T, Integer> toCardinalityMap() {
        return U.toCardinalityMap(this.iterable);
    }

    public static <K> Map<K, Integer> toCardinalityMap(Iterable<K> iterable) {
        Iterator<K> iterator = iterable.iterator();
        Map result = U.newLinkedHashMap();
        while (iterator.hasNext()) {
            K item = iterator.next();
            if (result.containsKey(item)) {
                result.put(item, (Integer)result.get(item) + 1);
                continue;
            }
            result.put(item, 1);
        }
        return result;
    }

    public static int size(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        Iterator<?> iterator = iterable.iterator();
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    public int size() {
        return U.size(this.iterable);
    }

    public static <E> int size(E ... array) {
        return array.length;
    }

    public static <E> List<List<E>> partition(Iterable<E> iterable, Predicate<E> pred) {
        List retVal1 = U.newArrayList();
        List retVal2 = U.newArrayList();
        for (E e : iterable) {
            if (pred.test(e)) {
                retVal1.add(e);
                continue;
            }
            retVal2.add(e);
        }
        return Arrays.asList(retVal1, retVal2);
    }

    public static <E> List<E>[] partition(E[] iterable, Predicate<E> pred) {
        return U.partition(Arrays.asList(iterable), pred).toArray(new ArrayList[0]);
    }

    public T singleOrNull() {
        return U.singleOrNull(this.iterable);
    }

    public T singleOrNull(Predicate<T> pred) {
        return U.singleOrNull(this.iterable, pred);
    }

    public static <E> E singleOrNull(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        E result = iterator.next();
        if (iterator.hasNext()) {
            result = null;
        }
        return result;
    }

    public static <E> E singleOrNull(Iterable<E> iterable, Predicate<E> pred) {
        return U.singleOrNull(U.filter(iterable, pred));
    }

    public static <E> E first(Iterable<E> iterable) {
        return iterable.iterator().next();
    }

    public static <E> E first(E ... array) {
        return array[0];
    }

    public static <E> List<E> first(List<E> list, int n) {
        return list.subList(0, Math.min(n < 0 ? 0 : n, list.size()));
    }

    public T first() {
        return U.first(this.iterable);
    }

    public List<T> first(int n) {
        return U.first(U.newArrayList(this.iterable), n);
    }

    public static <E> E first(Iterable<E> iterable, Predicate<E> pred) {
        return U.filter(U.newArrayList(iterable), pred).iterator().next();
    }

    public static <E> List<E> first(Iterable<E> iterable, Predicate<E> pred, int n) {
        List<E> list = U.filter(U.newArrayList(iterable), pred);
        return list.subList(0, Math.min(n < 0 ? 0 : n, list.size()));
    }

    public T first(Predicate<T> pred) {
        return U.first(U.newArrayList(this.iterable), pred);
    }

    public List<T> first(Predicate<T> pred, int n) {
        return U.first(U.newArrayList(this.iterable), pred, n);
    }

    public static <E> E firstOrNull(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        return iterator.hasNext() ? (E)iterator.next() : null;
    }

    public T firstOrNull() {
        return U.firstOrNull(this.iterable);
    }

    public static <E> E firstOrNull(Iterable<E> iterable, Predicate<E> pred) {
        Iterator<E> iterator = U.filter(U.newArrayList(iterable), pred).iterator();
        return iterator.hasNext() ? (E)iterator.next() : null;
    }

    public T firstOrNull(Predicate<T> pred) {
        return U.firstOrNull(this.iterable, pred);
    }

    public static <E> E head(Iterable<E> iterable) {
        return U.first(iterable);
    }

    public static <E> E head(E ... array) {
        return U.first(array);
    }

    public static <E> List<E> head(List<E> list, int n) {
        return U.first(list, n);
    }

    public T head() {
        return this.first();
    }

    public List<T> head(int n) {
        return this.first(n);
    }

    public static <E> List<E> initial(List<E> list) {
        return U.initial(list, 1);
    }

    public static <E> List<E> initial(List<E> list, int n) {
        return list.subList(0, Math.max(0, list.size() - n));
    }

    public static <E> E[] initial(E ... array) {
        return U.initial(array, 1);
    }

    public static <E> E[] initial(E[] array, int n) {
        return Arrays.copyOf(array, array.length - n);
    }

    public List<T> initial() {
        return U.initial((List)this.iterable, 1);
    }

    public List<T> initial(int n) {
        return U.initial((List)this.iterable, n);
    }

    public static <E> E last(E ... array) {
        return array[array.length - 1];
    }

    public static <E> E last(List<E> list) {
        return list.get(list.size() - 1);
    }

    public static <E> List<E> last(List<E> list, int n) {
        return list.subList(Math.max(0, list.size() - n), list.size());
    }

    public T last() {
        return (T)U.last((List)this.iterable);
    }

    public List<T> last(int n) {
        return U.last((List)this.iterable, n);
    }

    public static <E> E last(List<E> list, Predicate<E> pred) {
        List<E> filteredList = U.filter(list, pred);
        return filteredList.get(filteredList.size() - 1);
    }

    public T last(Predicate<T> pred) {
        return U.last((List)this.iterable, pred);
    }

    public static <E> E lastOrNull(List<E> list) {
        return list.isEmpty() ? null : (E)list.get(list.size() - 1);
    }

    public T lastOrNull() {
        return (T)U.lastOrNull((List)this.iterable);
    }

    public static <E> E lastOrNull(List<E> list, Predicate<E> pred) {
        List<E> filteredList = U.filter(list, pred);
        return filteredList.isEmpty() ? null : (E)filteredList.get(filteredList.size() - 1);
    }

    public T lastOrNull(Predicate<T> pred) {
        return U.lastOrNull((List)this.iterable, pred);
    }

    public static <E> List<E> rest(List<E> list) {
        return U.rest(list, 1);
    }

    public static <E> List<E> rest(List<E> list, int n) {
        return list.subList(Math.min(n, list.size()), list.size());
    }

    public static <E> E[] rest(E ... array) {
        return U.rest(array, 1);
    }

    public static <E> E[] rest(E[] array, int n) {
        return U.rest(Arrays.asList(array), n).toArray();
    }

    public List<T> rest() {
        return U.rest((List)this.iterable);
    }

    public List<T> rest(int n) {
        return U.rest((List)this.iterable, n);
    }

    public static <E> List<E> tail(List<E> list) {
        return U.rest(list);
    }

    public static <E> List<E> tail(List<E> list, int n) {
        return U.rest(list, n);
    }

    public static <E> E[] tail(E ... array) {
        return U.rest(array);
    }

    public static <E> E[] tail(E[] array, int n) {
        return U.rest(array, n);
    }

    public List<T> tail() {
        return this.rest();
    }

    public List<T> tail(int n) {
        return this.rest(n);
    }

    public static <E> List<E> drop(List<E> list) {
        return U.rest(list);
    }

    public static <E> List<E> drop(List<E> list, int n) {
        return U.rest(list, n);
    }

    public static <E> E[] drop(E ... array) {
        return U.rest(array);
    }

    public static <E> E[] drop(E[] array, int n) {
        return U.rest(array, n);
    }

    public static <E> List<E> compact(List<E> list) {
        return U.filter(list, new Predicate<E>(){

            @Override
            public boolean test(E arg) {
                return !String.valueOf(arg).equals("null") && !String.valueOf(arg).equals("0") && !String.valueOf(arg).equals("false") && !String.valueOf(arg).equals("");
            }
        });
    }

    public static <E> E[] compact(E ... array) {
        return U.compact(Arrays.asList(array)).toArray();
    }

    public static <E> List<E> compact(List<E> list, final E falsyValue) {
        return U.filter(list, new Predicate<E>(){

            @Override
            public boolean test(E arg) {
                return !(arg != null ? arg.equals(falsyValue) : falsyValue == null);
            }
        });
    }

    public static <E> E[] compact(E[] array, E falsyValue) {
        return U.compact(Arrays.asList(array), falsyValue).toArray();
    }

    public List<T> compact() {
        return U.compact((List)this.iterable);
    }

    public List<T> compact(T falsyValue) {
        return U.compact((List)this.iterable, falsyValue);
    }

    public static <E> List<E> flatten(List<?> list) {
        List flattened = U.newArrayList();
        U.flatten(list, flattened, -1);
        return flattened;
    }

    public static <E> List<E> flatten(List<?> list, boolean shallow) {
        List flattened = U.newArrayList();
        U.flatten(list, flattened, shallow ? 1 : -1);
        return flattened;
    }

    private static <E> void flatten(List<?> fromTreeList, List<E> toFlatList, int shallowLevel) {
        for (Object item : fromTreeList) {
            if (item instanceof List && shallowLevel != 0) {
                U.flatten((List)item, toFlatList, shallowLevel - 1);
                continue;
            }
            toFlatList.add(item);
        }
    }

    public List<T> flatten() {
        return U.flatten((List)this.iterable);
    }

    public List<T> flatten(boolean shallow) {
        return U.flatten((List)this.iterable, shallow);
    }

    public static <E> List<E> without(List<E> list, E ... values) {
        final List<E> valuesList = Arrays.asList(values);
        return U.filter(list, new Predicate<E>(){

            @Override
            public boolean test(E elem) {
                return !U.contains(valuesList, elem);
            }
        });
    }

    public static <E> E[] without(E[] array, E ... values) {
        return U.without(Arrays.asList(array), values).toArray();
    }

    public static <E> List<E> uniq(List<E> list) {
        return U.newArrayList(U.newLinkedHashSet(list));
    }

    public static <E> E[] uniq(E ... array) {
        return U.uniq(Arrays.asList(array)).toArray();
    }

    public static <K, E> Collection<E> uniq(Iterable<E> iterable, Function<E, K> func) {
        Map<K, E> retVal = U.newLinkedHashMap();
        for (E e : iterable) {
            K key = func.apply(e);
            retVal.put(key, e);
        }
        return retVal.values();
    }

    public static <K, E> E[] uniq(E[] array, Function<E, K> func) {
        return U.uniq(Arrays.asList(array), func).toArray();
    }

    public static <E> List<E> distinct(List<E> list) {
        return U.uniq(list);
    }

    public static <E> E[] distinct(E ... array) {
        return U.uniq(array);
    }

    public static <K, E> Collection<E> distinctBy(Iterable<E> iterable, Function<E, K> func) {
        return U.uniq(iterable, func);
    }

    public static <K, E> E[] distinctBy(E[] array, Function<E, K> func) {
        return U.uniq(array, func);
    }

    public static <E> List<E> union(List<E> list, List<E> ... lists) {
        Set union = U.newLinkedHashSet();
        union.addAll(list);
        for (List<E> localList : lists) {
            union.addAll(localList);
        }
        return U.newArrayList(union);
    }

    public List<T> unionWith(List<T> ... lists) {
        return U.union(U.newArrayList(this.iterable), lists);
    }

    public static <E> E[] union(E[] ... arrays) {
        Set union = U.newLinkedHashSet();
        for (E[] array : arrays) {
            union.addAll(Arrays.asList(array));
        }
        return U.newArrayList(union).toArray();
    }

    public static <E> List<E> intersection(List<E> list1, List<E> list2) {
        List result = U.newArrayList();
        for (E item : list1) {
            if (!list2.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static <E> List<E> intersection(List<E> list, List<E> ... lists) {
        ArrayDeque<List<E>> stack = new ArrayDeque<List<E>>();
        stack.push(list);
        for (List<E> es : lists) {
            stack.push(U.intersection((List)stack.peek(), es));
        }
        return (List)stack.peek();
    }

    public List<T> intersectionWith(List<T> ... lists) {
        return U.intersection(U.newArrayList(this.iterable), lists);
    }

    public static <E> E[] intersection(E[] ... arrays) {
        ArrayDeque<List<E>> stack = new ArrayDeque<List<E>>();
        stack.push(Arrays.asList(arrays[0]));
        for (int index = 1; index < arrays.length; ++index) {
            stack.push(U.intersection((List)stack.peek(), Arrays.asList(arrays[index])));
        }
        return ((List)stack.peek()).toArray();
    }

    public static <E> List<E> difference(List<E> list1, List<E> list2) {
        List result = U.newArrayList();
        for (E item : list1) {
            if (list2.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static <E> List<E> difference(List<E> list, List<E> ... lists) {
        ArrayDeque<List<E>> stack = new ArrayDeque<List<E>>();
        stack.push(list);
        for (List<E> es : lists) {
            stack.push(U.difference((List)stack.peek(), es));
        }
        return (List)stack.peek();
    }

    public List<T> differenceWith(List<T> ... lists) {
        return U.difference(U.newArrayList(this.iterable), lists);
    }

    public static <E> E[] difference(E[] ... arrays) {
        ArrayDeque<List<E>> stack = new ArrayDeque<List<E>>();
        stack.push(Arrays.asList(arrays[0]));
        for (int index = 1; index < arrays.length; ++index) {
            stack.push(U.difference((List)stack.peek(), Arrays.asList(arrays[index])));
        }
        return ((List)stack.peek()).toArray();
    }

    public static <T> List<List<T>> zip(List<T> ... lists) {
        final List<List<T>> zipped = U.newArrayList();
        U.each(Arrays.asList(lists), new Consumer<List<T>>(){

            @Override
            public void accept(List<T> list) {
                int index = 0;
                for (Object elem : list) {
                    List nTuple;
                    List list2 = nTuple = index >= zipped.size() ? U.newArrayList() : (List)zipped.get(index);
                    if (index >= zipped.size()) {
                        zipped.add(nTuple);
                    }
                    ++index;
                    nTuple.add(elem);
                }
            }
        });
        return zipped;
    }

    public static <T> List<List<T>> unzip(List<T> ... lists) {
        List<List<T>> unzipped = U.newArrayList();
        for (int index = 0; index < lists[0].size(); ++index) {
            List<T> nTuple = U.newArrayList();
            for (List<T> list : lists) {
                nTuple.add(list.get(index));
            }
            unzipped.add(nTuple);
        }
        return unzipped;
    }

    public static <K, V> List<Tuple<K, V>> object(List<K> keys, final List<V> values) {
        return U.map(keys, new Function<K, Tuple<K, V>>(){
            private int index;

            @Override
            public Tuple<K, V> apply(K key) {
                return Tuple.create(key, values.get(this.index++));
            }
        });
    }

    public static <E> int findIndex(List<E> list, Predicate<E> pred) {
        for (int index = 0; index < list.size(); ++index) {
            if (!pred.test(list.get(index))) continue;
            return index;
        }
        return -1;
    }

    public static <E> int findIndex(E[] array, Predicate<E> pred) {
        return U.findIndex(Arrays.asList(array), pred);
    }

    public static <E> int findLastIndex(List<E> list, Predicate<E> pred) {
        for (int index = list.size() - 1; index >= 0; --index) {
            if (!pred.test(list.get(index))) continue;
            return index;
        }
        return -1;
    }

    public static <E> int findLastIndex(E[] array, Predicate<E> pred) {
        return U.findLastIndex(Arrays.asList(array), pred);
    }

    public static <E extends Comparable<E>> int binarySearch(Iterable<E> iterable, E key) {
        if (key == null) {
            return U.first(iterable) == null ? 0 : -1;
        }
        int begin = 0;
        int end = U.size(iterable) - 1;
        int numberOfNullValues = 0;
        ArrayList<Comparable> list = new ArrayList<Comparable>();
        for (Comparable item : iterable) {
            if (item == null) {
                ++numberOfNullValues;
                --end;
                continue;
            }
            list.add(item);
        }
        while (begin <= end) {
            int middle = begin + (end - begin) / 2;
            if (key.compareTo(list.get(middle)) < 0) {
                end = middle - 1;
                continue;
            }
            if (key.compareTo(list.get(middle)) > 0) {
                begin = middle + 1;
                continue;
            }
            return middle + numberOfNullValues;
        }
        return -(begin + numberOfNullValues + 1);
    }

    public static <E extends Comparable<E>> int binarySearch(E[] array, E key) {
        return U.binarySearch(Arrays.asList(array), key);
    }

    public static <E extends Comparable<E>> int sortedIndex(List<E> list, E value) {
        int index = 0;
        for (Comparable elem : list) {
            if (elem.compareTo(value) >= 0) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static <E extends Comparable<E>> int sortedIndex(E[] array, E value) {
        return U.sortedIndex(Arrays.asList(array), value);
    }

    public static <E extends Comparable<E>> int sortedIndex(List<E> list, E value, String propertyName) {
        try {
            Field property = value.getClass().getField(propertyName);
            Object valueProperty = property.get(value);
            int index = 0;
            for (Comparable elem : list) {
                if (((Comparable)property.get(elem)).compareTo(valueProperty) >= 0) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <E extends Comparable<E>> int sortedIndex(E[] array, E value, String propertyName) {
        return U.sortedIndex(Arrays.asList(array), value, propertyName);
    }

    public static <E> int indexOf(List<E> list, E value) {
        return list.indexOf(value);
    }

    public static <E> int indexOf(E[] array, E value) {
        return U.indexOf(Arrays.asList(array), value);
    }

    public static <E> int lastIndexOf(List<E> list, E value) {
        return list.lastIndexOf(value);
    }

    public static <E> int lastIndexOf(E[] array, E value) {
        return U.lastIndexOf(Arrays.asList(array), value);
    }

    public static List<Integer> range(int stop) {
        return U.range(0, stop, 1);
    }

    public static List<Integer> range(int start, int stop) {
        return U.range(start, stop, start < stop ? 1 : -1);
    }

    public static List<Integer> range(int start, int stop, int step) {
        List<Integer> list = U.newArrayList();
        if (step == 0) {
            return list;
        }
        if (start < stop) {
            for (int value = start; value < stop; value += step) {
                list.add(value);
            }
        } else {
            for (int value = start; value > stop; value += step) {
                list.add(value);
            }
        }
        return list;
    }

    public static List<Character> range(char stop) {
        return U.range('a', stop, 1);
    }

    public static List<Character> range(char start, char stop) {
        return U.range(start, stop, start < stop ? 1 : -1);
    }

    public static List<Character> range(char start, char stop, int step) {
        List<Character> list = U.newArrayList();
        if (step == 0) {
            return list;
        }
        if (start < stop) {
            char value = start;
            while (value < stop) {
                list.add(Character.valueOf(value));
                value = (char)(value + step);
            }
        } else {
            char value = start;
            while (value > stop) {
                list.add(Character.valueOf(value));
                value = (char)(value + step);
            }
        }
        return list;
    }

    public static <T> List<List<T>> chunk(Iterable<T> iterable, int size) {
        if (size <= 0) {
            return U.newArrayList();
        }
        return U.chunk(iterable, size, size);
    }

    public static <T> List<List<T>> chunk(Iterable<T> iterable, int size, int step) {
        if (step <= 0 || size < 0) {
            return U.newArrayList();
        }
        int length = U.size(iterable);
        ArrayList<List<T>> result = new ArrayList<List<T>>(size == 0 ? size : length / size + 1);
        for (int index = 0; index < length; index += step) {
            result.add(U.newArrayList(iterable).subList(index, Math.min(length, index + size)));
        }
        return result;
    }

    public static <T> List<List<T>> chunkFill(Iterable<T> iterable, int size, T fillValue) {
        if (size <= 0) {
            return U.newArrayList();
        }
        return U.chunkFill(iterable, size, size, fillValue);
    }

    public static <T> List<List<T>> chunkFill(Iterable<T> iterable, int size, int step, T fillValue) {
        int difference;
        if (step <= 0 || size < 0) {
            return U.newArrayList();
        }
        List<List<T>> result = U.chunk(iterable, size, step);
        for (int i = difference = size - result.get(result.size() - 1).size(); 0 < i; --i) {
            result.get(result.size() - 1).add(fillValue);
        }
        return result;
    }

    public List<List<T>> chunk(int size) {
        return U.chunk(this.getIterable(), size, size);
    }

    public List<List<T>> chunk(int size, int step) {
        return U.chunk(this.getIterable(), size, step);
    }

    public List<List<T>> chunkFill(int size, T fillvalue) {
        return U.chunkFill(this.getIterable(), size, size, fillvalue);
    }

    public List<List<T>> chunkFill(int size, int step, T fillvalue) {
        return U.chunkFill(this.getIterable(), size, step, fillvalue);
    }

    public static <T> List<T> cycle(Iterable<T> iterable, int times) {
        int size = Math.abs(U.size(iterable) * times);
        if (size == 0) {
            return U.newArrayList();
        }
        List<T> list = U.newArrayListWithExpectedSize(size);
        if (times > 0) {
            for (int round = 0; round < times; ++round) {
                for (T element : iterable) {
                    list.add(element);
                }
            }
        } else {
            list = U.cycle(U.reverse(iterable), -times);
        }
        return list;
    }

    public List<T> cycle(int times) {
        return U.cycle(this.value(), times);
    }

    public static <T> List<T> repeat(T element, int times) {
        if (times <= 0) {
            return U.newArrayList();
        }
        List<T> result = U.newArrayListWithExpectedSize(times);
        for (int i = 0; i < times; ++i) {
            result.add(element);
        }
        return result;
    }

    public static <T> List<T> interpose(Iterable<T> iterable, T interElement) {
        if (interElement == null) {
            return U.newArrayList(iterable);
        }
        int size = U.size(iterable);
        int index = 0;
        List<T> array = U.newArrayListWithExpectedSize(size * 2);
        for (T elem : iterable) {
            array.add(elem);
            if (index + 1 >= size) continue;
            array.add(interElement);
            ++index;
        }
        return array;
    }

    public static <T> List<T> interposeByList(Iterable<T> iterable, Iterable<T> interIter) {
        if (interIter == null) {
            return U.newArrayList(iterable);
        }
        List<T> interList = U.newArrayList(interIter);
        if (U.isEmpty(interIter)) {
            return U.newArrayList(iterable);
        }
        int size = U.size(iterable);
        List<T> array = U.newArrayListWithExpectedSize(size + interList.size());
        int index = 0;
        for (T element : iterable) {
            array.add(element);
            if (index >= interList.size() || index + 1 >= size) continue;
            array.add(interList.get(index));
            ++index;
        }
        return array;
    }

    public List<T> interpose(T element) {
        return U.interpose(this.value(), element);
    }

    public List<T> interposeByList(Iterable<T> interIter) {
        return U.interposeByList(this.value(), interIter);
    }

    public static <T, F> Function<F, T> bind(final Function<F, T> function) {
        return new Function<F, T>(){

            @Override
            public T apply(F arg) {
                return function.apply(arg);
            }
        };
    }

    public static <T, F> Function<F, T> memoize(final Function<F, T> function) {
        return new MemoizeFunction<F, T>(){

            @Override
            public T calc(F arg) {
                return function.apply(arg);
            }
        };
    }

    public static <T> ScheduledFuture<T> delay(final Supplier<T> function, int delayMilliseconds) {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture future = scheduler.schedule(new Callable<T>(){

            @Override
            public T call() {
                return function.get();
            }
        }, (long)delayMilliseconds, TimeUnit.MILLISECONDS);
        scheduler.shutdown();
        return future;
    }

    public static <T> ScheduledFuture<T> defer(Supplier<T> function) {
        return U.delay(function, 0);
    }

    public static ScheduledFuture<Void> defer(final Runnable runnable) {
        return U.delay(new Supplier<Void>(){

            @Override
            public Void get() {
                runnable.run();
                return null;
            }
        }, 0);
    }

    public static <T> Supplier<T> throttle(Supplier<T> function, final int waitMilliseconds) {
        class ThrottleFunction
        implements Supplier<T> {
            private final Supplier<T> localFunction;
            private final 1ThrottleLater throttleLater;

            ThrottleFunction(Supplier<T> function) {
                this.localFunction = function;
                class ThrottleLater
                implements Supplier<T> {
                    private final Supplier<T> localFunction;
                    private ScheduledFuture<T> timeout;
                    private long previous;

                    ThrottleLater(Supplier<T> function) {
                        this.localFunction = function;
                    }

                    @Override
                    public T get() {
                        this.previous = U.now();
                        this.timeout = null;
                        return this.localFunction.get();
                    }

                    ScheduledFuture<T> getTimeout() {
                        return this.timeout;
                    }

                    void setTimeout(ScheduledFuture<T> timeout) {
                        this.timeout = timeout;
                    }

                    long getPrevious() {
                        return this.previous;
                    }

                    void setPrevious(long previous) {
                        this.previous = previous;
                    }
                }
                this.throttleLater = new ThrottleLater(function);
            }

            @Override
            public T get() {
                long now = U.now();
                if (this.throttleLater.getPrevious() == 0L) {
                    this.throttleLater.setPrevious(now);
                }
                long remaining = (long)waitMilliseconds - (now - this.throttleLater.getPrevious());
                Object result = null;
                if (remaining <= 0L) {
                    this.throttleLater.setPrevious(now);
                    result = this.localFunction.get();
                } else if (this.throttleLater.getTimeout() == null) {
                    this.throttleLater.setTimeout(U.delay(this.throttleLater, waitMilliseconds));
                }
                return result;
            }
        }
        return new ThrottleFunction(function);
    }

    public static <T> Supplier<T> debounce(final Supplier<T> function, final int delayMilliseconds) {
        return new Supplier<T>(){
            private ScheduledFuture<T> timeout;

            @Override
            public T get() {
                U.clearTimeout(this.timeout);
                this.timeout = U.delay(function, delayMilliseconds);
                return null;
            }
        };
    }

    public static <T> Function<Void, T> wrap(final Function<T, T> function, final Function<Function<T, T>, T> wrapper) {
        return new Function<Void, T>(){

            @Override
            public T apply(Void arg) {
                return wrapper.apply(function);
            }
        };
    }

    public static <E> Predicate<E> negate(final Predicate<E> pred) {
        return new Predicate<E>(){

            @Override
            public boolean test(E item) {
                return !pred.test(item);
            }
        };
    }

    public static <T> Function<T, T> compose(final Function<T, T> ... func) {
        return new Function<T, T>(){

            @Override
            public T apply(T arg) {
                Object result = arg;
                for (int index = func.length - 1; index >= 0; --index) {
                    result = func[index].apply(result);
                }
                return result;
            }
        };
    }

    public static <E> Supplier<E> after(int count, Supplier<E> function) {
        class AfterFunction
        implements Supplier<E> {
            private final int count;
            private final Supplier<E> localFunction;
            private int index;
            private E result;

            AfterFunction(int count, Supplier<E> function) {
                this.count = count;
                this.localFunction = function;
            }

            @Override
            public E get() {
                if (++this.index >= this.count) {
                    this.result = this.localFunction.get();
                }
                return this.result;
            }
        }
        return new AfterFunction(count, function);
    }

    public static <E> Supplier<E> before(int count, Supplier<E> function) {
        class BeforeFunction
        implements Supplier<E> {
            private final int count;
            private final Supplier<E> localFunction;
            private int index;
            private E result;

            BeforeFunction(int count, Supplier<E> function) {
                this.count = count;
                this.localFunction = function;
            }

            @Override
            public E get() {
                if (++this.index <= this.count) {
                    this.result = this.localFunction.get();
                }
                return this.result;
            }
        }
        return new BeforeFunction(count, function);
    }

    public static <T> Supplier<T> once(final Supplier<T> function) {
        return new Supplier<T>(){
            private volatile boolean executed;
            private T result;

            @Override
            public T get() {
                if (!this.executed) {
                    this.executed = true;
                    this.result = function.get();
                }
                return this.result;
            }
        };
    }

    public static <K, V> Set<K> keys(Map<K, V> object) {
        return object.keySet();
    }

    public static <K, V> Collection<V> values(Map<K, V> object) {
        return object.values();
    }

    public static <K, V> List<Tuple<K, V>> mapObject(Map<K, V> object, final Function<? super V, V> func) {
        return U.map(U.newArrayList(object.entrySet()), new Function<Map.Entry<K, V>, Tuple<K, V>>(){

            @Override
            public Tuple<K, V> apply(Map.Entry<K, V> entry) {
                return Tuple.create(entry.getKey(), func.apply(entry.getValue()));
            }
        });
    }

    public static <K, V> List<Tuple<K, V>> pairs(Map<K, V> object) {
        return U.map(U.newArrayList(object.entrySet()), new Function<Map.Entry<K, V>, Tuple<K, V>>(){

            @Override
            public Tuple<K, V> apply(Map.Entry<K, V> entry) {
                return Tuple.create(entry.getKey(), entry.getValue());
            }
        });
    }

    public static <K, V> List<Tuple<V, K>> invert(Map<K, V> object) {
        return U.map(U.newArrayList(object.entrySet()), new Function<Map.Entry<K, V>, Tuple<V, K>>(){

            @Override
            public Tuple<V, K> apply(Map.Entry<K, V> entry) {
                return Tuple.create(entry.getValue(), entry.getKey());
            }
        });
    }

    public static List<String> functions(Object object) {
        List result = U.newArrayList();
        for (Method method : object.getClass().getDeclaredMethods()) {
            result.add(method.getName());
        }
        return U.sort(U.uniq(result));
    }

    public static List<String> methods(Object object) {
        return U.functions(object);
    }

    public static <K, V> Map<K, V> extend(Map<K, V> destination, Map<K, V> ... sources) {
        Map result = U.newLinkedHashMap();
        for (Map.Entry<K, V> entry : destination.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        for (Map<K, V> source : sources) {
            for (Map.Entry<K, V> entry : source.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public static <E> E findKey(List<E> list, Predicate<E> pred) {
        for (E e : list) {
            if (!pred.test(e)) continue;
            return e;
        }
        return null;
    }

    public static <E> E findKey(E[] array, Predicate<E> pred) {
        return U.findKey(Arrays.asList(array), pred);
    }

    public static <E> E findLastKey(List<E> list, Predicate<E> pred) {
        for (int index = list.size() - 1; index >= 0; --index) {
            if (!pred.test(list.get(index))) continue;
            return list.get(index);
        }
        return null;
    }

    public static <E> E findLastKey(E[] array, Predicate<E> pred) {
        return U.findLastKey(Arrays.asList(array), pred);
    }

    public static <K, V> List<Tuple<K, V>> pick(Map<K, V> object, final K ... keys) {
        return U.without(U.map(U.newArrayList(object.entrySet()), new Function<Map.Entry<K, V>, Tuple<K, V>>(){

            @Override
            public Tuple<K, V> apply(Map.Entry<K, V> entry) {
                if (Arrays.asList(keys).contains(entry.getKey())) {
                    return Tuple.create(entry.getKey(), entry.getValue());
                }
                return null;
            }
        }), new Tuple[]{null});
    }

    public static <K, V> List<Tuple<K, V>> pick(final Map<K, V> object, final Predicate<V> pred) {
        return U.without(U.map(U.newArrayList(object.entrySet()), new Function<Map.Entry<K, V>, Tuple<K, V>>(){

            @Override
            public Tuple<K, V> apply(Map.Entry<K, V> entry) {
                if (pred.test(object.get(entry.getKey()))) {
                    return Tuple.create(entry.getKey(), entry.getValue());
                }
                return null;
            }
        }), new Tuple[]{null});
    }

    public static <K, V> List<Tuple<K, V>> omit(Map<K, V> object, final K ... keys) {
        return U.without(U.map(U.newArrayList(object.entrySet()), new Function<Map.Entry<K, V>, Tuple<K, V>>(){

            @Override
            public Tuple<K, V> apply(Map.Entry<K, V> entry) {
                if (Arrays.asList(keys).contains(entry.getKey())) {
                    return null;
                }
                return Tuple.create(entry.getKey(), entry.getValue());
            }
        }), new Tuple[]{null});
    }

    public static <K, V> List<Tuple<K, V>> omit(Map<K, V> object, final Predicate<V> pred) {
        return U.without(U.map(U.newArrayList(object.entrySet()), new Function<Map.Entry<K, V>, Tuple<K, V>>(){

            @Override
            public Tuple<K, V> apply(Map.Entry<K, V> entry) {
                if (pred.test(entry.getValue())) {
                    return null;
                }
                return Tuple.create(entry.getKey(), entry.getValue());
            }
        }), new Tuple[]{null});
    }

    public static <K, V> Map<K, V> defaults(Map<K, V> object, Map<K, V> defaults) {
        Map result = U.newLinkedHashMap();
        for (Map.Entry<K, V> entry : defaults.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<K, V> entry : object.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Object clone(Object obj) {
        try {
            if (obj instanceof Cloneable) {
                for (Method method : obj.getClass().getMethods()) {
                    if (!method.getName().equals("clone") || method.getParameterTypes().length != 0) continue;
                    return method.invoke(obj, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        throw new IllegalArgumentException("Cannot clone object");
    }

    public static <E> E[] clone(E ... iterable) {
        return Arrays.copyOf(iterable, iterable.length);
    }

    public static <T> void tap(Iterable<T> iterable, Consumer<? super T> func) {
        U.each(iterable, func);
    }

    public static <K, V> boolean isMatch(Map<K, V> object, Map<K, V> properties) {
        for (K key : U.keys(properties)) {
            if (object.containsKey(key) && object.get(key).equals(properties.get(key))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(Object object, Object other) {
        return object == null ? other == null : object.equals(other);
    }

    public static <K, V> boolean isEmpty(Map<K, V> object) {
        return object == null || object.isEmpty();
    }

    public static <T> boolean isEmpty(Iterable<T> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public boolean isEmpty() {
        return this.iterable == null || !this.iterable.iterator().hasNext();
    }

    public static <K, V> boolean isNotEmpty(Map<K, V> object) {
        return object != null && !object.isEmpty();
    }

    public static <T> boolean isNotEmpty(Iterable<T> iterable) {
        return iterable != null && iterable.iterator().hasNext();
    }

    public boolean isNotEmpty() {
        return this.iterable != null && this.iterable.iterator().hasNext();
    }

    public static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    public static boolean isObject(Object object) {
        return object instanceof Map;
    }

    public static boolean isFunction(Object object) {
        return object instanceof Function;
    }

    public static boolean isString(Object object) {
        return object instanceof String;
    }

    public static boolean isNumber(Object object) {
        return object instanceof Number;
    }

    public static boolean isDate(Object object) {
        return object instanceof Date;
    }

    public static boolean isRegExp(Object object) {
        return object instanceof Pattern;
    }

    public static boolean isError(Object object) {
        return object instanceof Throwable;
    }

    public static boolean isBoolean(Object object) {
        return object instanceof Boolean;
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static <K, V> boolean has(Map<K, V> object, K key) {
        return object.containsKey(key);
    }

    public static <E> E identity(E value) {
        return value;
    }

    public static <E> Supplier<E> constant(final E value) {
        return new Supplier<E>(){

            @Override
            public E get() {
                return value;
            }
        };
    }

    public static <K, V> Function<Map<K, V>, V> property(final K key) {
        return new Function<Map<K, V>, V>(){

            @Override
            public V apply(Map<K, V> object) {
                return object.get(key);
            }
        };
    }

    public static <K, V> Function<K, V> propertyOf(final Map<K, V> object) {
        return new Function<K, V>(){

            @Override
            public V apply(K key) {
                return object.get(key);
            }
        };
    }

    public static <K, V> Predicate<Map<K, V>> matcher(final Map<K, V> object) {
        return new Predicate<Map<K, V>>(){

            @Override
            public boolean test(Map<K, V> item) {
                for (Object key : U.keys(object)) {
                    if (item.containsKey(key) && item.get(key).equals(object.get(key))) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static void times(int count, Runnable runnable) {
        for (int index = 0; index < count; ++index) {
            runnable.run();
        }
    }

    public static int random(int min, int max) {
        return min + new SecureRandom().nextInt(max - min + 1);
    }

    public static int random(int max) {
        return new SecureRandom().nextInt(max + 1);
    }

    public static long now() {
        return new Date().getTime();
    }

    public static String escape(String value) {
        StringBuilder builder = new StringBuilder();
        for (char ch : value.toCharArray()) {
            builder.append(ESCAPES.containsKey(Character.valueOf(ch)) ? (Serializable)((Object)ESCAPES.get(Character.valueOf(ch))) : Character.valueOf(ch));
        }
        return builder.toString();
    }

    public static String unescape(String value) {
        return value.replaceAll("&#x60;", "`").replaceAll("&#x27;", "'").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&amp;", "&");
    }

    public static <E> Object result(Iterable<E> iterable, Predicate<E> pred) {
        for (E element : iterable) {
            if (!pred.test(element)) continue;
            if (element instanceof Map.Entry) {
                if (((Map.Entry)element).getValue() instanceof Supplier) {
                    return ((Supplier)((Map.Entry)element).getValue()).get();
                }
                return ((Map.Entry)element).getValue();
            }
            return element;
        }
        return null;
    }

    public static String uniqueId(String prefix) {
        return (prefix == null ? "" : prefix) + UNIQUE_ID.incrementAndGet();
    }

    public static String uniquePassword() {
        String[] passwords = new String[]{"ALKJVBPIQYTUIWEBVPQALZVKQRWORTUYOYISHFLKAJMZNXBVMNFGAHKJSDFALAPOQIERIUYTGSFGKMZNXBVJAHGFAKX", "1234567890", "qpowiealksdjzmxnvbfghsdjtreiuowiruksfhksajmzxncbvlaksjdhgqwetytopskjhfgvbcnmzxalksjdfhgbvzm", ".@,-+/()#$%^&*!"};
        StringBuilder result = new StringBuilder();
        long passwordLength = Math.abs(UUID.randomUUID().getLeastSignificantBits() % 8L) + 8L;
        int index = 0;
        while ((long)index < passwordLength) {
            int passIndex = (int)((long)passwords.length * (long)index / passwordLength);
            int charIndex = (int)Math.abs(UUID.randomUUID().getLeastSignificantBits() % (long)passwords[passIndex].length());
            result.append(passwords[passIndex].charAt(charIndex));
            ++index;
        }
        return result.toString();
    }

    public static <K, V> Template<Map<K, V>> template(String template) {
        return new TemplateImpl(template);
    }

    public static String format(String template, Object ... params) {
        Matcher matcher = FORMAT_PATTERN.matcher(template);
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        while (matcher.find()) {
            if (matcher.group(1).isEmpty()) {
                matcher.appendReplacement(buffer, "<%" + index++ + "%>");
                continue;
            }
            matcher.appendReplacement(buffer, "<%" + matcher.group(1) + "%>");
        }
        matcher.appendTail(buffer);
        String newTemplate = buffer.toString();
        Map args = U.newLinkedHashMap();
        index = 0;
        for (Object param : params) {
            args.put(index, param.toString());
            ++index;
        }
        return new TemplateImpl(newTemplate).apply(args);
    }

    public static <T> Iterable<T> iterate(T seed, UnaryOperator<T> unaryOperator) {
        return new MyIterable<T>(seed, unaryOperator);
    }

    public static <T> Chain<T> chain(List<T> list) {
        return new Chain<T>(list);
    }

    public static <T> Chain<T> chain(Iterable<T> iterable) {
        return new Chain<T>(U.newArrayList(iterable));
    }

    public static <T> Chain<T> chain(Iterable<T> iterable, int size) {
        return new Chain<T>(U.newArrayList(iterable, size));
    }

    public static <T> Chain<T> chain(T ... array) {
        return new Chain<T>(Arrays.asList(array));
    }

    public static Chain<Integer> chain(int[] array) {
        return new Chain<Integer>(U.newIntegerList(array));
    }

    public Chain<T> chain() {
        return new Chain<T>(U.newArrayList(this.iterable));
    }

    public static void mixin(String funcName, Function<String, String> func) {
        FUNCTIONS.put(funcName, func);
    }

    public Optional<String> call(String funcName) {
        if (this.string.isPresent() && FUNCTIONS.containsKey(funcName)) {
            return Optional.of(FUNCTIONS.get(funcName).apply(this.string.get()));
        }
        return Optional.absent();
    }

    public static <T extends Comparable<T>> List<T> sort(Iterable<T> iterable) {
        List<T> localList = U.newArrayList(iterable);
        Collections.sort(localList);
        return localList;
    }

    public static <T extends Comparable<T>> T[] sort(T ... array) {
        Object[] localArray = (Comparable[])array.clone();
        Arrays.sort(localArray);
        return localArray;
    }

    public List<Comparable> sort() {
        return U.sort(this.iterable);
    }

    public static <T> String join(Iterable<T> iterable, String separator) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (T item : iterable) {
            if (index > 0) {
                sb.append(separator);
            }
            sb.append(item.toString());
            ++index;
        }
        return sb.toString();
    }

    public static <T> String join(Iterable<T> iterable) {
        return U.join(iterable, " ");
    }

    public static <T> String join(T[] array, String separator) {
        return U.join(Arrays.asList(array), separator);
    }

    public static <T> String join(T[] array) {
        return U.join(array, " ");
    }

    public String join(String separator) {
        return U.join(this.iterable, separator);
    }

    public String join() {
        return U.join(this.iterable);
    }

    public static <T> List<T> push(List<T> list, T ... values) {
        List<T> result = U.newArrayList(list);
        for (T value : values) {
            result.add(value);
        }
        return result;
    }

    public List<T> push(T ... values) {
        return U.push((List)this.getIterable(), values);
    }

    public static <T> Tuple<T, List<T>> pop(List<T> list) {
        return Tuple.create(U.last(list), U.initial(list));
    }

    public Tuple<T, List<T>> pop() {
        return U.pop((List)this.getIterable());
    }

    public static <T> List<T> unshift(List<T> list, T ... values) {
        List<T> result = U.newArrayList(list);
        int index = 0;
        for (T value : values) {
            result.add(index, value);
            ++index;
        }
        return result;
    }

    public List<T> unshift(T ... values) {
        return U.unshift((List)this.getIterable(), values);
    }

    public static <T> Tuple<T, List<T>> shift(List<T> list) {
        return Tuple.create(U.first(list), U.rest(list));
    }

    public Tuple<T, List<T>> shift() {
        return U.shift((List)this.getIterable());
    }

    public static <T> T[] concat(T[] first, T[] ... other) {
        int length = 0;
        for (T[] otherItem : other) {
            length += otherItem.length;
        }
        T[] result = Arrays.copyOf(first, first.length + length);
        int index = 0;
        for (T[] otherItem : other) {
            System.arraycopy(otherItem, 0, result, first.length + index, otherItem.length);
            index += otherItem.length;
        }
        return result;
    }

    public static <T> List<T> concat(Iterable<T> first, Iterable<T> ... other) {
        List<T> list = U.newArrayList(first);
        for (Iterable<T> iter : other) {
            list.addAll(U.newArrayList(iter));
        }
        return list;
    }

    public List<T> concatWith(Iterable<T> ... other) {
        return U.concat(this.iterable, other);
    }

    public static <T> List<T> slice(Iterable<T> iterable, int start) {
        List<T> result = start >= 0 ? U.newArrayList(iterable).subList(start, U.size(iterable)) : U.newArrayList(iterable).subList(U.size(iterable) + start, U.size(iterable));
        return result;
    }

    public static <T> T[] slice(T[] array, int start) {
        T[] result = start >= 0 ? Arrays.copyOfRange(array, start, array.length) : Arrays.copyOfRange(array, array.length + start, array.length);
        return result;
    }

    public List<T> slice(int start) {
        return U.slice(this.iterable, start);
    }

    public static <T> List<T> slice(Iterable<T> iterable, int start, int end) {
        List<T> result = start >= 0 ? (end > 0 ? U.newArrayList(iterable).subList(start, end) : U.newArrayList(iterable).subList(start, U.size(iterable) + end)) : (end > 0 ? U.newArrayList(iterable).subList(U.size(iterable) + start, end) : U.newArrayList(iterable).subList(U.size(iterable) + start, U.size(iterable) + end));
        return result;
    }

    public static <T> T[] slice(T[] array, int start, int end) {
        T[] result = start >= 0 ? (end > 0 ? Arrays.copyOfRange(array, start, end) : Arrays.copyOfRange(array, start, array.length + end)) : (end > 0 ? Arrays.copyOfRange(array, array.length + start, end) : Arrays.copyOfRange(array, array.length + start, array.length + end));
        return result;
    }

    public List<T> slice(int start, int end) {
        return U.slice(this.iterable, start, end);
    }

    public static <T> List<List<T>> splitAt(Iterable<T> iterable, int position) {
        List<List<T>> result = U.newArrayList();
        int size = U.size(iterable);
        int index = position < 0 ? 0 : (position > size ? size : position);
        result.add(U.newArrayList(iterable).subList(0, index));
        result.add(U.newArrayList(iterable).subList(index, size));
        return result;
    }

    public static <T> List<List<T>> splitAt(T[] array, int position) {
        return U.splitAt(Arrays.asList(array), position);
    }

    public List<List<T>> splitAt(int position) {
        return U.splitAt(this.iterable, position);
    }

    public static <T> List<T> takeSkipping(Iterable<T> iterable, int stepSize) {
        List<T> result = U.newArrayList();
        if (stepSize <= 0) {
            return result;
        }
        int size = U.size(iterable);
        if (stepSize > size) {
            result.add(U.first(iterable));
            return result;
        }
        int i = 0;
        for (T element : iterable) {
            if (i++ % stepSize != 0) continue;
            result.add(element);
        }
        return result;
    }

    public static <T> List<T> takeSkipping(T[] array, int stepSize) {
        return U.takeSkipping(Arrays.asList(array), stepSize);
    }

    public List<T> takeSkipping(int stepSize) {
        return U.takeSkipping(this.iterable, stepSize);
    }

    public static <T> List<T> reverse(Iterable<T> iterable) {
        List<T> result = U.newArrayList(iterable);
        Collections.reverse(result);
        return result;
    }

    public static <T> T[] reverse(T ... array) {
        Object[] newArray = (Object[])array.clone();
        for (int index = 0; index < array.length / 2; ++index) {
            Object temp = newArray[index];
            newArray[index] = newArray[array.length - 1 - index];
            newArray[array.length - 1 - index] = temp;
        }
        return newArray;
    }

    public static List<Integer> reverse(int[] array) {
        List<Integer> result = U.newIntegerList(array);
        Collections.reverse(result);
        return result;
    }

    public List<T> reverse() {
        return U.reverse(this.iterable);
    }

    public Iterable<T> getIterable() {
        return this.iterable;
    }

    public Iterable<T> value() {
        return this.iterable;
    }

    public Optional<String> getString() {
        return this.string;
    }

    public static <T> ScheduledFuture<T> setTimeout(Supplier<T> function, int delayMilliseconds) {
        return U.delay(function, delayMilliseconds);
    }

    public static void clearTimeout(ScheduledFuture<?> scheduledFuture) {
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
    }

    public static <T> ScheduledFuture setInterval(final Supplier<T> function, int delayMilliseconds) {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        return scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                function.get();
            }
        }, delayMilliseconds, delayMilliseconds, TimeUnit.MILLISECONDS);
    }

    public static void clearInterval(ScheduledFuture scheduledFuture) {
        U.clearTimeout(scheduledFuture);
    }

    public static <T> List<T> copyOf(Iterable<T> iterable) {
        return U.newArrayList(iterable);
    }

    public List<T> copyOf() {
        return U.newArrayList(this.value());
    }

    public static <T> List<T> copyOfRange(Iterable<T> iterable, int start, int end) {
        return U.slice(iterable, start, end);
    }

    public List<T> copyOfRange(int start, int end) {
        return U.slice(this.value(), start, end);
    }

    public static <T> T elementAt(List<T> list, int index) {
        return list.get(index);
    }

    public T elementAt(int index) {
        return U.elementAt((List)this.value(), index);
    }

    public static <T> T get(List<T> list, int index) {
        return U.elementAt(list, index);
    }

    public T get(int index) {
        return U.elementAt((List)this.value(), index);
    }

    public static <T> Tuple<T, List<T>> set(List<T> list, int index, T value) {
        List<T> newList = U.newArrayList(list);
        return Tuple.create(newList.set(index, value), newList);
    }

    public Tuple<T, List<T>> set(int index, T value) {
        return U.set((List)this.value(), index, value);
    }

    public static <T> T elementAtOrElse(List<T> list, int index, T defaultValue) {
        try {
            return list.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            return defaultValue;
        }
    }

    public T elementAtOrElse(int index, T defaultValue) {
        return U.elementAtOrElse((List)this.value(), index, defaultValue);
    }

    public static <T> T elementAtOrNull(List<T> list, int index) {
        try {
            return list.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public T elementAtOrNull(int index) {
        return U.elementAtOrNull((List)this.value(), index);
    }

    public static <T> int lastIndex(Iterable<T> iterable) {
        return U.size(iterable) - 1;
    }

    public static <T> int lastIndex(T[] array) {
        return array.length - 1;
    }

    public static int lastIndex(int[] array) {
        return array.length - 1;
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> List<T> checkNotNullElements(List<T> references) {
        if (references == null) {
            throw new NullPointerException();
        }
        for (T reference : references) {
            U.checkNotNull(reference);
        }
        return references;
    }

    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static boolean nonNull(Object obj) {
        return obj != null;
    }

    public static <T> T defaultTo(T value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected static <T> List<T> newArrayList() {
        return new ArrayList();
    }

    protected static <T> List<T> newArrayList(Iterable<T> iterable) {
        ArrayList<T> result;
        if (iterable instanceof Collection) {
            result = new ArrayList((Collection)iterable);
        } else {
            result = new ArrayList<T>();
            for (T item : iterable) {
                result.add(item);
            }
        }
        return result;
    }

    protected static <T> List<T> newArrayList(Iterable<T> iterable, int size) {
        ArrayList<T> result = new ArrayList<T>();
        for (int index = 0; iterable.iterator().hasNext() && index < size; ++index) {
            result.add(iterable.iterator().next());
        }
        return result;
    }

    protected static List<Integer> newIntegerList(int ... array) {
        ArrayList<Integer> result = new ArrayList<Integer>(array.length);
        for (int item : array) {
            result.add(item);
        }
        return result;
    }

    protected static <T> List<T> newArrayListWithExpectedSize(int size) {
        return new ArrayList((int)(5L + (long)size + (long)(size / 10)));
    }

    protected static <T> Set<T> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    protected static <T> Set<T> newLinkedHashSet(Iterable<T> iterable) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (T item : iterable) {
            result.add(item);
        }
        return result;
    }

    protected static <T> Set<T> newLinkedHashSetWithExpectedSize(int size) {
        return new LinkedHashSet((int)Math.max((long)size * 2L, 16L));
    }

    protected static <K, E> Map<K, E> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <T> Predicate<T> and(final Predicate<? super T> pred1, final Predicate<? super T> pred2, final Predicate<? super T> ... rest) {
        U.checkNotNull(pred1);
        U.checkNotNull(pred2);
        U.checkNotNullElements(Arrays.asList(rest));
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                boolean result;
                boolean bl = result = pred1.test(value) && pred2.test(value);
                if (!result) {
                    return false;
                }
                for (Predicate predicate : rest) {
                    if (predicate.test(value)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> Predicate<T> or(final Predicate<? super T> pred1, final Predicate<? super T> pred2, final Predicate<? super T> ... rest) {
        U.checkNotNull(pred1);
        U.checkNotNull(pred2);
        U.checkNotNullElements(Arrays.asList(rest));
        return new Predicate<T>(){

            @Override
            public boolean test(T value) {
                boolean result;
                boolean bl = result = pred1.test(value) || pred2.test(value);
                if (result) {
                    return true;
                }
                for (Predicate predicate : rest) {
                    if (!predicate.test(value)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static void main(String ... args) {
        String message = "Underscore-java is a java port of Underscore.js.\n\nIn addition to porting Underscore's functionality, Underscore-java includes matching unit tests.\n\nFor docs, license, tests, and downloads, see: http://javadev.github.io/underscore-java";
        System.out.println("Underscore-java is a java port of Underscore.js.\n\nIn addition to porting Underscore's functionality, Underscore-java includes matching unit tests.\n\nFor docs, license, tests, and downloads, see: http://javadev.github.io/underscore-java");
    }

    static {
        TEMPLATE_SETTINGS.put(EVALUATE, "<%([\\s\\S]+?)%>");
        TEMPLATE_SETTINGS.put(INTERPOLATE, "<%=([\\s\\S]+?)%>");
        TEMPLATE_SETTINGS.put(ESCAPE, "<%-([\\s\\S]+?)%>");
        ESCAPES.put(Character.valueOf('&'), "&amp;");
        ESCAPES.put(Character.valueOf('<'), "&lt;");
        ESCAPES.put(Character.valueOf('>'), "&gt;");
        ESCAPES.put(Character.valueOf('\"'), "&quot;");
        ESCAPES.put(Character.valueOf('\''), "&#x27;");
        ESCAPES.put(Character.valueOf('`'), "&#x60;");
    }

    public static class Chain<T> {
        private final T item;
        private final List<T> list;

        public Chain(T item) {
            this.item = item;
            this.list = null;
        }

        public Chain(List<T> list) {
            this.item = null;
            this.list = list;
        }

        public Chain<T> first() {
            return new Chain<T>(U.first(this.list));
        }

        public Chain<T> first(int n) {
            return new Chain<T>(U.first(this.list, n));
        }

        public Chain<T> first(Predicate<T> pred) {
            return new Chain<T>(U.first(this.list, pred));
        }

        public Chain<T> first(Predicate<T> pred, int n) {
            return new Chain<T>(U.first(this.list, pred, n));
        }

        public Chain<T> firstOrNull() {
            return new Chain<T>(U.firstOrNull(this.list));
        }

        public Chain<T> firstOrNull(Predicate<T> pred) {
            return new Chain<T>(U.firstOrNull(this.list, pred));
        }

        public Chain<T> initial() {
            return new Chain<T>(U.initial(this.list));
        }

        public Chain<T> initial(int n) {
            return new Chain<T>(U.initial(this.list, n));
        }

        public Chain<T> last() {
            return new Chain<T>(U.last(this.list));
        }

        public Chain<T> last(int n) {
            return new Chain<T>(U.last(this.list, n));
        }

        public Chain<T> lastOrNull() {
            return new Chain<T>(U.lastOrNull(this.list));
        }

        public Chain<T> lastOrNull(Predicate<T> pred) {
            return new Chain<T>(U.lastOrNull(this.list, pred));
        }

        public Chain<T> rest() {
            return new Chain<T>(U.rest(this.list));
        }

        public Chain<T> rest(int n) {
            return new Chain<T>(U.rest(this.list, n));
        }

        public Chain<T> compact() {
            return new Chain<List<T>>(U.compact(this.list));
        }

        public Chain<T> compact(T falsyValue) {
            return new Chain<T>(U.compact(this.list, falsyValue));
        }

        public Chain flatten() {
            return new Chain(U.flatten(this.list));
        }

        public <F> Chain<F> map(Function<? super T, F> func) {
            return new Chain<F>(U.map(this.list, func));
        }

        public <F> Chain<F> mapIndexed(BiFunction<Integer, ? super T, F> func) {
            return new Chain<F>(U.mapIndexed(this.list, func));
        }

        public Chain<T> replace(Predicate<T> pred, T value) {
            return new Chain<T>(U.replace(this.list, pred, value));
        }

        public Chain<T> replaceIndexed(PredicateIndexed<T> pred, T value) {
            return new Chain<T>(U.replaceIndexed(this.list, pred, value));
        }

        public Chain<T> filter(Predicate<T> pred) {
            return new Chain<T>(U.filter(this.list, pred));
        }

        public Chain<T> filterIndexed(PredicateIndexed<T> pred) {
            return new Chain<T>(U.filterIndexed(this.list, pred));
        }

        public Chain<T> reject(Predicate<T> pred) {
            return new Chain<T>(U.reject(this.list, pred));
        }

        public Chain<T> rejectIndexed(PredicateIndexed<T> pred) {
            return new Chain<T>(U.rejectIndexed(this.list, pred));
        }

        public Chain<T> filterFalse(Predicate<T> pred) {
            return new Chain<T>(U.reject(this.list, pred));
        }

        public <F> Chain<F> reduce(BiFunction<F, T, F> func, F zeroElem) {
            return new Chain<F>(U.reduce(this.list, func, zeroElem));
        }

        public Chain<Optional<T>> reduce(BinaryOperator<T> func) {
            return new Chain<Optional<T>>(U.reduce(this.list, func));
        }

        public <F> Chain<F> reduceRight(BiFunction<F, T, F> func, F zeroElem) {
            return new Chain<F>(U.reduceRight(this.list, func, zeroElem));
        }

        public Chain<Optional<T>> reduceRight(BinaryOperator<T> func) {
            return new Chain<Optional<T>>(U.reduceRight(this.list, func));
        }

        public Chain<Optional<T>> find(Predicate<T> pred) {
            return new Chain<Optional<T>>(U.find(this.list, pred));
        }

        public Chain<Optional<T>> findLast(Predicate<T> pred) {
            return new Chain<Optional<T>>(U.findLast(this.list, pred));
        }

        public Chain<Comparable> max() {
            return new Chain<Comparable>((Comparable)U.max(this.list));
        }

        public <F extends Comparable<? super F>> Chain<T> max(Function<T, F> func) {
            return new Chain<T>(U.max(this.list, func));
        }

        public Chain<Comparable> min() {
            return new Chain<Comparable>((Comparable)U.min(this.list));
        }

        public <F extends Comparable<? super F>> Chain<T> min(Function<T, F> func) {
            return new Chain<T>(U.min(this.list, func));
        }

        public Chain<Comparable> sort() {
            return new Chain<Comparable>(U.sort(this.list));
        }

        public <F extends Comparable<? super F>> Chain<F> sortWith(Comparator<F> comparator) {
            return new Chain<T>(U.sortWith(this.list, comparator));
        }

        public <F extends Comparable<? super F>> Chain<T> sortBy(Function<T, F> func) {
            return new Chain(U.sortBy(this.list, func));
        }

        public <K> Chain<Map<K, Comparable>> sortBy(K key) {
            return new Chain<Map<K, Comparable>>(U.sortBy(this.list, key));
        }

        public <F> Chain<Map<F, List<T>>> groupBy(Function<T, F> func) {
            return new Chain<Map<F, List<T>>>(U.groupBy(this.list, func));
        }

        public <F> Chain<Map<F, Optional<T>>> groupBy(Function<T, F> func, BinaryOperator<T> binaryOperator) {
            return new Chain<Map<F, Optional<T>>>(U.groupBy(this.list, func, binaryOperator));
        }

        public Chain<Map<Object, List<T>>> indexBy(String property) {
            return new Chain<Map<Object, List<T>>>(U.indexBy(this.list, property));
        }

        public <F> Chain<Map<F, Integer>> countBy(Function<T, F> func) {
            return new Chain<Map<F, Integer>>(U.countBy(this.list, func));
        }

        public Chain<Map<T, Integer>> countBy() {
            return new Chain<Map<T, Integer>>(U.countBy(this.list));
        }

        public Chain<T> shuffle() {
            return new Chain<T>(U.shuffle(this.list));
        }

        public Chain<T> sample() {
            return new Chain<T>(U.sample(this.list));
        }

        public Chain<T> sample(int howMany) {
            return new Chain<T>(U.newArrayList(U.sample(this.list, howMany)));
        }

        public Chain<T> tap(Consumer<T> func) {
            U.each(this.list, func);
            return new Chain<T>(this.list);
        }

        public Chain<T> forEach(Consumer<T> func) {
            U.each(this.list, func);
            return new Chain<T>(this.list);
        }

        public Chain<T> forEachRight(Consumer<T> func) {
            U.eachRight(this.list, func);
            return new Chain<T>(this.list);
        }

        public Chain<Boolean> every(Predicate<T> pred) {
            return new Chain<Boolean>(U.every(this.list, pred));
        }

        public Chain<Boolean> some(Predicate<T> pred) {
            return new Chain<Boolean>(U.some(this.list, pred));
        }

        public Chain<Integer> count(Predicate<T> pred) {
            return new Chain<Integer>(U.count(this.list, pred));
        }

        public Chain<Boolean> contains(T elem) {
            return new Chain<Boolean>(U.contains(this.list, elem));
        }

        public Chain<Boolean> containsWith(T elem) {
            return new Chain<Boolean>(U.containsWith(this.list, elem));
        }

        public Chain<T> invoke(String methodName, List<Object> args) {
            return new Chain<T>(U.invoke(this.list, methodName, args));
        }

        public Chain<T> invoke(String methodName) {
            return new Chain<T>(U.invoke(this.list, methodName));
        }

        public Chain<Object> pluck(String propertyName) {
            return new Chain<Object>(U.pluck(this.list, propertyName));
        }

        public <E> Chain<T> where(List<Tuple<String, E>> properties) {
            return new Chain<T>(U.where(this.list, properties));
        }

        public <E> Chain<Optional<T>> findWhere(List<Tuple<String, E>> properties) {
            return new Chain<Optional<T>>(U.findWhere(this.list, properties));
        }

        public Chain<T> uniq() {
            return new Chain<T>(U.uniq(this.list));
        }

        public <F> Chain<T> uniq(Function<T, F> func) {
            return new Chain<T>(U.newArrayList(U.uniq(this.list, func)));
        }

        public Chain<T> distinct() {
            return new Chain<T>(U.uniq(this.list));
        }

        public <F> Chain<F> distinctBy(Function<T, F> func) {
            return new Chain<T>(U.newArrayList(U.uniq(this.list, func)));
        }

        public Chain<T> union(List<T> ... lists) {
            return new Chain<T>(U.union(this.list, lists));
        }

        public Chain<T> intersection(List<T> ... lists) {
            return new Chain<T>(U.intersection(this.list, lists));
        }

        public Chain<T> difference(List<T> ... lists) {
            return new Chain<T>(U.difference(this.list, lists));
        }

        public Chain<Integer> range(int stop) {
            return new Chain<Integer>(U.range(stop));
        }

        public Chain<Integer> range(int start, int stop) {
            return new Chain<Integer>(U.range(start, stop));
        }

        public Chain<Integer> range(int start, int stop, int step) {
            return new Chain<Integer>(U.range(start, stop, step));
        }

        public Chain<List<T>> chunk(int size) {
            return new Chain<List<T>>(U.chunk(this.value(), size, size));
        }

        public Chain<List<T>> chunk(int size, int step) {
            return new Chain<List<T>>(U.chunk(this.value(), size, step));
        }

        public Chain<List<T>> chunkFill(int size, T fillValue) {
            return new Chain<List<T>>(U.chunkFill(this.value(), size, size, fillValue));
        }

        public Chain<List<T>> chunkFill(int size, int step, T fillValue) {
            return new Chain<List<T>>(U.chunkFill(this.value(), size, step, fillValue));
        }

        public Chain<T> cycle(int times) {
            return new Chain<T>(U.cycle(this.value(), times));
        }

        public Chain<T> interpose(T element) {
            return new Chain<T>(U.interpose(this.value(), element));
        }

        public Chain<T> interposeByList(Iterable<T> interIter) {
            return new Chain<T>(U.interposeByList(this.value(), interIter));
        }

        public Chain<T> concat(List<T> ... lists) {
            return new Chain<T>(U.concat(this.list, lists));
        }

        public Chain<T> slice(int start) {
            return new Chain<T>(U.slice(this.list, start));
        }

        public Chain<T> slice(int start, int end) {
            return new Chain<T>(U.slice(this.list, start, end));
        }

        public Chain<List<T>> splitAt(int position) {
            return new Chain<List<T>>(U.splitAt(this.list, position));
        }

        public Chain<T> takeSkipping(int stepSize) {
            return new Chain<T>(U.takeSkipping(this.list, stepSize));
        }

        public Chain<T> reverse() {
            return new Chain<T>(U.reverse(this.list));
        }

        public Chain<String> join() {
            return new Chain<String>(U.join(this.list));
        }

        public Chain<String> join(String separator) {
            return new Chain<String>(U.join(this.list, separator));
        }

        public Chain<T> push(T ... values) {
            return new Chain<T>(U.push(this.value(), values));
        }

        public Chain<Tuple<T, List<T>>> pop() {
            return new Chain<Tuple<T, List<T>>>(U.pop(this.value()));
        }

        public Chain<Tuple<T, List<T>>> shift() {
            return new Chain<Tuple<T, List<T>>>(U.shift(this.value()));
        }

        public Chain<T> unshift(T ... values) {
            return new Chain<T>(U.unshift(this.value(), values));
        }

        public Chain<T> skip(int numberToSkip) {
            return new Chain<T>(this.list.subList(numberToSkip, this.list.size()));
        }

        public Chain<T> limit(int size) {
            return new Chain<T>(U.first(this.list, size));
        }

        public <K, V> Chain<Map<K, V>> toMap() {
            return new Chain(U.toMap(this.list));
        }

        public boolean isEmpty() {
            return U.isEmpty(this.list);
        }

        public boolean isNotEmpty() {
            return U.isNotEmpty(this.list);
        }

        public int size() {
            return U.size(this.list);
        }

        public T item() {
            return this.item;
        }

        public List<T> value() {
            return this.list;
        }

        public String toString() {
            return String.valueOf(this.list);
        }
    }

    private static final class MyIterable<T>
    implements Iterable<T> {
        private final UnaryOperator<T> unaryOperator;
        private boolean firstRun = true;
        private T value;

        MyIterable(T seed, UnaryOperator<T> unaryOperator) {
            this.value = seed;
            this.unaryOperator = unaryOperator;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public T next() {
                    if (MyIterable.this.firstRun) {
                        MyIterable.this.firstRun = false;
                    } else {
                        MyIterable.this.value = MyIterable.this.unaryOperator.apply(MyIterable.this.value);
                    }
                    return MyIterable.this.value;
                }

                @Override
                public void remove() {
                }
            };
        }
    }

    private static final class TemplateImpl<K, V>
    implements Template<Map<K, V>> {
        private final String template;

        private TemplateImpl(String template) {
            this.template = template;
        }

        @Override
        public String apply(Map<K, V> value) {
            String evaluate = (String)TEMPLATE_SETTINGS.get(U.EVALUATE);
            String interpolate = (String)TEMPLATE_SETTINGS.get(U.INTERPOLATE);
            String escape = (String)TEMPLATE_SETTINGS.get(U.ESCAPE);
            String result = this.template;
            for (Map.Entry<K, V> element : value.entrySet()) {
                result = Pattern.compile(interpolate.replace(U.ALL_SYMBOLS, U.S_Q + element.getKey() + U.E_S)).matcher(result).replaceAll(String.valueOf(element.getValue()));
                result = Pattern.compile(escape.replace(U.ALL_SYMBOLS, U.S_Q + element.getKey() + U.E_S)).matcher(result).replaceAll(U.escape(String.valueOf(element.getValue())));
                result = Pattern.compile(evaluate.replace(U.ALL_SYMBOLS, U.S_Q + element.getKey() + U.E_S)).matcher(result).replaceAll(String.valueOf(element.getValue()));
            }
            return result;
        }

        @Override
        public List<String> check(Map<K, V> value) {
            String evaluate = (String)TEMPLATE_SETTINGS.get(U.EVALUATE);
            String interpolate = (String)TEMPLATE_SETTINGS.get(U.INTERPOLATE);
            String escape = (String)TEMPLATE_SETTINGS.get(U.ESCAPE);
            String result = this.template;
            ArrayList<String> notFound = new ArrayList<String>();
            ArrayList<String> valueKeys = new ArrayList<String>();
            for (Map.Entry<K, V> element : value.entrySet()) {
                String key = "" + element.getKey();
                Matcher matcher = Pattern.compile(interpolate.replace(U.ALL_SYMBOLS, U.S_Q + key + U.E_S)).matcher(result);
                boolean isFound = matcher.find();
                result = matcher.replaceAll(String.valueOf(element.getValue()));
                matcher = Pattern.compile(escape.replace(U.ALL_SYMBOLS, U.S_Q + key + U.E_S)).matcher(result);
                isFound |= matcher.find();
                result = matcher.replaceAll(U.escape(String.valueOf(element.getValue())));
                matcher = Pattern.compile(evaluate.replace(U.ALL_SYMBOLS, U.S_Q + key + U.E_S)).matcher(result);
                result = matcher.replaceAll(String.valueOf(element.getValue()));
                if (!(isFound |= matcher.find())) {
                    notFound.add(key);
                }
                valueKeys.add(key);
            }
            ArrayList<String> templateVars = new ArrayList<String>();
            Matcher matcher = Pattern.compile(interpolate).matcher(result);
            while (matcher.find()) {
                templateVars.add(matcher.group(1).trim());
            }
            result = matcher.replaceAll("");
            matcher = Pattern.compile(escape).matcher(result);
            while (matcher.find()) {
                templateVars.add(matcher.group(1).trim());
            }
            result = matcher.replaceAll("");
            matcher = Pattern.compile(evaluate).matcher(result);
            while (matcher.find()) {
                templateVars.add(matcher.group(1).trim());
            }
            notFound.addAll(U.difference(templateVars, valueKeys));
            return notFound;
        }
    }

    private static final class WherePredicate<E, T>
    implements Predicate<E> {
        private final List<Tuple<String, T>> properties;

        private WherePredicate(List<Tuple<String, T>> properties) {
            this.properties = properties;
        }

        @Override
        public boolean test(E elem) {
            for (Tuple<String, T> prop : this.properties) {
                try {
                    if (elem.getClass().getField(prop.fst()).get(elem).equals(prop.snd())) continue;
                    return false;
                }
                catch (Exception ex) {
                    try {
                        if (elem.getClass().getMethod(prop.fst(), new Class[0]).invoke(elem, new Object[0]).equals(prop.snd())) continue;
                        return false;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            return true;
        }
    }
}

