/*
 * Decompiled with CFR 0.152.
 */
package com.github.underscore;

import com.github.underscore.Underscore;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Optional<T> {
    private static final Optional<?> EMPTY = new Optional();
    private final T arg;
    private final boolean absent;

    private Optional() {
        this.arg = null;
        this.absent = true;
    }

    private Optional(T arg) {
        this.arg = arg;
        this.absent = false;
    }

    public static <T> Optional<T> of(T arg) {
        return new Optional<T>(arg);
    }

    public static <T> Optional<T> fromNullable(T nullableReference) {
        return nullableReference == null ? Optional.empty() : new Optional<T>(nullableReference);
    }

    public static <T> Optional<T> empty() {
        return EMPTY;
    }

    public T get() {
        if (this.absent) {
            throw new IllegalStateException("Optional.get() cannot be called on an empty value");
        }
        return this.arg;
    }

    public T or(T defaultValue) {
        if (this.absent) {
            return defaultValue;
        }
        return this.arg;
    }

    public T orNull() {
        if (this.absent) {
            return null;
        }
        return this.arg;
    }

    public boolean isEmpty() {
        return this.absent;
    }

    public boolean isPresent() {
        return !this.absent;
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        Underscore.checkNotNull(predicate);
        if (this.isPresent()) {
            return predicate.test(this.arg) ? this : Optional.empty();
        }
        return this;
    }

    public <F> Optional<F> map(Function<? super T, F> mapper) {
        Underscore.checkNotNull(mapper);
        if (this.isPresent()) {
            return Optional.fromNullable(mapper.apply(this.arg));
        }
        return Optional.empty();
    }

    public <X extends Throwable> T orThrow(Supplier<? extends X> exceptionFunction) throws X {
        if (this.absent) {
            throw (Throwable)exceptionFunction.get();
        }
        return this.arg;
    }

    public java.util.Optional<T> toJavaOptional() {
        return java.util.Optional.ofNullable(this.arg);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Optional optional = (Optional)o;
        return this.absent == optional.absent && Objects.equals(this.arg, optional.arg);
    }

    public int hashCode() {
        int result = this.arg == null ? 0 : this.arg.hashCode();
        result = 31 * result + (this.absent ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.absent ? "Optional.empty" : "Optional[" + this.arg + "]";
    }
}

