/*
 * Decompiled with CFR 0.152.
 */
package com.github.underscore;

import com.github.underscore.U;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public final class Json {
    private static final String NULL = "null";
    private static final String DIGIT = "digit";

    private Json() {
    }

    public static String toJson(Collection collection, JsonStringBuilder.Step identStep) {
        JsonStringBuilder builder = new JsonStringBuilder(identStep);
        JsonArray.writeJson(collection, builder);
        return builder.toString();
    }

    public static String toJson(Collection collection) {
        return Json.toJson(collection, JsonStringBuilder.Step.TWO_SPACES);
    }

    public static String toJson(Map map, JsonStringBuilder.Step identStep) {
        JsonStringBuilder builder = new JsonStringBuilder(identStep);
        JsonObject.writeJson(map, builder);
        return builder.toString();
    }

    public static String toJson(Map map) {
        return Json.toJson(map, JsonStringBuilder.Step.TWO_SPACES);
    }

    public static String toJsonJavaString(Collection collection) {
        JsonStringBuilder builder = new JsonStringBuilder(JsonStringBuilder.Type.JAVA);
        JsonArray.writeJson(collection, builder);
        return builder.toString();
    }

    public static String toJsonJavaString(Map map) {
        JsonStringBuilder builder = new JsonStringBuilder(JsonStringBuilder.Type.JAVA);
        JsonObject.writeJson(map, builder);
        return builder.toString();
    }

    public static Object fromJson(String string) {
        return new JsonParser(string).parse();
    }

    public static String formatJson(String json, JsonStringBuilder.Step identStep) {
        Object result = Json.fromJson(json);
        if (result instanceof Map) {
            return Json.toJson((Map)result, identStep);
        }
        return Json.toJson((List)result, identStep);
    }

    public static String formatJson(String json) {
        return Json.formatJson(json, JsonStringBuilder.Step.TWO_SPACES);
    }

    public static class JsonParser {
        private final String json;
        private int index;
        private int line;
        private int lineOffset;
        private int current;
        private StringBuilder captureBuffer;
        private int captureStart;

        public JsonParser(String string) {
            this.json = string;
            this.line = 1;
            this.captureStart = -1;
        }

        public Object parse() {
            this.read();
            this.skipWhiteSpace();
            Object result = this.readValue();
            this.skipWhiteSpace();
            if (!this.isEndOfText()) {
                throw this.error("Unexpected character");
            }
            return result;
        }

        private Object readValue() {
            switch (this.current) {
                case 110: {
                    return this.readNull();
                }
                case 116: {
                    return this.readTrue();
                }
                case 102: {
                    return this.readFalse();
                }
                case 34: {
                    return this.readString();
                }
                case 91: {
                    return this.readArray();
                }
                case 123: {
                    return this.readObject();
                }
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.readNumber();
                }
            }
            throw this.expected("value");
        }

        private List<Object> readArray() {
            this.read();
            List<Object> array = U.newArrayList();
            this.skipWhiteSpace();
            if (this.readChar(']')) {
                return array;
            }
            do {
                this.skipWhiteSpace();
                array.add(this.readValue());
                this.skipWhiteSpace();
            } while (this.readChar(','));
            if (!this.readChar(']')) {
                throw this.expected("',' or ']'");
            }
            return array;
        }

        private Map<String, Object> readObject() {
            this.read();
            Map<String, Object> object = U.newLinkedHashMap();
            this.skipWhiteSpace();
            if (this.readChar('}')) {
                return object;
            }
            do {
                this.skipWhiteSpace();
                String name = this.readName();
                this.skipWhiteSpace();
                if (!this.readChar(':')) {
                    throw this.expected("':'");
                }
                this.skipWhiteSpace();
                object.put(name, this.readValue());
                this.skipWhiteSpace();
            } while (this.readChar(','));
            if (!this.readChar('}')) {
                throw this.expected("',' or '}'");
            }
            return object;
        }

        private String readName() {
            if (this.current != 34) {
                throw this.expected("name");
            }
            return this.readString();
        }

        private String readNull() {
            this.read();
            this.readRequiredChar('u');
            this.readRequiredChar('l');
            this.readRequiredChar('l');
            return null;
        }

        private Boolean readTrue() {
            this.read();
            this.readRequiredChar('r');
            this.readRequiredChar('u');
            this.readRequiredChar('e');
            return Boolean.TRUE;
        }

        private Boolean readFalse() {
            this.read();
            this.readRequiredChar('a');
            this.readRequiredChar('l');
            this.readRequiredChar('s');
            this.readRequiredChar('e');
            return Boolean.FALSE;
        }

        private void readRequiredChar(char ch) {
            if (!this.readChar(ch)) {
                throw this.expected("'" + ch + "'");
            }
        }

        private String readString() {
            this.read();
            this.startCapture();
            while (this.current != 34) {
                if (this.current == 92) {
                    this.pauseCapture();
                    this.readEscape();
                    this.startCapture();
                    continue;
                }
                if (this.current < 32) {
                    throw this.expected("valid string character");
                }
                this.read();
            }
            String string = this.endCapture();
            this.read();
            return string;
        }

        private void readEscape() {
            this.read();
            switch (this.current) {
                case 34: 
                case 47: 
                case 92: {
                    this.captureBuffer.append((char)this.current);
                    break;
                }
                case 98: {
                    this.captureBuffer.append('\b');
                    break;
                }
                case 102: {
                    this.captureBuffer.append('\f');
                    break;
                }
                case 110: {
                    this.captureBuffer.append('\n');
                    break;
                }
                case 114: {
                    this.captureBuffer.append('\r');
                    break;
                }
                case 116: {
                    this.captureBuffer.append('\t');
                    break;
                }
                case 117: {
                    char[] hexChars = new char[4];
                    boolean isHexCharsDigits = true;
                    for (int i = 0; i < 4; ++i) {
                        this.read();
                        if (!this.isHexDigit()) {
                            isHexCharsDigits = false;
                        }
                        hexChars[i] = (char)this.current;
                    }
                    if (isHexCharsDigits) {
                        this.captureBuffer.append((char)Integer.parseInt(new String(hexChars), 16));
                        break;
                    }
                    this.captureBuffer.append("\\u").append(hexChars[0]).append(hexChars[1]).append(hexChars[2]).append(hexChars[3]);
                    break;
                }
                default: {
                    throw this.expected("valid escape sequence");
                }
            }
            this.read();
        }

        private Number readNumber() {
            this.startCapture();
            this.readChar('-');
            int firstDigit = this.current;
            if (!this.readDigit()) {
                throw this.expected(Json.DIGIT);
            }
            if (firstDigit != 48) {
                while (this.readDigit()) {
                }
            }
            this.readFraction();
            this.readExponent();
            String number = this.endCapture();
            Number result = number.contains(".") || number.contains("e") || number.contains("E") ? (Number)(number.length() > 9 || number.contains(".") && number.length() - number.lastIndexOf(46) > 2 && number.charAt(number.length() - 1) == '0' ? new BigDecimal(number) : Double.valueOf(number)) : (Number)(number.length() > 19 ? new BigInteger(number) : Long.valueOf(number));
            return result;
        }

        private boolean readFraction() {
            if (!this.readChar('.')) {
                return false;
            }
            if (!this.readDigit()) {
                throw this.expected(Json.DIGIT);
            }
            while (this.readDigit()) {
            }
            return true;
        }

        private boolean readExponent() {
            if (!this.readChar('e') && !this.readChar('E')) {
                return false;
            }
            if (!this.readChar('+')) {
                this.readChar('-');
            }
            if (!this.readDigit()) {
                throw this.expected(Json.DIGIT);
            }
            while (this.readDigit()) {
            }
            return true;
        }

        private boolean readChar(char ch) {
            if (this.current != ch) {
                return false;
            }
            this.read();
            return true;
        }

        private boolean readDigit() {
            if (!this.isDigit()) {
                return false;
            }
            this.read();
            return true;
        }

        private void skipWhiteSpace() {
            while (this.isWhiteSpace()) {
                this.read();
            }
        }

        private void read() {
            if (this.index == this.json.length()) {
                this.current = -1;
                return;
            }
            if (this.current == 10) {
                ++this.line;
                this.lineOffset = this.index;
            }
            this.current = this.json.charAt(this.index++);
        }

        private void startCapture() {
            if (this.captureBuffer == null) {
                this.captureBuffer = new StringBuilder();
            }
            this.captureStart = this.index - 1;
        }

        private void pauseCapture() {
            this.captureBuffer.append(this.json, this.captureStart, this.index - 1);
            this.captureStart = -1;
        }

        private String endCapture() {
            String captured;
            int end;
            int n = end = this.current == -1 ? this.index : this.index - 1;
            if (this.captureBuffer.length() > 0) {
                this.captureBuffer.append(this.json, this.captureStart, end);
                captured = this.captureBuffer.toString();
                this.captureBuffer.setLength(0);
            } else {
                captured = this.json.substring(this.captureStart, end);
            }
            this.captureStart = -1;
            return captured;
        }

        private ParseException expected(String expected) {
            if (this.isEndOfText()) {
                return this.error("Unexpected end of input");
            }
            return this.error("Expected " + expected);
        }

        private ParseException error(String message) {
            int absIndex = this.index;
            int column = absIndex - this.lineOffset;
            int offset = this.isEndOfText() ? absIndex : absIndex - 1;
            return new ParseException(message, offset, this.line, column - 1);
        }

        private boolean isWhiteSpace() {
            return this.current == 32 || this.current == 9 || this.current == 10 || this.current == 13;
        }

        private boolean isDigit() {
            return this.current >= 48 && this.current <= 57;
        }

        private boolean isHexDigit() {
            return this.isDigit() || this.current >= 97 && this.current <= 102 || this.current >= 65 && this.current <= 70;
        }

        private boolean isEndOfText() {
            return this.current == -1;
        }
    }

    public static class ParseException
    extends RuntimeException {
        private final int offset;
        private final int line;
        private final int column;

        public ParseException(String message, int offset, int line, int column) {
            super(message + " at " + line + ":" + column);
            this.offset = offset;
            this.line = line;
            this.column = column;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }

    public static class JsonValue {
        private JsonValue() {
        }

        public static void writeJson(Object value, JsonStringBuilder builder) {
            if (value == null) {
                builder.append(Json.NULL);
            } else if (value instanceof String) {
                builder.append(builder.type.getWrapLine()).append(JsonValue.escape((String)value)).append(builder.type.getWrapLine());
            } else if (value instanceof Double) {
                if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                    builder.append(Json.NULL);
                } else {
                    builder.append(value.toString());
                }
            } else if (value instanceof Float) {
                if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                    builder.append(Json.NULL);
                } else {
                    builder.append(value.toString());
                }
            } else if (value instanceof Number) {
                builder.append(value.toString());
            } else if (value instanceof Boolean) {
                builder.append(value.toString());
            } else if (value instanceof Map) {
                JsonObject.writeJson((Map)value, builder);
            } else if (value instanceof Collection) {
                JsonArray.writeJson((Collection)value, builder);
            } else {
                JsonValue.doWriteJson(value, builder);
            }
        }

        private static void doWriteJson(Object value, JsonStringBuilder builder) {
            if (value instanceof byte[]) {
                JsonArray.writeJson((byte[])value, builder);
            } else if (value instanceof short[]) {
                JsonArray.writeJson((short[])value, builder);
            } else if (value instanceof int[]) {
                JsonArray.writeJson((int[])value, builder);
            } else if (value instanceof long[]) {
                JsonArray.writeJson((long[])value, builder);
            } else if (value instanceof float[]) {
                JsonArray.writeJson((float[])value, builder);
            } else if (value instanceof double[]) {
                JsonArray.writeJson((double[])value, builder);
            } else if (value instanceof boolean[]) {
                JsonArray.writeJson((boolean[])value, builder);
            } else if (value instanceof char[]) {
                JsonArray.writeJson((char[])value, builder);
            } else if (value instanceof Object[]) {
                JsonArray.writeJson((Object[])value, builder);
            } else {
                builder.append(value.toString());
            }
        }

        public static String escape(String s) {
            if (s == null) {
                return null;
            }
            StringJoiner sb = new StringJoiner("");
            JsonValue.escape(s, sb);
            return sb.toString();
        }

        private static void escape(String s, StringJoiner sb) {
            int len = s.length();
            block10: for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\"': {
                        sb.add("\\\"");
                        continue block10;
                    }
                    case '\\': {
                        sb.add("\\\\");
                        continue block10;
                    }
                    case '\b': {
                        sb.add("\\b");
                        continue block10;
                    }
                    case '\f': {
                        sb.add("\\f");
                        continue block10;
                    }
                    case '\n': {
                        sb.add("\\n");
                        continue block10;
                    }
                    case '\r': {
                        sb.add("\\r");
                        continue block10;
                    }
                    case '\t': {
                        sb.add("\\t");
                        continue block10;
                    }
                    case '\u20ac': {
                        sb.add("\u20ac");
                        continue block10;
                    }
                    default: {
                        if (ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                            String ss = Integer.toHexString(ch);
                            sb.add("\\u");
                            for (int k = 0; k < 4 - ss.length(); ++k) {
                                sb.add("0");
                            }
                            sb.add(ss.toUpperCase());
                            continue block10;
                        }
                        sb.add(String.valueOf(ch));
                    }
                }
            }
        }
    }

    public static class JsonObject {
        private JsonObject() {
        }

        public static void writeJson(Map map, JsonStringBuilder builder) {
            if (map == null) {
                builder.append(Json.NULL);
                return;
            }
            Iterator iter = map.entrySet().iterator();
            builder.append('{').incIdent();
            if (!map.isEmpty()) {
                builder.newLine();
            }
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                builder.fillSpaces().append(builder.type.getWrapLine());
                builder.append(JsonValue.escape(String.valueOf(entry.getKey())));
                builder.append(builder.type.getWrapLine());
                builder.append(':');
                if (builder.getIdentStep() != JsonStringBuilder.Step.COMPACT) {
                    builder.append(' ');
                }
                JsonValue.writeJson(entry.getValue(), builder);
                if (!iter.hasNext()) continue;
                builder.append(',').newLine();
            }
            builder.newLine().decIdent().fillSpaces().append('}');
        }
    }

    public static class JsonArray {
        private JsonArray() {
        }

        public static void writeJson(Collection collection, JsonStringBuilder builder) {
            if (collection == null) {
                builder.append(Json.NULL);
                return;
            }
            Iterator iter = collection.iterator();
            builder.append('[').incIdent();
            if (!collection.isEmpty()) {
                builder.newLine();
            }
            while (iter.hasNext()) {
                Object value = iter.next();
                builder.fillSpaces();
                JsonValue.writeJson(value, builder);
                if (!iter.hasNext()) continue;
                builder.append(',').newLine();
            }
            builder.newLine().decIdent().fillSpaces().append(']');
        }

        public static void writeJson(byte[] array, JsonStringBuilder builder) {
            if (array == null) {
                builder.append(Json.NULL);
            } else if (array.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIdent().newLine();
                builder.fillSpaces().append(String.valueOf(array[0]));
                for (int i = 1; i < array.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append(String.valueOf(array[i]));
                }
                builder.newLine().decIdent().fillSpaces().append(']');
            }
        }

        public static void writeJson(short[] array, JsonStringBuilder builder) {
            if (array == null) {
                builder.append(Json.NULL);
            } else if (array.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIdent().newLine();
                builder.fillSpaces().append(String.valueOf(array[0]));
                for (int i = 1; i < array.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append(String.valueOf(array[i]));
                }
                builder.newLine().decIdent().fillSpaces().append(']');
            }
        }

        public static void writeJson(int[] array, JsonStringBuilder builder) {
            if (array == null) {
                builder.append(Json.NULL);
            } else if (array.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIdent().newLine();
                builder.fillSpaces().append(String.valueOf(array[0]));
                for (int i = 1; i < array.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append(String.valueOf(array[i]));
                }
                builder.newLine().decIdent().fillSpaces().append(']');
            }
        }

        public static void writeJson(long[] array, JsonStringBuilder builder) {
            if (array == null) {
                builder.append(Json.NULL);
            } else if (array.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIdent().newLine();
                builder.fillSpaces().append(String.valueOf(array[0]));
                for (int i = 1; i < array.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append(String.valueOf(array[i]));
                }
                builder.newLine().decIdent().fillSpaces().append(']');
            }
        }

        public static void writeJson(float[] array, JsonStringBuilder builder) {
            if (array == null) {
                builder.append(Json.NULL);
            } else if (array.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIdent().newLine();
                builder.fillSpaces().append(String.valueOf(array[0]));
                for (int i = 1; i < array.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append(String.valueOf(array[i]));
                }
                builder.newLine().decIdent().fillSpaces().append(']');
            }
        }

        public static void writeJson(double[] array, JsonStringBuilder builder) {
            if (array == null) {
                builder.append(Json.NULL);
            } else if (array.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIdent().newLine();
                builder.fillSpaces().append(String.valueOf(array[0]));
                for (int i = 1; i < array.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append(String.valueOf(array[i]));
                }
                builder.newLine().decIdent().fillSpaces().append(']');
            }
        }

        public static void writeJson(boolean[] array, JsonStringBuilder builder) {
            if (array == null) {
                builder.append(Json.NULL);
            } else if (array.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIdent().newLine();
                builder.fillSpaces().append(String.valueOf(array[0]));
                for (int i = 1; i < array.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append(String.valueOf(array[i]));
                }
                builder.newLine().decIdent().fillSpaces().append(']');
            }
        }

        public static void writeJson(char[] array, JsonStringBuilder builder) {
            if (array == null) {
                builder.append(Json.NULL);
            } else if (array.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIdent().newLine();
                builder.fillSpaces().append('\"').append(String.valueOf(array[0])).append('\"');
                for (int i = 1; i < array.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append('\"').append(String.valueOf(array[i])).append('\"');
                }
                builder.newLine().decIdent().fillSpaces().append(']');
            }
        }

        public static void writeJson(Object[] array, JsonStringBuilder builder) {
            if (array == null) {
                builder.append(Json.NULL);
            } else if (array.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').newLine().incIdent().fillSpaces();
                JsonValue.writeJson(array[0], builder);
                for (int i = 1; i < array.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    JsonValue.writeJson(array[i], builder);
                }
                builder.newLine().decIdent().fillSpaces().append(']');
            }
        }
    }

    public static class JsonStringBuilder {
        private final StringJoiner builder;
        private final Step identStep;
        private final Type type;
        private int ident;

        public JsonStringBuilder(Step identStep) {
            this.builder = new StringJoiner("").add(Type.PURE.getInitial());
            this.identStep = identStep;
            this.type = Type.PURE;
        }

        public JsonStringBuilder(Type type) {
            this.builder = new StringJoiner("").add(type.getInitial());
            this.identStep = Step.TWO_SPACES;
            this.type = type;
        }

        public JsonStringBuilder() {
            this.builder = new StringJoiner("");
            this.identStep = Step.TWO_SPACES;
            this.type = Type.PURE;
        }

        public JsonStringBuilder append(char character) {
            this.builder.add(String.valueOf(character));
            return this;
        }

        public JsonStringBuilder append(String string) {
            this.builder.add(string);
            return this;
        }

        public JsonStringBuilder fillSpaces() {
            for (int index = 0; index < this.ident; ++index) {
                this.builder.add(String.valueOf(this.identStep == Step.TABS ? (char)'\t' : ' '));
            }
            return this;
        }

        public JsonStringBuilder incIdent() {
            this.ident += this.identStep.getIdent();
            return this;
        }

        public JsonStringBuilder decIdent() {
            this.ident -= this.identStep.getIdent();
            return this;
        }

        public JsonStringBuilder newLine() {
            if (this.identStep != Step.COMPACT) {
                this.builder.add(this.type.getNewLine());
            }
            return this;
        }

        public Step getIdentStep() {
            return this.identStep;
        }

        public String toString() {
            return this.builder.toString() + this.type.getTailLine();
        }

        public static enum Type {
            PURE("", "\n", "", "\""),
            JAVA("\"", "\\n\"\n + \"", "\";", "\\\"");

            private final String initial;
            private final String newLine;
            private final String tailLine;
            private final String wrapLine;

            private Type(String initial, String newLine, String tailLine, String wrapLine) {
                this.initial = initial;
                this.newLine = newLine;
                this.tailLine = tailLine;
                this.wrapLine = wrapLine;
            }

            public String getInitial() {
                return this.initial;
            }

            public String getNewLine() {
                return this.newLine;
            }

            public String getTailLine() {
                return this.tailLine;
            }

            public String getWrapLine() {
                return this.wrapLine;
            }
        }

        public static enum Step {
            TWO_SPACES(2),
            THREE_SPACES(3),
            FOUR_SPACES(4),
            COMPACT(0),
            TABS(1);

            private final int ident;

            private Step(int ident) {
                this.ident = ident;
            }

            public int getIdent() {
                return this.ident;
            }
        }
    }
}

