/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.main;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.Frozen;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.JsonPointerException;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.exceptions.unchecked.ProcessingError;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.load.RefResolver;
import com.github.fge.jsonschema.load.SchemaLoader;
import com.github.fge.jsonschema.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactoryBuilder;
import com.github.fge.jsonschema.main.JsonValidator;
import com.github.fge.jsonschema.messages.JsonSchemaConfigurationBundle;
import com.github.fge.jsonschema.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processing.ProcessorMap;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.processors.data.SchemaContext;
import com.github.fge.jsonschema.processors.data.ValidatorList;
import com.github.fge.jsonschema.processors.syntax.SyntaxValidator;
import com.github.fge.jsonschema.processors.validation.ValidationChain;
import com.github.fge.jsonschema.processors.validation.ValidationProcessor;
import com.github.fge.jsonschema.ref.JsonRef;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ReportProvider;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.serviceloader.MessageBundleFactory;
import com.google.common.base.Function;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JsonSchemaFactory
implements Frozen<JsonSchemaFactoryBuilder> {
    private static final MessageBundle BUNDLE = MessageBundleFactory.getBundle(JsonSchemaConfigurationBundle.class);
    private static final MessageBundle CORE_BUNDLE = MessageBundleFactory.getBundle(JsonSchemaCoreMessageBundle.class);
    private static final Function<SchemaContext, JsonRef> FUNCTION = new Function<SchemaContext, JsonRef>(){

        public JsonRef apply(SchemaContext input) {
            return input.getSchema().getDollarSchema();
        }
    };
    final ReportProvider reportProvider;
    final LoadingConfiguration loadingCfg;
    final ValidationConfiguration validationCfg;
    private final SchemaLoader loader;
    private final JsonValidator validator;
    private final SyntaxValidator syntaxValidator;

    public static JsonSchemaFactory byDefault() {
        return JsonSchemaFactory.newBuilder().freeze();
    }

    public static JsonSchemaFactoryBuilder newBuilder() {
        return new JsonSchemaFactoryBuilder();
    }

    JsonSchemaFactory(JsonSchemaFactoryBuilder builder) {
        this.reportProvider = builder.reportProvider;
        this.loadingCfg = builder.loadingCfg;
        this.validationCfg = builder.validationCfg;
        this.loader = new SchemaLoader(this.loadingCfg);
        Processor<SchemaContext, ValidatorList> processor = this.buildProcessor();
        this.validator = new JsonValidator(this.loader, new ValidationProcessor(this.validationCfg, processor), this.reportProvider);
        this.syntaxValidator = new SyntaxValidator(this.validationCfg);
    }

    public JsonValidator getValidator() {
        return this.validator;
    }

    public SyntaxValidator getSyntaxValidator() {
        return this.syntaxValidator;
    }

    public JsonSchema getJsonSchema(JsonNode schema) throws ProcessingException {
        BUNDLE.checkNotNull((Object)schema, "nullSchema");
        return this.validator.buildJsonSchema(schema, JsonPointer.empty());
    }

    public JsonSchema getJsonSchema(JsonNode schema, String ptr) throws ProcessingException {
        BUNDLE.checkNotNull((Object)schema, "nullSchema");
        CORE_BUNDLE.checkNotNull((Object)ptr, "nullPointer");
        try {
            JsonPointer pointer = new JsonPointer(ptr);
            return this.validator.buildJsonSchema(schema, pointer);
        }
        catch (JsonPointerException jsonPointerException) {
            throw new ProcessingError(new ProcessingMessage().setMessage("How did I get there??"));
        }
    }

    public JsonSchema getJsonSchema(String uri) throws ProcessingException {
        CORE_BUNDLE.checkNotNull((Object)uri, "nullURI");
        return this.validator.buildJsonSchema(uri);
    }

    public Processor<FullData, FullData> getProcessor() {
        return this.validator.getProcessor();
    }

    public JsonSchemaFactoryBuilder thaw() {
        return new JsonSchemaFactoryBuilder(this);
    }

    private Processor<SchemaContext, ValidatorList> buildProcessor() {
        RefResolver resolver = new RefResolver(this.loader);
        Map<JsonRef, Library> libraries = this.validationCfg.getLibraries();
        Library defaultLibrary = this.validationCfg.getDefaultLibrary();
        ValidationChain defaultChain = new ValidationChain(resolver, defaultLibrary, this.validationCfg);
        ProcessorMap map = new ProcessorMap(FUNCTION);
        map.setDefaultProcessor((Processor)defaultChain);
        for (Map.Entry<JsonRef, Library> entry : libraries.entrySet()) {
            JsonRef ref = entry.getKey();
            ValidationChain chain = new ValidationChain(resolver, entry.getValue(), this.validationCfg);
            map.addEntry((Object)ref, (Processor)chain);
        }
        return map.getProcessor();
    }
}

