/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.main.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.cli.CustomHelpFormatter;
import com.github.fge.jsonschema.main.cli.Reporter;
import com.github.fge.jsonschema.main.cli.Reporters;
import com.github.fge.jsonschema.main.cli.RetCode;
import com.github.fge.jsonschema.processors.syntax.SyntaxValidator;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import joptsimple.HelpFormatter;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public final class Main {
    private static final HelpFormatter HELP = new CustomHelpFormatter();
    private static final ObjectMapper MAPPER = JacksonUtils.newMapper();
    private final JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
    private final SyntaxValidator syntaxValidator = this.factory.getSyntaxValidator();

    public static void main(String ... args) throws IOException, ProcessingException {
        boolean isSyntax;
        OptionSet optionSet;
        OptionParser parser = new OptionParser();
        parser.accepts("syntax", "check the syntax of schema(s) given as argument(s)");
        parser.acceptsAll(Arrays.asList("s", "brief"), "only show validation status (OK/NOT OK)");
        parser.acceptsAll(Arrays.asList("q", "quiet"), "no output; exit with the relevant return code (see below)");
        parser.accepts("help", "show this help").forHelp();
        parser.formatHelpWith(HELP);
        Reporters reporter = Reporters.DEFAULT;
        try {
            optionSet = parser.parse(args);
        }
        catch (OptionException e) {
            System.err.println("unrecognized option(s): " + CustomHelpFormatter.OPTIONS_JOINER.join((Iterable)e.options()));
            parser.printHelpOn((OutputStream)System.err);
            System.exit(RetCode.CMD_ERROR.get());
            throw new IllegalStateException("WTF??");
        }
        if (optionSet.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(RetCode.ALL_OK.get());
        }
        if (optionSet.has("s") && optionSet.has("q")) {
            System.err.println("cannot specify both \"--brief\" and \"--quiet\"");
            parser.printHelpOn((OutputStream)System.err);
            System.exit(RetCode.CMD_ERROR.get());
        }
        int requiredArgs = (isSyntax = optionSet.has("syntax")) ? 1 : 2;
        List arguments = optionSet.nonOptionArguments();
        if (arguments.size() < requiredArgs) {
            System.err.println("missing arguments");
            parser.printHelpOn((OutputStream)System.err);
            System.exit(RetCode.CMD_ERROR.get());
        }
        ArrayList files = Lists.newArrayList();
        for (String target : arguments) {
            files.add(new File(target).getCanonicalFile());
        }
        if (optionSet.has("brief")) {
            reporter = Reporters.BRIEF;
        } else if (optionSet.has("quiet")) {
            System.out.close();
            System.err.close();
            reporter = Reporters.QUIET;
        }
        new Main().proceed(reporter, isSyntax, files);
    }

    private void proceed(Reporter reporter, boolean isSyntax, List<File> files) throws IOException, ProcessingException {
        RetCode retCode = isSyntax ? this.doSyntax(reporter, files) : this.doValidation(reporter, files);
        System.exit(retCode.get());
    }

    private RetCode doSyntax(Reporter reporter, List<File> files) throws IOException {
        RetCode ret = RetCode.ALL_OK;
        for (File file : files) {
            JsonNode node;
            String fileName = file.toString();
            RetCode retcode = reporter.validateSchema(this.syntaxValidator, fileName, node = MAPPER.readTree(file));
            if (retcode == RetCode.ALL_OK) continue;
            ret = retcode;
        }
        return ret;
    }

    private RetCode doValidation(Reporter reporter, List<File> files) throws IOException, ProcessingException {
        File schemaFile = files.remove(0);
        JsonNode node = MAPPER.readTree(schemaFile);
        if (!this.syntaxValidator.schemaIsValid(node)) {
            System.err.println("Schema is invalid! Aborting...");
            return RetCode.SCHEMA_SYNTAX_ERROR;
        }
        JsonSchema schema = this.factory.getJsonSchema(node);
        RetCode ret = RetCode.ALL_OK;
        for (File file : files) {
            node = MAPPER.readTree(file);
            RetCode retcode = reporter.validateInstance(schema, file.toString(), node);
            if (retcode == RetCode.ALL_OK) continue;
            ret = retcode;
        }
        return ret;
    }
}

