/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.report.ValidationReport;
import com.github.fge.jsonschema.util.RhinoHelper;
import com.github.fge.jsonschema.util.jackson.JacksonUtils;
import com.github.fge.jsonschema.validator.JsonValidator;
import com.github.fge.jsonschema.validator.ValidationContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class ObjectValidator
implements JsonValidator {
    private final JsonNode additionalProperties;
    private final Map<String, JsonNode> properties;
    private final Map<String, JsonNode> patternProperties;

    ObjectValidator(JsonNode schema) {
        JsonNode node = schema.path("additionalProperties");
        this.additionalProperties = node.isObject() ? node : JacksonUtils.emptyObject();
        node = schema.path("properties");
        this.properties = JacksonUtils.asMap(node);
        node = schema.path("patternProperties");
        this.patternProperties = JacksonUtils.asMap(node);
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        Map<String, JsonNode> map = JacksonUtils.asMap(instance);
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            report.pushd(entry.getKey());
            boolean keepGoing = this.validateOne(context, report, entry);
            report.popd();
            if (keepGoing) continue;
            break;
        }
    }

    private boolean validateOne(ValidationContext context, ValidationReport report, Map.Entry<String, JsonNode> entry) {
        String key = entry.getKey();
        JsonNode value = entry.getValue();
        Set<JsonNode> subSchemas = this.getSchemas(key);
        for (JsonNode subSchema : subSchemas) {
            JsonValidator validator = context.newValidator(subSchema);
            validator.validate(context, report, value);
            if (!report.hasFatalError()) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    Set<JsonNode> getSchemas(String key) {
        HashSet ret = Sets.newHashSet();
        if (this.properties.containsKey(key)) {
            ret.add(this.properties.get(key));
        }
        for (Map.Entry<String, JsonNode> entry : this.patternProperties.entrySet()) {
            if (!RhinoHelper.regMatch(entry.getKey(), key)) continue;
            ret.add(entry.getValue());
        }
        if (ret.isEmpty()) {
            ret.add(this.additionalProperties);
        }
        return ImmutableSet.copyOf((Collection)ret);
    }
}

