/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.syntax.hyperschema.draftv3;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.report.Message;
import com.github.fge.jsonschema.syntax.AbstractSyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxChecker;
import com.github.fge.jsonschema.syntax.SyntaxValidator;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public final class FragmentResolutionSyntaxChecker
extends AbstractSyntaxChecker {
    private static final SyntaxChecker INSTANCE = new FragmentResolutionSyntaxChecker();
    private static final Set<String> PROTOCOLS = ImmutableSet.of((Object)"slash-delimited", (Object)"dot-delimited");

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private FragmentResolutionSyntaxChecker() {
        super("fragmentResolution", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void checkValue(SyntaxValidator validator, List<Message> messages, JsonNode schema) {
        String protocol = schema.get(this.keyword).textValue();
        if (PROTOCOLS.contains(protocol)) {
            return;
        }
        messages.add(this.newMsg().addInfo("possible-values", PROTOCOLS).setMessage("unknown fragment resolution protocol").addInfo("found", protocol).build());
    }
}

